/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.jsonb.vertx;

import io.vertx.core.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VertxJson {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();

    private VertxJson() {
    }

    public static void copy(io.vertx.core.json.JsonObject object, JsonObject origin) {
        origin.keySet().forEach(key -> {
            JsonValue value = (JsonValue)origin.get(key);
            JsonValue.ValueType kind = value.getValueType();
            switch (kind) {
                case STRING: {
                    object.put(key, (Object)origin.getString(key));
                    break;
                }
                case NULL: {
                    object.putNull(key);
                    break;
                }
                case TRUE: {
                    object.put(key, (Object)true);
                    break;
                }
                case FALSE: {
                    object.put(key, (Object)false);
                    break;
                }
                case NUMBER: {
                    JsonNumber number = origin.getJsonNumber(key);
                    if (number.isIntegral()) {
                        object.put(key, (Object)number.longValue());
                        break;
                    }
                    object.put(key, (Object)number.doubleValue());
                    break;
                }
                case ARRAY: {
                    JsonArray array = new JsonArray();
                    VertxJson.copy(array, origin.getJsonArray(key));
                    object.put(key, (Object)array);
                    break;
                }
                case OBJECT: {
                    io.vertx.core.json.JsonObject json = new io.vertx.core.json.JsonObject();
                    VertxJson.copy(json, origin.getJsonObject(key));
                    object.put(key, (Object)json);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JSON Value " + kind);
                }
            }
        });
    }

    public static void copy(JsonArray array, jakarta.json.JsonArray origin) {
        block9: for (int i = 0; i < origin.size(); ++i) {
            JsonValue value = (JsonValue)origin.get(i);
            JsonValue.ValueType kind = value.getValueType();
            switch (kind) {
                case STRING: {
                    array.add((Object)origin.getString(i));
                    continue block9;
                }
                case TRUE: {
                    array.add((Object)true);
                    continue block9;
                }
                case FALSE: {
                    array.add((Object)false);
                    continue block9;
                }
                case NULL: {
                    array.addNull();
                    continue block9;
                }
                case NUMBER: {
                    JsonNumber number = origin.getJsonNumber(i);
                    if (number.isIntegral()) {
                        array.add((Object)number.longValue());
                        continue block9;
                    }
                    array.add((Object)number.doubleValue());
                    continue block9;
                }
                case ARRAY: {
                    JsonArray newArray = new JsonArray();
                    VertxJson.copy(newArray, origin.getJsonArray(i));
                    array.add((Object)newArray);
                    continue block9;
                }
                case OBJECT: {
                    io.vertx.core.json.JsonObject newObject = new io.vertx.core.json.JsonObject();
                    VertxJson.copy(newObject, origin.getJsonObject(i));
                    array.add((Object)newObject);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JSON Value " + kind);
                }
            }
        }
    }

    public static class JsonObjectDeserializer
    implements JsonbDeserializer<io.vertx.core.json.JsonObject> {
        public io.vertx.core.json.JsonObject deserialize(JsonParser parser, DeserializationContext context, Type type) {
            io.vertx.core.json.JsonObject object = new io.vertx.core.json.JsonObject();
            VertxJson.copy(object, parser.getObject());
            return object;
        }
    }

    public static class JsonArraySerializer
    implements JsonbSerializer<JsonArray> {
        public void serialize(JsonArray json, JsonGenerator generator, SerializationContext ctxt) {
            List list = json.getList();
            ArrayList<String> copy = new ArrayList<String>();
            for (Object o : list) {
                if (o instanceof byte[]) {
                    copy.add(BASE64_ENCODER.encodeToString((byte[])o));
                    continue;
                }
                copy.add((String)o);
            }
            ctxt.serialize(copy, generator);
        }
    }

    public static class JsonArrayDeserializer
    implements JsonbDeserializer<JsonArray> {
        public JsonArray deserialize(JsonParser parser, DeserializationContext context, Type type) {
            JsonArray object = new JsonArray();
            VertxJson.copy(object, parser.getArray());
            return object;
        }
    }

    public static class JsonObjectSerializer
    implements JsonbSerializer<io.vertx.core.json.JsonObject> {
        public void serialize(io.vertx.core.json.JsonObject json, JsonGenerator generator, SerializationContext ctxt) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry entry : json.getMap().entrySet()) {
                if (entry.getValue() instanceof byte[]) {
                    map.put((String)entry.getKey(), BASE64_ENCODER.encodeToString((byte[])entry.getValue()));
                    continue;
                }
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            ctxt.serialize(map, generator);
        }
    }
}

