/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.links.runtime.hal;

import io.quarkus.hal.HalLink;
import io.quarkus.hal.HalService;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import org.jboss.resteasy.links.LinksProvider;
import org.jboss.resteasy.links.RESTServiceDiscovery;

@RequestScoped
public class ResteasyHalService
extends HalService {
    protected Map<String, HalLink> getClassLinks(Class<?> entityClass) {
        return this.linksToMap(LinksProvider.getClassLinksProvider().getLinks(entityClass, Thread.currentThread().getContextClassLoader()));
    }

    protected Map<String, HalLink> getInstanceLinks(Object entity) {
        return this.linksToMap(LinksProvider.getObjectLinksProvider().getLinks(entity, Thread.currentThread().getContextClassLoader()));
    }

    private Map<String, HalLink> linksToMap(RESTServiceDiscovery serviceDiscovery) {
        HashMap<String, HalLink> links = new HashMap<String, HalLink>(serviceDiscovery.size());
        for (RESTServiceDiscovery.AtomLink atomLink : serviceDiscovery) {
            links.put(atomLink.getRel(), new HalLink(atomLink.getHref()));
        }
        return links;
    }
}

