/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.links.runtime.hal;

import io.quarkus.arc.Arc;
import io.quarkus.hal.HalCollectionWrapper;
import io.quarkus.hal.HalEntityWrapper;
import io.quarkus.resteasy.links.runtime.hal.ResteasyHalService;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class HalServerResponseFilter
implements ContainerResponseFilter {
    private static final String APPLICATION_HAL_JSON = "application/hal+json";
    private static final String COLLECTION_NAME = "items";

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Object entity = responseContext.getEntity();
        if (this.isHttpStatusSuccessful(responseContext.getStatusInfo()) && this.acceptsHalMediaType(requestContext) && this.canEntityBeProcessed(entity)) {
            ResteasyHalService service = (ResteasyHalService)((Object)Arc.container().instance(ResteasyHalService.class, new Annotation[0]).get());
            if (entity instanceof Collection) {
                responseContext.setEntity((Object)service.toHalCollectionWrapper((Collection)entity, COLLECTION_NAME, this.findEntityClass(requestContext, responseContext.getEntityType())));
            } else {
                responseContext.setEntity((Object)service.toHalWrapper(entity));
            }
        }
    }

    private boolean canEntityBeProcessed(Object entity) {
        return entity != null && !(entity instanceof String) && !(entity instanceof HalEntityWrapper) && !(entity instanceof HalCollectionWrapper);
    }

    private boolean isHttpStatusSuccessful(Response.StatusType statusInfo) {
        return Response.Status.Family.SUCCESSFUL.equals((Object)statusInfo.getFamily());
    }

    private boolean acceptsHalMediaType(ContainerRequestContext requestContext) {
        List acceptMediaType = requestContext.getAcceptableMediaTypes().stream().map(MediaType::toString).collect(Collectors.toList());
        return acceptMediaType.contains(APPLICATION_HAL_JSON);
    }

    private Class<?> findEntityClass(ContainerRequestContext requestContext, Type entityType) {
        if (entityType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)entityType).getActualTypeArguments()[0];
        }
        return null;
    }
}

