/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.core.interception.jaxrs.SuspendableContainerResponseContext;

@Provider
public class TemplateResponseFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (entity instanceof TemplateInstance) {
            MediaType mediaType;
            SuspendableContainerResponseContext ctx = (SuspendableContainerResponseContext)responseContext;
            ctx.suspend();
            TemplateInstance instance = (TemplateInstance)entity;
            Object variantsAttr = instance.getAttribute("variants");
            if (variantsAttr != null) {
                ArrayList<jakarta.ws.rs.core.Variant> variants = new ArrayList<jakarta.ws.rs.core.Variant>();
                for (Variant variant : (List)variantsAttr) {
                    variants.add(new jakarta.ws.rs.core.Variant(MediaType.valueOf((String)variant.getMediaType()), variant.getLocale(), variant.getEncoding()));
                }
                jakarta.ws.rs.core.Variant selected = requestContext.getRequest().selectVariant(variants);
                if (selected != null) {
                    List acceptableLocales;
                    Locale selectedLocale = selected.getLanguage();
                    if (selectedLocale == null && !(acceptableLocales = requestContext.getAcceptableLanguages()).isEmpty()) {
                        selectedLocale = (Locale)acceptableLocales.get(0);
                    }
                    instance.setAttribute("selectedVariant", (Object)new Variant(selectedLocale, selected.getMediaType().toString(), selected.getEncoding()));
                    mediaType = selected.getMediaType();
                } else {
                    mediaType = responseContext.getMediaType();
                }
            } else {
                mediaType = responseContext.getMediaType();
            }
            CompletableFuture<String> cs = instance.renderAsync();
            if (!((Engine)Arc.container().instance(Engine.class, new Annotation[0]).get()).useAsyncTimeout()) {
                long timeout = instance.getTimeout();
                cs = cs.toCompletableFuture().orTimeout(timeout, TimeUnit.MILLISECONDS);
            }
            try {
                cs.whenComplete((r, t) -> {
                    if (t == null) {
                        if (mediaType != null) {
                            ctx.setEntity(r, null, mediaType);
                        } else {
                            ctx.setEntity(r);
                        }
                        ctx.resume();
                    } else {
                        ctx.resume(t);
                    }
                });
            }
            catch (Throwable t2) {
                ctx.resume(t2);
            }
        }
    }
}

