/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsContributorBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.VetoingAnnotationTransformer;
import io.quarkus.resteasy.reactive.common.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.reactive.spi.AbstractInterceptorBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.ReaderInterceptorBuildItem;
import io.quarkus.resteasy.reactive.spi.WriterInterceptorBuildItem;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildIem;
import io.quarkus.security.spi.SecurityTransformerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.RuntimeType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveInterceptorScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;

public class ResteasyReactiveCommonProcessor {
    @BuildStep
    void setUpDenyAllJaxRs(CombinedIndexBuildItem index, JaxRsSecurityConfig config, ResourceScanningResultBuildItem resteasyDeployment, BuildProducer<AdditionalSecuredClassesBuildIem> additionalSecuredClasses) {
        if (config.denyJaxRs) {
            ArrayList<ClassInfo> classes = new ArrayList<ClassInfo>();
            Set resourceClasses = resteasyDeployment.getResult().getScannedResourcePaths().keySet();
            for (DotName className : resourceClasses) {
                ClassInfo classInfo = index.getIndex().getClassByName(className);
                if (SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo)) continue;
                classes.add(classInfo);
            }
            additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredClassesBuildIem(classes));
        }
    }

    @BuildStep
    ApplicationResultBuildItem handleApplication(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        ApplicationScanningResult result = ResteasyReactiveScanner.scanForApplicationClass((IndexView)combinedIndexBuildItem.getComputingIndex());
        if (result.getSelectedAppClass() != null) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{result.getSelectedAppClass().name().toString()}));
        }
        return new ApplicationResultBuildItem(result);
    }

    @BuildStep
    public ResourceInterceptorsContributorBuildItem scanForIOInterceptors(final CombinedIndexBuildItem combinedIndexBuildItem, final ApplicationResultBuildItem applicationResultBuildItem) {
        return new ResourceInterceptorsContributorBuildItem(new Consumer<ResourceInterceptors>(){

            @Override
            public void accept(ResourceInterceptors interceptors) {
                ResteasyReactiveInterceptorScanner.scanForIOInterceptors((ResourceInterceptors)interceptors, (IndexView)combinedIndexBuildItem.getComputingIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
            }
        });
    }

    @BuildStep
    public ResourceInterceptorsBuildItem buildResourceInterceptors(List<ResourceInterceptorsContributorBuildItem> scanningTasks, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, List<WriterInterceptorBuildItem> writerInterceptors, List<ReaderInterceptorBuildItem> readerInterceptors, List<ContainerRequestFilterBuildItem> requestFilters, List<ContainerResponseFilterBuildItem> responseFilters) {
        ResourceInterceptors resourceInterceptors = new ResourceInterceptors();
        for (ResourceInterceptorsContributorBuildItem i : scanningTasks) {
            i.getBuildTask().accept(resourceInterceptors);
        }
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder();
        this.registerContainerBeans(beanBuilder, resourceInterceptors.getContainerResponseFilters());
        this.registerContainerBeans(beanBuilder, (InterceptorContainer<?>)resourceInterceptors.getContainerRequestFilters());
        this.registerContainerBeans(beanBuilder, resourceInterceptors.getReaderInterceptors());
        this.registerContainerBeans(beanBuilder, resourceInterceptors.getWriterInterceptors());
        Set globalNameBindings = applicationResultBuildItem.getResult().getGlobalNameBindings();
        for (WriterInterceptorBuildItem writerInterceptorBuildItem : writerInterceptors) {
            this.registerInterceptors(globalNameBindings, resourceInterceptors.getWriterInterceptors(), writerInterceptorBuildItem, beanBuilder);
        }
        for (ReaderInterceptorBuildItem readerInterceptorBuildItem : readerInterceptors) {
            this.registerInterceptors(globalNameBindings, resourceInterceptors.getReaderInterceptors(), readerInterceptorBuildItem, beanBuilder);
        }
        for (ContainerRequestFilterBuildItem containerRequestFilterBuildItem : requestFilters) {
            this.registerInterceptors(globalNameBindings, (InterceptorContainer)resourceInterceptors.getContainerRequestFilters(), (AbstractInterceptorBuildItem)containerRequestFilterBuildItem, beanBuilder);
        }
        for (ContainerResponseFilterBuildItem containerResponseFilterBuildItem : responseFilters) {
            this.registerInterceptors(globalNameBindings, resourceInterceptors.getContainerResponseFilters(), containerResponseFilterBuildItem, beanBuilder);
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.setUnremovable().build());
        return new ResourceInterceptorsBuildItem(resourceInterceptors);
    }

    protected <T, B extends AbstractInterceptorBuildItem> void registerInterceptors(Set<String> globalNameBindings, InterceptorContainer<T> interceptors, B filterItem, AdditionalBeanBuildItem.Builder beanBuilder) {
        if (filterItem.isRegisterAsBean()) {
            beanBuilder.addBeanClass(filterItem.getClassName());
        }
        ResourceInterceptor interceptor = interceptors.create();
        interceptor.setClassName(filterItem.getClassName());
        Integer priority = filterItem.getPriority();
        if (priority != null) {
            interceptor.setPriority(priority);
        }
        if (interceptors instanceof PreMatchInterceptorContainer && ((ContainerRequestFilterBuildItem)filterItem).isPreMatching()) {
            ((PreMatchInterceptorContainer)interceptors).addPreMatchInterceptor(interceptor);
        } else {
            Set nameBindingNames = filterItem.getNameBindingNames();
            if (nameBindingNames.isEmpty() || this.namePresent(nameBindingNames, globalNameBindings)) {
                interceptors.addGlobalRequestInterceptor(interceptor);
            } else {
                interceptor.setNameBindingNames(nameBindingNames);
                interceptors.addNameRequestInterceptor(interceptor);
            }
        }
    }

    private void registerContainerBeans(AdditionalBeanBuildItem.Builder additionalProviders, InterceptorContainer<?> container) {
        for (ResourceInterceptor i : container.getGlobalResourceInterceptors()) {
            additionalProviders.addBeanClass(i.getClassName());
        }
        for (ResourceInterceptor i : container.getNameResourceInterceptors()) {
            additionalProviders.addBeanClass(i.getClassName());
        }
        if (container instanceof PreMatchInterceptorContainer) {
            for (ResourceInterceptor i : ((PreMatchInterceptorContainer)container).getPreMatchInterceptors()) {
                additionalProviders.addBeanClass(i.getClassName());
            }
        }
    }

    private boolean namePresent(Set<String> nameBindingNames, Set<String> globalNameBindings) {
        for (String i : globalNameBindings) {
            if (!nameBindingNames.contains(i)) continue;
            return true;
        }
        return false;
    }

    @BuildStep
    void scanResources(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformerBuildItemBuildProducer, BuildProducer<ResourceScanningResultBuildItem> resourceScanningResultBuildItemBuildProducer) {
        ResourceScanningResult res = ResteasyReactiveScanner.scanResources((IndexView)combinedIndexBuildItem.getComputingIndex());
        if (res == null) {
            return;
        }
        if (!res.getResourcesThatNeedCustomProducer().isEmpty()) {
            annotationsTransformerBuildItemBuildProducer.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new VetoingAnnotationTransformer(res.getResourcesThatNeedCustomProducer().keySet())));
        }
        resourceScanningResultBuildItemBuildProducer.produce((BuildItem)new ResourceScanningResultBuildItem(res));
    }

    @BuildStep
    public void setupEndpoints(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BeanContainerBuildItem beanContainerBuildItem, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<MessageBodyWriterBuildItem> messageBodyWriterBuildItemBuildProducer, BuildProducer<MessageBodyReaderBuildItem> messageBodyReaderBuildItemBuildProducer) throws NoSuchMethodException {
        AnnotationInstance constrainedToInstance;
        ApplicationScanningResult.KeepProviderResult keepProviderResult;
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection writers = index.getAllKnownImplementors(ResteasyReactiveDotNames.MESSAGE_BODY_WRITER);
        Collection readers = index.getAllKnownImplementors(ResteasyReactiveDotNames.MESSAGE_BODY_READER);
        for (ClassInfo writerClass : writers) {
            keepProviderResult = applicationResultBuildItem.getResult().keepProvider(writerClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            RuntimeType runtimeType = null;
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.SERVER_ONLY) {
                runtimeType = RuntimeType.SERVER;
            }
            List<Object> mediaTypeStrings = Collections.emptyList();
            AnnotationInstance producesAnnotation = writerClass.classAnnotation(ResteasyReactiveDotNames.PRODUCES);
            if (producesAnnotation != null) {
                mediaTypeStrings = Arrays.asList(producesAnnotation.value().asStringArray());
            }
            List typeParameters = JandexUtil.resolveTypeParameters((DotName)writerClass.name(), (DotName)ResteasyReactiveDotNames.MESSAGE_BODY_WRITER, (IndexView)index);
            String writerClassName = writerClass.name().toString();
            constrainedToInstance = writerClass.classAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO);
            if (constrainedToInstance != null) {
                runtimeType = RuntimeType.valueOf((String)constrainedToInstance.value().asEnum());
            }
            messageBodyWriterBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(writerClassName, ((Type)typeParameters.get(0)).name().toString(), mediaTypeStrings, runtimeType, false));
        }
        for (ClassInfo readerClass : readers) {
            keepProviderResult = applicationResultBuildItem.getResult().keepProvider(readerClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            List typeParameters = JandexUtil.resolveTypeParameters((DotName)readerClass.name(), (DotName)ResteasyReactiveDotNames.MESSAGE_BODY_READER, (IndexView)index);
            RuntimeType runtimeType = null;
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.SERVER_ONLY) {
                runtimeType = RuntimeType.SERVER;
            }
            List<Object> mediaTypeStrings = Collections.emptyList();
            String readerClassName = readerClass.name().toString();
            AnnotationInstance consumesAnnotation = readerClass.classAnnotation(ResteasyReactiveDotNames.CONSUMES);
            if (consumesAnnotation != null) {
                mediaTypeStrings = Arrays.asList(consumesAnnotation.value().asStringArray());
            }
            if ((constrainedToInstance = readerClass.classAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO)) != null) {
                runtimeType = RuntimeType.valueOf((String)constrainedToInstance.value().asEnum());
            }
            messageBodyReaderBuildItemBuildProducer.produce((BuildItem)new MessageBodyReaderBuildItem(readerClassName, ((Type)typeParameters.get(0)).name().toString(), mediaTypeStrings, runtimeType, false));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{readerClassName}));
        }
    }
}

