/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ParameterContainersBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsContributorBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.VetoingAnnotationTransformer;
import io.quarkus.resteasy.reactive.common.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig;
import io.quarkus.resteasy.reactive.spi.AbstractInterceptorBuildItem;
import io.quarkus.resteasy.reactive.spi.AdditionalResourceClassBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.ReaderInterceptorBuildItem;
import io.quarkus.resteasy.reactive.spi.WriterInterceptorBuildItem;
import io.quarkus.security.spi.AdditionalSecuredMethodsBuildItem;
import io.quarkus.security.spi.SecurityTransformerUtils;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.jaxrs.RuntimeDelegateImpl;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveInterceptorScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveParameterContainerScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ScannedSerializer;
import org.jboss.resteasy.reactive.common.processor.scanning.SerializerScanningResult;

public class ResteasyReactiveCommonProcessor {
    private static final int LEGACY_READER_PRIORITY = 10000;
    private static final int LEGACY_WRITER_PRIORITY = 2500;

    @BuildStep
    void setUpDenyAllJaxRs(CombinedIndexBuildItem index, JaxRsSecurityConfig securityConfig, Optional<ResourceScanningResultBuildItem> resteasyDeployment, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalSecuredMethodsBuildItem> additionalSecuredClasses) {
        if (resteasyDeployment.isPresent() && (securityConfig.denyJaxRs() || securityConfig.defaultRolesAllowed().isPresent())) {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            Map httpAnnotationToMethod = resteasyDeployment.get().getResult().getHttpAnnotationToMethod();
            Set resourceClasses = resteasyDeployment.get().getResult().getScannedResourcePaths().keySet();
            for (DotName className : resourceClasses) {
                ClassInfo classInfo = index.getIndex().getClassByName(className);
                if (classInfo == null) {
                    throw new IllegalStateException("Unable to find class info for " + className);
                }
                if (SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo)) continue;
                Collection classEndpoints = EndpointIndexer.collectClassEndpoints((ClassInfo)classInfo, (Map)httpAnnotationToMethod, (IndexView)beanArchiveIndexBuildItem.getIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
                for (MethodInfo classEndpoint : classEndpoints) {
                    if (SecurityTransformerUtils.hasSecurityAnnotation((MethodInfo)classEndpoint)) continue;
                    methods.add(classEndpoint);
                }
            }
            if (!methods.isEmpty()) {
                if (securityConfig.denyJaxRs()) {
                    additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredMethodsBuildItem(methods));
                } else {
                    additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredMethodsBuildItem(methods, securityConfig.defaultRolesAllowed()));
                }
            }
        }
    }

    @BuildStep
    ApplicationResultBuildItem handleApplication(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<BuildTimeConditionBuildItem> buildTimeConditions, ResteasyReactiveConfig config) {
        ApplicationScanningResult result = ResteasyReactiveScanner.scanForApplicationClass((IndexView)combinedIndexBuildItem.getComputingIndex(), config.buildTimeConditionAware() ? ResteasyReactiveCommonProcessor.getExcludedClasses(buildTimeConditions) : Collections.emptySet());
        if (result.getSelectedAppClass() != null) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{result.getSelectedAppClass().name().toString()}).build());
        }
        return new ApplicationResultBuildItem(result);
    }

    @BuildStep
    public ResourceInterceptorsContributorBuildItem scanForIOInterceptors(final CombinedIndexBuildItem combinedIndexBuildItem, final ApplicationResultBuildItem applicationResultBuildItem) {
        return new ResourceInterceptorsContributorBuildItem(new Consumer<ResourceInterceptors>(){

            @Override
            public void accept(ResourceInterceptors interceptors) {
                ResteasyReactiveInterceptorScanner.scanForIOInterceptors((ResourceInterceptors)interceptors, (IndexView)combinedIndexBuildItem.getComputingIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
            }
        });
    }

    @BuildStep
    public ResourceInterceptorsBuildItem buildResourceInterceptors(List<ResourceInterceptorsContributorBuildItem> scanningTasks, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, List<WriterInterceptorBuildItem> writerInterceptors, List<ReaderInterceptorBuildItem> readerInterceptors, List<ContainerRequestFilterBuildItem> requestFilters, List<ContainerResponseFilterBuildItem> responseFilters) {
        ResourceInterceptors resourceInterceptors = new ResourceInterceptors();
        for (ResourceInterceptorsContributorBuildItem i : scanningTasks) {
            i.getBuildTask().accept(resourceInterceptors);
        }
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder();
        this.registerContainerBeans(beanBuilder, resourceInterceptors.getContainerResponseFilters());
        this.registerContainerBeans(beanBuilder, (InterceptorContainer<?>)resourceInterceptors.getContainerRequestFilters());
        this.registerContainerBeans(beanBuilder, resourceInterceptors.getReaderInterceptors());
        this.registerContainerBeans(beanBuilder, resourceInterceptors.getWriterInterceptors());
        Set globalNameBindings = applicationResultBuildItem.getResult().getGlobalNameBindings();
        for (WriterInterceptorBuildItem writerInterceptorBuildItem : writerInterceptors) {
            this.registerInterceptors(globalNameBindings, resourceInterceptors.getWriterInterceptors(), writerInterceptorBuildItem, beanBuilder);
        }
        for (ReaderInterceptorBuildItem readerInterceptorBuildItem : readerInterceptors) {
            this.registerInterceptors(globalNameBindings, resourceInterceptors.getReaderInterceptors(), readerInterceptorBuildItem, beanBuilder);
        }
        for (ContainerRequestFilterBuildItem containerRequestFilterBuildItem : requestFilters) {
            this.registerInterceptors(globalNameBindings, (InterceptorContainer)resourceInterceptors.getContainerRequestFilters(), (AbstractInterceptorBuildItem)containerRequestFilterBuildItem, beanBuilder);
        }
        for (ContainerResponseFilterBuildItem containerResponseFilterBuildItem : responseFilters) {
            this.registerInterceptors(globalNameBindings, resourceInterceptors.getContainerResponseFilters(), containerResponseFilterBuildItem, beanBuilder);
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.setUnremovable().build());
        return new ResourceInterceptorsBuildItem(resourceInterceptors);
    }

    protected <T, B extends AbstractInterceptorBuildItem> void registerInterceptors(Set<String> globalNameBindings, InterceptorContainer<T> interceptors, B filterItem, AdditionalBeanBuildItem.Builder beanBuilder) {
        MethodInfo filterSourceMethod;
        if (filterItem.isRegisterAsBean()) {
            beanBuilder.addBeanClass(filterItem.getClassName());
        }
        ResourceInterceptor interceptor = interceptors.create();
        interceptor.setClassName(filterItem.getClassName());
        Integer priority = filterItem.getPriority();
        if (priority != null) {
            interceptor.setPriority(priority);
        }
        if (filterItem instanceof ContainerRequestFilterBuildItem) {
            ContainerRequestFilterBuildItem crfbi = (ContainerRequestFilterBuildItem)filterItem;
            interceptor.setNonBlockingRequired(crfbi.isNonBlockingRequired());
            interceptor.setWithFormRead(crfbi.isWithFormRead());
            MethodInfo filterSourceMethod2 = crfbi.getFilterSourceMethod();
            if (filterSourceMethod2 != null) {
                interceptor.metadata = Map.of("filterSourceMethod", filterSourceMethod2);
            }
        } else if (filterItem instanceof ContainerResponseFilterBuildItem && (filterSourceMethod = ((ContainerResponseFilterBuildItem)filterItem).getFilterSourceMethod()) != null) {
            interceptor.metadata = Map.of("filterSourceMethod", filterSourceMethod);
        }
        if (interceptors instanceof PreMatchInterceptorContainer && ((ContainerRequestFilterBuildItem)filterItem).isPreMatching()) {
            ((PreMatchInterceptorContainer)interceptors).addPreMatchInterceptor(interceptor);
        } else {
            Set nameBindingNames = filterItem.getNameBindingNames();
            if (nameBindingNames.isEmpty() || this.namePresent(nameBindingNames, globalNameBindings)) {
                interceptors.addGlobalRequestInterceptor(interceptor);
            } else {
                interceptor.setNameBindingNames(nameBindingNames);
                interceptors.addNameRequestInterceptor(interceptor);
            }
        }
    }

    private void registerContainerBeans(AdditionalBeanBuildItem.Builder additionalProviders, InterceptorContainer<?> container) {
        for (ResourceInterceptor i : container.getGlobalResourceInterceptors()) {
            additionalProviders.addBeanClass(i.getClassName());
        }
        for (ResourceInterceptor i : container.getNameResourceInterceptors()) {
            additionalProviders.addBeanClass(i.getClassName());
        }
        if (container instanceof PreMatchInterceptorContainer) {
            for (ResourceInterceptor i : ((PreMatchInterceptorContainer)container).getPreMatchInterceptors()) {
                additionalProviders.addBeanClass(i.getClassName());
            }
        }
    }

    private boolean namePresent(Set<String> nameBindingNames, Set<String> globalNameBindings) {
        for (String i : globalNameBindings) {
            if (!nameBindingNames.contains(i)) continue;
            return true;
        }
        return false;
    }

    @BuildStep
    JaxRsResourceIndexBuildItem resourceIndex(CombinedIndexBuildItem combinedIndex, List<GeneratedJaxRsResourceBuildItem> generatedJaxRsResources, BuildProducer<GeneratedBeanBuildItem> generatedBeansProducer) throws IOException {
        if (generatedJaxRsResources.isEmpty()) {
            return new JaxRsResourceIndexBuildItem(combinedIndex.getComputingIndex());
        }
        Indexer indexer = new Indexer();
        for (GeneratedJaxRsResourceBuildItem generatedJaxRsResource : generatedJaxRsResources) {
            indexer.index((InputStream)new ByteArrayInputStream(generatedJaxRsResource.getData()));
            generatedBeansProducer.produce((BuildItem)new GeneratedBeanBuildItem(generatedJaxRsResource.getName(), generatedJaxRsResource.getData()));
        }
        return new JaxRsResourceIndexBuildItem((IndexView)CompositeIndex.create((IndexView[])new IndexView[]{combinedIndex.getComputingIndex(), indexer.complete()}));
    }

    @BuildStep
    void scanResources(JaxRsResourceIndexBuildItem jaxRsResourceIndexBuildItem, List<AdditionalResourceClassBuildItem> additionalResourceClassBuildItems, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformerBuildItemBuildProducer, BuildProducer<ResourceScanningResultBuildItem> resourceScanningResultBuildItemBuildProducer) {
        HashMap<DotName, ClassInfo> additionalResources = new HashMap<DotName, ClassInfo>();
        HashMap<DotName, String> additionalResourcePaths = new HashMap<DotName, String>();
        for (AdditionalResourceClassBuildItem bi : additionalResourceClassBuildItems) {
            additionalResources.put(bi.getClassInfo().name(), bi.getClassInfo());
            additionalResourcePaths.put(bi.getClassInfo().name(), bi.getPath());
        }
        ResourceScanningResult res = ResteasyReactiveScanner.scanResources((IndexView)jaxRsResourceIndexBuildItem.getIndexView(), additionalResources, additionalResourcePaths);
        if (res == null) {
            return;
        }
        if (!res.getResourcesThatNeedCustomProducer().isEmpty()) {
            annotationsTransformerBuildItemBuildProducer.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new VetoingAnnotationTransformer(res.getResourcesThatNeedCustomProducer().keySet())));
        }
        resourceScanningResultBuildItemBuildProducer.produce((BuildItem)new ResourceScanningResultBuildItem(res));
    }

    @BuildStep
    public void setupEndpoints(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BeanContainerBuildItem beanContainerBuildItem, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<MessageBodyWriterBuildItem> messageBodyWriterBuildItemBuildProducer, BuildProducer<MessageBodyReaderBuildItem> messageBodyReaderBuildItemBuildProducer) throws NoSuchMethodException {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        SerializerScanningResult serializers = ResteasyReactiveScanner.scanForSerializers((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (ScannedSerializer i : serializers.getReaders()) {
            messageBodyReaderBuildItemBuildProducer.produce((BuildItem)new MessageBodyReaderBuildItem(i.getClassName(), i.getHandledClassName(), i.getMediaTypeStrings(), i.getRuntimeType(), i.isBuiltin(), i.getPriority()));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{i.getClassName()}).build());
        }
        for (ScannedSerializer i : serializers.getWriters()) {
            messageBodyWriterBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(i.getClassName(), i.getHandledClassName(), i.getMediaTypeStrings(), i.getRuntimeType(), i.isBuiltin(), i.getPriority()));
        }
    }

    @BuildStep
    void registerRuntimeDelegateImpl(BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(RuntimeDelegate.class.getName(), new String[]{RuntimeDelegateImpl.class.getName()}));
    }

    @BuildStep
    void deprioritizeLegacyProviders(BuildProducer<MessageBodyReaderOverrideBuildItem> readers, BuildProducer<MessageBodyWriterOverrideBuildItem> writers) {
        readers.produce((BuildItem)new MessageBodyReaderOverrideBuildItem("org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider", 10000, true));
        readers.produce((BuildItem)new MessageBodyReaderOverrideBuildItem("com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider", 10000, true));
        readers.produce((BuildItem)new MessageBodyReaderOverrideBuildItem("com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider", 10000, true));
        writers.produce((BuildItem)new MessageBodyWriterOverrideBuildItem("org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider", 2500, true));
        writers.produce((BuildItem)new MessageBodyWriterOverrideBuildItem("com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider", 2500, true));
        writers.produce((BuildItem)new MessageBodyWriterOverrideBuildItem("com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider", 2500, true));
    }

    public static Set<String> getExcludedClasses(List<BuildTimeConditionBuildItem> buildTimeConditions) {
        return buildTimeConditions.stream().filter(item -> !item.isEnabled()).map(BuildTimeConditionBuildItem::getTarget).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(target -> target.asClass().toString()).collect(Collectors.toSet());
    }

    @BuildStep
    public void scanForParameterContainers(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<ParameterContainersBuildItem> parameterContainersBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Set res = ResteasyReactiveParameterContainerScanner.scanParameterContainers((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        parameterContainersBuildItemBuildProducer.produce((BuildItem)new ParameterContainersBuildItem(res));
    }
}

