/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import java.lang.annotation.Annotation;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ArcBeanFactory<T>
implements BeanFactory<T> {
    private final BeanContainer.Factory<T> factory;
    private final String targetClassName;

    public ArcBeanFactory(Class<T> target, BeanContainer beanContainer) {
        this.targetClassName = target.getName();
        this.factory = beanContainer.instanceFactory(target, new Annotation[0]);
    }

    public String toString() {
        return "ArcBeanFactory[" + this.targetClassName + "]";
    }

    public BeanFactory.BeanInstance<T> createInstance() {
        try {
            final BeanContainer.Instance instance = this.factory.create();
            return new BeanFactory.BeanInstance<T>(){

                public T getInstance() {
                    return instance.get();
                }

                public void close() {
                    instance.close();
                }
            };
        }
        catch (Exception e) {
            if (this.factory.getClass().getName().contains("DefaultInstanceFactory")) {
                throw new IllegalArgumentException("Unable to create class '" + this.targetClassName + "'. To fix the problem, make sure this class is a CDI bean.", e);
            }
            throw e;
        }
    }
}

