/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import java.util.function.BiFunction;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionContext;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionTarget;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class MultipartTransformer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final String INJECTION_TARGET_BINARY_NAME = ResteasyReactiveInjectionTarget.class.getName().replace('.', '/');
    private static final String INJECTION_CONTEXT_BINARY_NAME = ResteasyReactiveInjectionContext.class.getName().replace('.', '/');
    private static final String INJECTION_CONTEXT_DESCRIPTOR = "L" + INJECTION_CONTEXT_BINARY_NAME + ";";
    private static final String INJECT_METHOD_NAME = "__quarkus_rest_inject";
    private static final String INJECT_METHOD_DESCRIPTOR = "(" + INJECTION_CONTEXT_DESCRIPTOR + ")V";
    private final String populatorName;

    public MultipartTransformer(String populatorName) {
        this.populatorName = populatorName;
    }

    @Override
    public ClassVisitor apply(String s, ClassVisitor visitor) {
        return new MultipartClassVisitor(524288, visitor, this.populatorName);
    }

    static class MultipartClassVisitor
    extends ClassVisitor {
        private String thisDescriptor;
        private final String populatorName;

        public MultipartClassVisitor(int api, ClassVisitor classVisitor, String populatorName) {
            super(api, classVisitor);
            this.populatorName = populatorName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.thisDescriptor = "L" + name + ";";
            access &= 0xFFFFFFF9;
            String[] newInterfaces = new String[interfaces.length + 1];
            newInterfaces[0] = INJECTION_TARGET_BINARY_NAME;
            System.arraycopy(interfaces, 0, newInterfaces, 1, interfaces.length);
            super.visit(version, access |= 1, name, signature, superName, newInterfaces);
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if ((access & 0x10) == 0 && (access & 8) == 0) {
                access &= 0xFFFFFFF9;
                access |= 1;
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        public void visitEnd() {
            MethodVisitor injectMethod = this.visitMethod(1, MultipartTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, null, null);
            injectMethod.visitParameter("ctx", 0);
            injectMethod.visitCode();
            injectMethod.visitIntInsn(25, 0);
            injectMethod.visitIntInsn(25, 1);
            injectMethod.visitMethodInsn(184, this.populatorName.replace('.', '/'), "populate", String.format("(%s%s)V", this.thisDescriptor, INJECTION_CONTEXT_DESCRIPTOR), false);
            injectMethod.visitInsn(177);
            injectMethod.visitEnd();
            injectMethod.visitMaxs(0, 0);
        }
    }
}

