/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.ClientProxyUnwrapper;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.FactoryUtils;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusFactoryCreator;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.SerializersUtil;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.server.deployment.ClassLevelExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ContextResolversBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.CustomResourceProducersGenerator;
import io.quarkus.resteasy.reactive.server.deployment.ExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ParamConverterProvidersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusInvokerFactory;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusServerEndpointIndexer;
import io.quarkus.resteasy.reactive.server.deployment.RequestContextFactoryBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerConfig;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerDotNames;
import io.quarkus.resteasy.reactive.server.deployment.ServerExceptionMapperGenerator;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveInitialiser;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRuntimeRecorder;
import io.quarkus.resteasy.reactive.server.runtime.ServerVertxBufferMessageBodyWriter;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.ForbiddenExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.security.SecurityContextOverrideHandler;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.BasicRoute;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.core.SingletonBeanFactory;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceDynamicFeature;
import org.jboss.resteasy.reactive.common.model.ResourceFeature;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.util.Encode;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.DynamicFeatures;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveProcessor {
    private static final String QUARKUS_INIT_CLASS = "io.quarkus.rest.runtime.__QuarkusInit";

    @BuildStep
    public FeatureBuildItem buildSetup() {
        return new FeatureBuildItem(Feature.RESTEASY_REACTIVE);
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.RESTEASY_REACTIVE);
    }

    @BuildStep
    void vertxIntegration(BuildProducer<MessageBodyWriterBuildItem> writerBuildItemBuildProducer) {
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerVertxBufferMessageBodyWriter.class.getName(), Buffer.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
    }

    @BuildStep
    void generateCustomProducer(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Map resourcesThatNeedCustomProducer = resourceScanningResultBuildItem.get().getResult().getResourcesThatNeedCustomProducer();
        Set beanParams = resourceScanningResultBuildItem.get().getResult().getBeanParams();
        if (!resourcesThatNeedCustomProducer.isEmpty() || !beanParams.isEmpty()) {
            CustomResourceProducersGenerator.generate(resourcesThatNeedCustomProducer, beanParams, generatedBeanBuildItemBuildProducer, additionalBeanBuildItemBuildProducer);
        }
    }

    @BuildStep
    void handleClassLevelExceptionMappers(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ClassLevelExceptionMappersBuildItem> classLevelExceptionMappers) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        List methodExceptionMapper = resourceScanningResultBuildItem.get().getResult().getClassLevelExceptionMappers();
        if (methodExceptionMapper.isEmpty()) {
            return;
        }
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        HashMap<DotName, Map<String, String>> resultingMappers = new HashMap<DotName, Map<String, String>>(methodExceptionMapper.size());
        for (MethodInfo methodInfo : methodExceptionMapper) {
            Map<String, String> classMappers;
            Map<String, String> generationResult = ServerExceptionMapperGenerator.generatePerClassMapper(methodInfo, (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, generationResult.values().toArray(new String[0])));
            DotName classDotName = methodInfo.declaringClass().name();
            if (resultingMappers.containsKey(classDotName)) {
                classMappers = (Map)resultingMappers.get(classDotName);
            } else {
                classMappers = new HashMap();
                resultingMappers.put(classDotName, classMappers);
            }
            classMappers.putAll(generationResult);
        }
        classLevelExceptionMappers.produce((BuildItem)new ClassLevelExceptionMappersBuildItem(resultingMappers));
    }

    @BuildStep
    void registerCustomExceptionMappers(BuildProducer<CustomExceptionMapperBuildItem> customExceptionMapper) {
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(AuthenticationFailedExceptionMapper.class.getName()));
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(UnauthorizedExceptionMapper.class.getName()));
    }

    @BuildStep
    public void unremoveableBeans(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<UnremovableBeanBuildItem> unremoveableBeans) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Set beanParams = resourceScanningResultBuildItem.get().getResult().getBeanParams();
        unremoveableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])beanParams.toArray(new String[0])));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void setupEndpoints(Capabilities capabilities, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BeanContainerBuildItem beanContainerBuildItem, io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig config, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, ResteasyReactiveRecorder recorder, RecorderContext recorderContext, ShutdownContextBuildItem shutdownContext, HttpBuildTimeConfig vertxConfig, List<DynamicFeatureBuildItem> dynamicFeatures, List<MessageBodyReaderBuildItem> additionalMessageBodyReaders, List<MessageBodyWriterBuildItem> additionalMessageBodyWriters, List<MessageBodyReaderOverrideBuildItem> messageBodyReaderOverrideBuildItems, List<MessageBodyWriterOverrideBuildItem> messageBodyWriterOverrideBuildItems, List<JaxrsFeatureBuildItem> features, List<ServerDefaultProducesHandlerBuildItem> serverDefaultProducesHandlers, Optional<RequestContextFactoryBuildItem> requestContextFactoryBuildItem, Optional<ClassLevelExceptionMappersBuildItem> classLevelExceptionMappers, BuildProducer<ResteasyReactiveDeploymentBuildItem> quarkusRestDeploymentBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, final BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<RouteBuildItem> routes, ApplicationResultBuildItem applicationResultBuildItem, ResourceInterceptorsBuildItem resourceInterceptorsBuildItem, ExceptionMappersBuildItem exceptionMappersBuildItem, ParamConverterProvidersBuildItem paramConverterProvidersBuildItem, ContextResolversBuildItem contextResolversBuildItem, List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems, List<MethodScannerBuildItem> methodScanners, ResteasyReactiveServerConfig serverConfig) throws NoSuchMethodException {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        if (capabilities.isPresent(Capability.RESTEASY)) {
            throw new IllegalStateException("The 'quarkus-resteasy-reactive' and 'quarkus-resteasy' extensions cannot be used at the same time.");
        }
        recorderContext.registerNonDefaultConstructor(MediaType.class.getDeclaredConstructor(String.class, String.class, String.class), mediaType -> Stream.of(mediaType.getType(), mediaType.getSubtype(), mediaType.getParameters()).collect(Collectors.toList()));
        final IndexView index = beanArchiveIndexBuildItem.getIndex();
        ResourceScanningResult result = resourceScanningResultBuildItem.get().getResult();
        Map scannedResources = result.getScannedResources();
        Map scannedResourcePaths = result.getScannedResourcePaths();
        Map possibleSubResources = result.getPossibleSubResources();
        Map pathInterfaces = result.getPathInterfaces();
        ApplicationScanningResult appResult = applicationResultBuildItem.getResult();
        Set singletonClasses = appResult.getSingletonClasses();
        Application application = appResult.getApplication();
        HashMap existingConverters = new HashMap();
        ArrayList<ResourceClass> resourceClasses = new ArrayList<ResourceClass>();
        ArrayList<Object> subResourceClasses = new ArrayList<Object>();
        AdditionalReaders additionalReaders = new AdditionalReaders();
        AdditionalWriters additionalWriters = new AdditionalWriters();
        HashMap injectableBeans = new HashMap();
        ResourceInterceptors interceptors = resourceInterceptorsBuildItem.getResourceInterceptors();
        ExceptionMapping exceptionMapping = exceptionMappersBuildItem.getExceptionMapping();
        ContextResolvers contextResolvers = contextResolversBuildItem.getContextResolvers();
        ParamConverterProviders paramConverterProviders = paramConverterProvidersBuildItem.getParamConverterProviders();
        Function<String, BeanFactory> factoryFunction = s -> FactoryUtils.factory((String)s, (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem);
        interceptors.initializeDefaultFactories(factoryFunction);
        exceptionMapping.initializeDefaultFactories(factoryFunction);
        contextResolvers.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.sort();
        interceptors.sort();
        interceptors.getContainerRequestFilters().validateThreadModel();
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true), QUARKUS_INIT_CLASS, null, Object.class.getName(), new String[]{ResteasyReactiveInitialiser.class.getName()});
             MethodCreator initConverters = c.getMethodCreator("init", Void.TYPE, new Class[]{Deployment.class});){
            Object endpoints;
            QuarkusServerEndpointIndexer.Builder serverEndpointIndexerBuilder = ((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)new QuarkusServerEndpointIndexer.Builder().addMethodScanners(methodScanners.stream().map(MethodScannerBuildItem::getMethodScanner).collect(Collectors.toList()))).setIndex(index)).setFactoryCreator((Function)new QuarkusFactoryCreator((ResteasyReactiveCommonRecorder)recorder, beanContainerBuildItem.getValue()))).setEndpointInvokerFactory(new QuarkusInvokerFactory(generatedClassBuildItemBuildProducer, recorder))).setGeneratedClassBuildItemBuildProducer(generatedClassBuildItemBuildProducer).setBytecodeTransformerBuildProducer(bytecodeTransformerBuildItemBuildProducer).setReflectiveClassProducer(reflectiveClassBuildItemBuildProducer).setExistingConverters(existingConverters)).setScannedResourcePaths(scannedResourcePaths)).setConfig(new ResteasyReactiveConfig(config.inputBufferSize.asLongValue(), config.singleDefaultProduces, config.defaultProduces))).setAdditionalReaders(additionalReaders)).setHttpAnnotationToMethod(result.getHttpAnnotationToMethod())).setInjectableBeans(injectableBeans)).setAdditionalWriters(additionalWriters)).setDefaultBlocking(appResult.isBlocking())).setHasRuntimeConverters(!paramConverterProviders.getParamConverterProviders().isEmpty())).setClassLevelExceptionMappers(classLevelExceptionMappers.isPresent() ? classLevelExceptionMappers.get().getMappers() : Collections.emptyMap())).setResourceMethodCallback(new Consumer<Map.Entry<MethodInfo, ResourceMethod>>(){

                @Override
                public void accept(Map.Entry<MethodInfo, ResourceMethod> entry) {
                    MethodInfo method = entry.getKey();
                    String source = ResteasyReactiveProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)ResteasyReactiveServerDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyReactiveServerDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyReactiveServerDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                    for (short i = 0; i < method.parameters().size(); i = (short)(i + 1)) {
                        Type parameterType = (Type)method.parameters().get(i);
                        if (this.hasAnnotation(method, i, ResteasyReactiveServerDotNames.CONTEXT)) continue;
                        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(index).ignoreTypePredicate((Predicate)ResteasyReactiveServerDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyReactiveServerDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyReactiveServerDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                    }
                }

                private boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
                    for (AnnotationInstance annotationInstance : method.annotations()) {
                        AnnotationTarget target = annotationInstance.target();
                        if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
                        return true;
                    }
                    return false;
                }
            })).setInitConverters(initConverters).setApplicationClassPredicate(s -> {
                for (ApplicationClassPredicateBuildItem i : applicationClassPredicateBuildItems) {
                    if (!i.test(s)) continue;
                    return true;
                }
                return false;
            });
            if (!serverDefaultProducesHandlers.isEmpty()) {
                ArrayList handlers = new ArrayList(serverDefaultProducesHandlers.size());
                for (ServerDefaultProducesHandlerBuildItem bi : serverDefaultProducesHandlers) {
                    handlers.add(bi.getDefaultProducesHandler());
                }
                serverEndpointIndexerBuilder.setDefaultProducesHandler((DefaultProducesHandler)new DefaultProducesHandler.DelegatingDefaultProducesHandler((List)handlers));
            }
            QuarkusServerEndpointIndexer serverEndpointIndexer = serverEndpointIndexerBuilder.build();
            for (Object i : scannedResources.values()) {
                if (!appResult.keepClass(i.name().toString())) continue;
                endpoints = serverEndpointIndexer.createEndpoints((ClassInfo)i);
                if (singletonClasses.contains(i.name().toString())) {
                    endpoints.setFactory((BeanFactory)new SingletonBeanFactory(i.name().toString()));
                }
                if (endpoints == null) continue;
                resourceClasses.add((ResourceClass)endpoints);
            }
            ArrayDeque<ClassInfo> toScan = new ArrayDeque<ClassInfo>();
            for (DotName methodAnnotation : result.getHttpAnnotationToMethod().keySet()) {
                for (AnnotationInstance annotationInstance : index.getAnnotations(methodAnnotation)) {
                    MethodInfo method = annotationInstance.target().asMethod();
                    ClassInfo classInfo = method.declaringClass();
                    toScan.add(classInfo);
                }
            }
            for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.PATH)) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo methodInfo = instance.target().asMethod();
                ClassInfo classInfo = methodInfo.declaringClass();
                toScan.add(classInfo);
            }
            while (!toScan.isEmpty()) {
                ClassInfo classInfo = (ClassInfo)toScan.poll();
                if (scannedResources.containsKey(classInfo.name()) || pathInterfaces.containsKey(classInfo.name()) || possibleSubResources.containsKey(classInfo.name())) continue;
                possibleSubResources.put(classInfo.name(), classInfo);
                endpoints = serverEndpointIndexer.createEndpoints(classInfo);
                if (endpoints != null) {
                    subResourceClasses.add(endpoints);
                }
                toScan.addAll(index.getKnownDirectImplementors(classInfo.name()));
                toScan.addAll(index.getKnownDirectSubclasses(classInfo.name()));
            }
            Features feats = new Features();
            for (JaxrsFeatureBuildItem jaxrsFeatureBuildItem : features) {
                ResourceFeature resourceFeature = new ResourceFeature();
                resourceFeature.setFactory(FactoryUtils.factory((String)jaxrsFeatureBuildItem.getClassName(), (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem));
                feats.addFeature(resourceFeature);
            }
            DynamicFeatures dynamicFeats = new DynamicFeatures();
            for (DynamicFeatureBuildItem dynamicFeatureBuildItem : dynamicFeatures) {
                ResourceDynamicFeature resourceFeature = new ResourceDynamicFeature();
                resourceFeature.setFactory(recorder.factory(dynamicFeatureBuildItem.getClassName(), beanContainerBuildItem.getValue()));
                dynamicFeats.addFeature(resourceFeature);
            }
            ServerSerialisers serverSerialisers = new ServerSerialisers();
            SerializersUtil.setupSerializers((ResteasyReactiveCommonRecorder)recorder, reflectiveClass, additionalMessageBodyReaders, additionalMessageBodyWriters, messageBodyReaderOverrideBuildItems, messageBodyWriterOverrideBuildItems, (BeanContainerBuildItem)beanContainerBuildItem, (ApplicationResultBuildItem)applicationResultBuildItem, (Serialisers)serverSerialisers, (RuntimeType)RuntimeType.SERVER);
            for (Serialisers.BuiltinWriter builtinWriter : ServerSerialisers.BUILTIN_WRITERS) {
                this.registerWriter(recorder, serverSerialisers, builtinWriter.entityClass, builtinWriter.writerClass, beanContainerBuildItem.getValue(), builtinWriter.mediaType);
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{builtinWriter.writerClass.getName()}));
            }
            for (Serialisers.BuiltinReader builtinReader : ServerSerialisers.BUILTIN_READERS) {
                this.registerReader(recorder, serverSerialisers, builtinReader.entityClass, builtinReader.readerClass, beanContainerBuildItem.getValue(), builtinReader.mediaType, builtinReader.constraint);
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{builtinReader.readerClass.getName()}));
            }
            for (AdditionalReaderWriter.Entry additionalReader : additionalReaders.get()) {
                Class readerClass = additionalReader.getHandlerClass();
                this.registerReader(recorder, serverSerialisers, additionalReader.getEntityClass(), readerClass, beanContainerBuildItem.getValue(), additionalReader.getMediaType(), additionalReader.getConstraint());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{readerClass.getName()}));
            }
            for (AdditionalReaderWriter.Entry entry : additionalWriters.get()) {
                Class writerClass = entry.getHandlerClass();
                this.registerWriter(recorder, serverSerialisers, entry.getEntityClass(), writerClass, beanContainerBuildItem.getValue(), entry.getMediaType());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{writerClass.getName()}));
            }
            initConverters.returnValue(null);
            BeanFactory beanFactory = recorder.factory(QUARKUS_INIT_CLASS, beanContainerBuildItem.getValue());
            String applicationPath = this.determineApplicationPath(index, serverConfig.path);
            if (applicationPath != null && applicationPath.contains("%")) {
                applicationPath = Encode.decodePath((String)applicationPath);
            }
            String deploymentPath = this.sanitizeApplicationPath(applicationPath);
            Class clazz = application == null ? Application.class : application.getClass();
            RuntimeValue deployment = recorder.createDeployment(new DeploymentInfo().setInterceptors(interceptors.sort()).setConfig(new ResteasyReactiveConfig(config.inputBufferSize.asLongValue(), config.singleDefaultProduces, config.defaultProduces)).setExceptionMapping(exceptionMapping).setCtxResolvers(contextResolvers).setFeatures(feats).setClientProxyUnwrapper((Function)new ClientProxyUnwrapper()).setApplicationSupplier(recorder.handleApplication(clazz, singletonClasses.isEmpty())).setFactoryCreator(recorder.factoryCreator(beanContainerBuildItem.getValue())).setDynamicFeatures(dynamicFeats).setSerialisers(serverSerialisers).setApplicationPath(applicationPath).setResourceClasses(resourceClasses).setLocatableResourceClasses(subResourceClasses).setParamConverterProviders(paramConverterProviders), beanContainerBuildItem.getValue(), (ShutdownContext)shutdownContext, vertxConfig, (RequestContextFactory)requestContextFactoryBuildItem.map(RequestContextFactoryBuildItem::getFactory).orElse(null), beanFactory);
            quarkusRestDeploymentBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveDeploymentBuildItem((RuntimeValue<Deployment>)deployment, deploymentPath));
            if (!requestContextFactoryBuildItem.isPresent()) {
                Handler handler = recorder.handler(deployment);
                routes.produce((BuildItem)new RouteBuildItem((Function)new BasicRoute(deploymentPath, Integer.valueOf(10001)), handler));
                String matchPath = deploymentPath;
                matchPath = matchPath.endsWith("/") ? matchPath + "*" : matchPath + "/*";
                routes.produce((BuildItem)new RouteBuildItem((Function)new BasicRoute(matchPath, Integer.valueOf(10001)), handler));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void applyRuntimeConfig(ResteasyReactiveRuntimeRecorder recorder, Optional<ResteasyReactiveDeploymentBuildItem> deployment, HttpConfiguration httpConfiguration) {
        if (!deployment.isPresent()) {
            return;
        }
        recorder.configure(deployment.get().getDeployment(), httpConfiguration);
    }

    @BuildStep
    public void securityExceptionMappers(BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationCompletionExceptionMapper.class.getName(), AuthenticationCompletionException.class.getName(), Integer.valueOf(5000), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationFailedExceptionMapper.class.getName(), AuthenticationFailedException.class.getName(), Integer.valueOf(5001), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationRedirectExceptionMapper.class.getName(), AuthenticationRedirectException.class.getName(), Integer.valueOf(5000), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(ForbiddenExceptionMapper.class.getName(), ForbiddenException.class.getName(), Integer.valueOf(5001), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(UnauthorizedExceptionMapper.class.getName(), UnauthorizedException.class.getName(), Integer.valueOf(5001), false));
    }

    @BuildStep
    MethodScannerBuildItem integrateSecurityOverrideSupport() {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, Map<String, Object> methodContext) {
                return Collections.singletonList(new SecurityContextOverrideHandler.Customizer());
            }
        });
    }

    private String determineApplicationPath(IndexView index, Optional<String> defaultPath) {
        Collection applicationPaths = index.getAnnotations(ResteasyReactiveDotNames.APPLICATION_PATH);
        if (applicationPaths.isEmpty()) {
            return defaultPath.orElse("/");
        }
        if (applicationPaths.size() > 1) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (AnnotationInstance annotationInstance : applicationPaths) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(annotationInstance.target().asClass().name().toString());
            }
            throw new RuntimeException("Multiple classes ( " + sb.toString() + ") have been annotated with @ApplicationPath which is currently not supported");
        }
        String applicationPath = null;
        AnnotationValue applicationPathValue = ((AnnotationInstance)applicationPaths.iterator().next()).value();
        if (applicationPathValue != null) {
            applicationPath = applicationPathValue.asString();
        }
        return applicationPath;
    }

    private String sanitizeApplicationPath(String applicationPath) {
        if (applicationPath == null || applicationPath.isEmpty() || "/".equals(applicationPath)) {
            return "/";
        }
        if ((applicationPath = applicationPath.trim()).equals("/")) {
            applicationPath = "";
        }
        if (!applicationPath.startsWith("/")) {
            applicationPath = "/" + applicationPath;
        }
        if (applicationPath.endsWith("/")) {
            applicationPath = applicationPath.substring(0, applicationPath.length() - 1);
        }
        return applicationPath;
    }

    private void registerWriter(ResteasyReactiveRecorder recorder, ServerSerialisers serialisers, Class<?> entityClass, Class<? extends MessageBodyWriter<?>> writerClass, BeanContainer beanContainer, String mediaType) {
        ResourceWriter writer = new ResourceWriter();
        writer.setFactory(recorder.factory(writerClass.getName(), beanContainer));
        writer.setMediaTypeStrings(Collections.singletonList(mediaType));
        recorder.registerWriter((Serialisers)serialisers, entityClass.getName(), writer);
    }

    private void registerReader(ResteasyReactiveRecorder recorder, ServerSerialisers serialisers, Class<?> entityClass, Class<? extends MessageBodyReader<?>> readerClass, BeanContainer beanContainer, String mediaType, RuntimeType constraint) {
        ResourceReader reader = new ResourceReader();
        reader.setFactory(recorder.factory(readerClass.getName(), beanContainer));
        reader.setMediaTypeStrings(Collections.singletonList(mediaType));
        reader.setConstraint(constraint);
        recorder.registerReader((Serialisers)serialisers, entityClass.getName(), reader);
    }
}

