/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.server.deployment.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.server.core.parameters.NullParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.runtime.kotlin.CoroutineEndpointInvoker;
import org.jboss.resteasy.reactive.server.runtime.kotlin.CoroutineMethodProcessor;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;

public class KotlinCoroutineIntegrationProcessor {
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    public static final String NAME = KotlinCoroutineIntegrationProcessor.class.getName();
    private static final DotName BLOCKING_ANNOTATION = DotName.createSimple((String)"io.smallrye.common.annotation.Blocking");

    @BuildStep
    CoroutineConfigurationBuildItem producesCoroutineConfiguration() {
        try {
            Class.forName("kotlinx.coroutines.CoroutineScope", false, this.getClass().getClassLoader());
            return new CoroutineConfigurationBuildItem(true);
        }
        catch (ClassNotFoundException e) {
            return new CoroutineConfigurationBuildItem(false);
        }
    }

    @BuildStep
    void produceCoroutineScope(CoroutineConfigurationBuildItem coroutineConfigurationBuildItem, BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer) {
        if (coroutineConfigurationBuildItem.isEnabled()) {
            buildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{"org.jboss.resteasy.reactive.server.runtime.kotlin.CoroutineInvocationHandlerFactory", "org.jboss.resteasy.reactive.server.runtime.kotlin.ApplicationCoroutineScope"}).setUnremovable().build());
        }
    }

    @BuildStep
    MethodScannerBuildItem scanner(final CoroutineConfigurationBuildItem coroutineConfigurationBuildItem) {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                if (methodContext.containsKey(NAME)) {
                    this.ensureEnabled(coroutineConfigurationBuildItem, method);
                    this.ensureNotBlocking(method);
                    ResteasyReactiveRecorder recorder = (ResteasyReactiveRecorder)methodContext.get(ResteasyReactiveRecorder.class.getName());
                    CoroutineMethodProcessor processor = new CoroutineMethodProcessor(KotlinCoroutineIntegrationProcessor.this.createCoroutineInvoker(method.declaringClass(), method, (BuildProducer<GeneratedClassBuildItem>)((BuildProducer)methodContext.get(GeneratedClassBuildItem.class.getName())), recorder));
                    return Collections.singletonList(processor);
                }
                return Collections.emptyList();
            }

            private void ensureNotBlocking(MethodInfo method) {
                if (method.annotation(BLOCKING_ANNOTATION) != null) {
                    String format = String.format("Suspendable @Blocking methods are not supported yet: %s.%s", method.declaringClass().name(), method.name());
                    throw new IllegalStateException(format);
                }
            }

            private void ensureEnabled(CoroutineConfigurationBuildItem coroutineConfigurationBuildItem2, MethodInfo method) {
                if (!coroutineConfigurationBuildItem2.isEnabled()) {
                    String format = String.format("Method %s.%s is suspendable but kotlinx-coroutines-core-jvm dependency not detected", method.declaringClass().name(), method.name());
                    throw new IllegalStateException(format);
                }
            }

            public ParameterExtractor handleCustomParameter(Type paramType, Map<DotName, AnnotationInstance> annotations, boolean field, Map<String, Object> methodContext) {
                if (paramType.name().equals((Object)CONTINUATION)) {
                    methodContext.put(NAME, true);
                    return new NullParamExtractor();
                }
                return null;
            }
        });
    }

    private Supplier<EndpointInvoker> createCoroutineInvoker(ClassInfo currentClassInfo, MethodInfo info, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, ResteasyReactiveRecorder recorder) {
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(info.name()).append(info.returnType());
        for (Type t : info.parameters()) {
            sigBuilder.append(t);
        }
        String baseName = currentClassInfo.name() + "$quarkuscoroutineinvoker$" + info.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true), baseName, null, Object.class.getName(), new String[]{CoroutineEndpointInvoker.class.getName()});){
            try (MethodCreator mc = classCreator.getMethodCreator("invoke", Object.class, new Class[]{Object.class, Object[].class});){
                mc.throwException(IllegalStateException.class, "Incorrect invoker used for Kotlin suspendable method");
            }
            mc = classCreator.getMethodCreator("invokeCoroutine", Object.class, new Object[]{Object.class, Object[].class, CONTINUATION.toString()});
            try {
                ResultHandle[] args = new ResultHandle[info.parameters().size()];
                ResultHandle array = mc.getMethodParam(1);
                for (int i = 0; i < info.parameters().size() - 1; ++i) {
                    args[i] = mc.readArrayValue(array, i);
                }
                args[args.length - 1] = mc.getMethodParam(2);
                ResultHandle res = Modifier.isInterface(currentClassInfo.flags()) ? mc.invokeInterfaceMethod(info, mc.getMethodParam(0), args) : mc.invokeVirtualMethod(info, mc.getMethodParam(0), args);
                if (info.returnType().kind() == Type.Kind.VOID) {
                    mc.returnValue(mc.loadNull());
                } else {
                    mc.returnValue(res);
                }
            }
            finally {
                if (mc != null) {
                    mc.close();
                }
            }
        }
        return recorder.invoker(baseName);
    }

    public static final class CoroutineConfigurationBuildItem
    extends SimpleBuildItem {
        private final boolean isEnabled;

        public CoroutineConfigurationBuildItem(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

