/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.server.deployment.GeneratorUtils;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerDotNames;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AsyncExceptionMappingUtil;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ContainerRequestContextImpl;
import org.jboss.resteasy.reactive.server.jaxrs.HttpHeadersImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.AsyncExceptionMapperContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveAsyncExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

final class ServerExceptionMapperGenerator {
    private ServerExceptionMapperGenerator() {
    }

    public static Map<String, String> generatePerClassMapper(MethodInfo targetMethod, ClassOutput classOutput) {
        ReturnType returnType = ServerExceptionMapperGenerator.determineReturnType(targetMethod);
        ServerExceptionMapperGenerator.checkModifiers(targetMethod);
        ClassInfo targetClass = targetMethod.declaringClass();
        Type[] handledExceptionTypes = ServerExceptionMapperGenerator.getHandledExceptionTypes(targetMethod);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Type handledExceptionType : handledExceptionTypes) {
            String generatedClassName;
            block9: {
                generatedClassName = ServerExceptionMapperGenerator.getGeneratedClassName(targetMethod, handledExceptionType);
                try (ClassCreator cc = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{ServerExceptionMapperGenerator.determineInterfaceType(returnType)}).classOutput(classOutput).build();){
                    cc.addAnnotation(Singleton.class);
                    cc.addAnnotation(Unremovable.class);
                    MethodCreator ctor = cc.getMethodCreator("<init>", "V", new String[0]);
                    ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                    ctor.returnValue(null);
                    if (returnType == ReturnType.RESPONSE) {
                        MethodDescriptor specToResponseDescriptor = ServerExceptionMapperGenerator.generateSpecToResponse(handledExceptionType, generatedClassName, cc);
                        ServerExceptionMapperGenerator.generateSpecToResponseBridge(handledExceptionType, cc, specToResponseDescriptor);
                        MethodDescriptor rrToResponseDescriptor = ServerExceptionMapperGenerator.toResponseDescriptor(handledExceptionType, generatedClassName);
                        ServerExceptionMapperGenerator.generateRRResponseBridge(handledExceptionType, cc, rrToResponseDescriptor);
                        ServerExceptionMapperGenerator.generateRRResponse(targetMethod, targetClass, handledExceptionType, cc, rrToResponseDescriptor, (method, contextHandle) -> {
                            ResultHandle endpointInstanceHandle = method.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"getEndpointInstance", Object.class, (Class[])new Class[0]), contextHandle, new ResultHandle[0]);
                            return method.checkCast(endpointInstanceHandle, targetClass.name().toString());
                        });
                        break block9;
                    }
                    if (returnType == ReturnType.UNI_RESPONSE) {
                        MethodDescriptor rrAsyncResponseDescriptor = ServerExceptionMapperGenerator.asyncResponseDescriptor(handledExceptionType, generatedClassName);
                        ServerExceptionMapperGenerator.generateRRUniResponseBridge(handledExceptionType, cc, rrAsyncResponseDescriptor);
                        ServerExceptionMapperGenerator.generateRRUniResponse(targetMethod, targetClass, handledExceptionType, cc, rrAsyncResponseDescriptor, (method, contextHandle) -> {
                            ResultHandle endpointInstanceHandle = method.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"getEndpointInstance", Object.class, (Class[])new Class[0]), contextHandle, new ResultHandle[0]);
                            return method.checkCast(endpointInstanceHandle, targetClass.name().toString());
                        });
                        break block9;
                    }
                    throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
                }
            }
            result.put(handledExceptionType.name().toString(), generatedClassName);
        }
        return result;
    }

    public static Map<String, String> generateGlobalMapper(MethodInfo targetMethod, ClassOutput classOutput) {
        ReturnType returnType = ServerExceptionMapperGenerator.determineReturnType(targetMethod);
        ServerExceptionMapperGenerator.checkModifiers(targetMethod);
        ClassInfo targetClass = targetMethod.declaringClass();
        Type[] handledExceptionTypes = ServerExceptionMapperGenerator.getHandledExceptionTypes(targetMethod);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Type handledExceptionType : handledExceptionTypes) {
            String generatedClassName;
            block9: {
                generatedClassName = ServerExceptionMapperGenerator.getGeneratedClassName(targetMethod, handledExceptionType);
                try (ClassCreator cc = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{ServerExceptionMapperGenerator.determineInterfaceType(returnType)}).classOutput(classOutput).build();){
                    cc.addAnnotation(Singleton.class);
                    cc.addAnnotation(Unremovable.class);
                    FieldDescriptor delegateField = ((FieldCreator)cc.getFieldCreator("delegate", targetClass.name().toString()).setModifiers(18)).getFieldDescriptor();
                    MethodCreator ctor = cc.getMethodCreator("<init>", Void.TYPE, new Object[]{targetClass.name().toString()});
                    ctor.setModifiers(1);
                    ctor.addAnnotation(Inject.class);
                    ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                    ResultHandle self = ctor.getThis();
                    ResultHandle config = ctor.getMethodParam(0);
                    ctor.writeInstanceField(delegateField, self, config);
                    ctor.returnValue(null);
                    if (returnType == ReturnType.RESPONSE) {
                        MethodDescriptor specToResponseDescriptor = ServerExceptionMapperGenerator.generateSpecToResponse(handledExceptionType, generatedClassName, cc);
                        ServerExceptionMapperGenerator.generateSpecToResponseBridge(handledExceptionType, cc, specToResponseDescriptor);
                        MethodDescriptor rrToResponseDescriptor = ServerExceptionMapperGenerator.toResponseDescriptor(handledExceptionType, generatedClassName);
                        ServerExceptionMapperGenerator.generateRRResponseBridge(handledExceptionType, cc, rrToResponseDescriptor);
                        ServerExceptionMapperGenerator.generateRRResponse(targetMethod, targetClass, handledExceptionType, cc, rrToResponseDescriptor, (method, contextHandle) -> method.readInstanceField(delegateField, method.getThis()));
                        break block9;
                    }
                    if (returnType == ReturnType.UNI_RESPONSE) {
                        MethodDescriptor rrAsyncResponseDescriptor = ServerExceptionMapperGenerator.asyncResponseDescriptor(handledExceptionType, generatedClassName);
                        ServerExceptionMapperGenerator.generateRRUniResponseBridge(handledExceptionType, cc, rrAsyncResponseDescriptor);
                        ServerExceptionMapperGenerator.generateRRUniResponse(targetMethod, targetClass, handledExceptionType, cc, rrAsyncResponseDescriptor, (method, contextHandle) -> method.readInstanceField(delegateField, method.getThis()));
                        break block9;
                    }
                    throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
                }
            }
            result.put(handledExceptionType.name().toString(), generatedClassName);
        }
        return result;
    }

    private static Type[] getHandledExceptionTypes(MethodInfo targetMethod) {
        Type[] valueArray;
        AnnotationValue annotationValue = targetMethod.annotation(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER).value();
        if (annotationValue != null && (valueArray = annotationValue.asClassArray()) != null && valueArray.length > 0) {
            return valueArray;
        }
        Type deducedHandledExceptionType = null;
        List methodParameters = targetMethod.parameters();
        for (Type methodParameter : methodParameters) {
            if (methodParameter.kind() != Type.Kind.CLASS) continue;
            try {
                Class<?> methodParameterClass = Class.forName(methodParameter.name().toString(), false, Thread.currentThread().getContextClassLoader());
                if (!Throwable.class.isAssignableFrom(methodParameterClass)) continue;
                if (deducedHandledExceptionType != null) {
                    throw new IllegalArgumentException("Multiple method parameters found that extend 'Throwable'. When using '@ServerExceptionMapper', only one parameter can be of type 'Throwable'. Offending method is '" + targetMethod.name() + "' of class '" + targetMethod.declaringClass().name().toString() + "'");
                }
                deducedHandledExceptionType = methodParameter;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (deducedHandledExceptionType == null) {
            throw new IllegalArgumentException("When '@ServerExceptionMapper' is used without a value, then the annotated method must contain a method parameter that extends 'Throwable'. Offending method is '" + targetMethod.name() + "' of class '" + targetMethod.declaringClass().name().toString() + "'");
        }
        return new Type[]{deducedHandledExceptionType};
    }

    private static MethodDescriptor toResponseDescriptor(Type handledExceptionType, String generatedClassName) {
        return MethodDescriptor.ofMethod((String)generatedClassName, (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{handledExceptionType.name().toString(), ServerRequestContext.class.getName()});
    }

    private static MethodDescriptor asyncResponseDescriptor(Type handledExceptionType, String generatedClassName) {
        return MethodDescriptor.ofMethod((String)generatedClassName, (String)"asyncResponse", (String)Void.TYPE.getName(), (String[])new String[]{handledExceptionType.name().toString(), AsyncExceptionMapperContext.class.getName()});
    }

    private static Class<?> determineInterfaceType(ReturnType returnType) {
        if (returnType == ReturnType.RESPONSE) {
            return ResteasyReactiveExceptionMapper.class;
        }
        if (returnType == ReturnType.UNI_RESPONSE) {
            return ResteasyReactiveAsyncExceptionMapper.class;
        }
        throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
    }

    private static void generateSpecToResponseBridge(Type handledExceptionType, ClassCreator cc, MethodDescriptor specToResponseDescriptor) {
        MethodCreator mc = cc.getMethodCreator("toResponse", Response.class, new Class[]{Throwable.class});
        ResultHandle bridgeSpecParam = mc.getMethodParam(0);
        ResultHandle castedBridgeSpecMethodParam = mc.checkCast(bridgeSpecParam, handledExceptionType.name().toString());
        mc.returnValue(mc.invokeVirtualMethod(specToResponseDescriptor, mc.getThis(), new ResultHandle[]{castedBridgeSpecMethodParam}));
    }

    private static MethodDescriptor generateSpecToResponse(Type handledExceptionType, String generatedClassName, ClassCreator cc) {
        MethodDescriptor specToResponseDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{handledExceptionType.name().toString()});
        MethodCreator specToResponse = cc.getMethodCreator(specToResponseDescriptor);
        specToResponse.throwException(IllegalStateException.class, "This should never be called");
        return specToResponseDescriptor;
    }

    private static void generateRRResponseBridge(Type handledExceptionType, ClassCreator cc, MethodDescriptor rrToResponseDescriptor) {
        MethodCreator bridgeRRToResponse = cc.getMethodCreator("toResponse", Response.class, new Class[]{Throwable.class, ServerRequestContext.class});
        ResultHandle bridgeRRExceptionParam = bridgeRRToResponse.getMethodParam(0);
        ResultHandle bridgeRRContextParam = bridgeRRToResponse.getMethodParam(1);
        ResultHandle castedBridgeRRMethodParam = bridgeRRToResponse.checkCast(bridgeRRExceptionParam, handledExceptionType.name().toString());
        bridgeRRToResponse.returnValue(bridgeRRToResponse.invokeVirtualMethod(rrToResponseDescriptor, bridgeRRToResponse.getThis(), new ResultHandle[]{castedBridgeRRMethodParam, bridgeRRContextParam}));
    }

    private static void generateRRResponse(MethodInfo targetMethod, ClassInfo targetClass, Type handledExceptionType, ClassCreator cc, MethodDescriptor rrToResponseDescriptor, BiFunction<MethodCreator, ResultHandle, ResultHandle> targetInstanceHandleCreator) {
        MethodCreator mc = cc.getMethodCreator(rrToResponseDescriptor);
        ResultHandle exceptionHandle = mc.getMethodParam(0);
        ResultHandle contextHandle = mc.checkCast(mc.getMethodParam(1), ResteasyReactiveRequestContext.class);
        ResultHandle targetInstanceHandle = targetInstanceHandleCreator.apply(mc, contextHandle);
        if (targetMethod.parameters().isEmpty()) {
            ResultHandle resultHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)targetClass.name().toString(), (String)targetMethod.name(), Response.class, (Object[])new Object[0]), targetInstanceHandle, new ResultHandle[0]);
            mc.returnValue(resultHandle);
        } else {
            TargetMethodParamsInfo targetMethodParamsInfo = ServerExceptionMapperGenerator.getTargetMethodParamsInfo(targetMethod, targetClass, handledExceptionType, mc, exceptionHandle, contextHandle);
            ResultHandle resultHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((String)targetClass.name().toString(), (String)targetMethod.name(), (String)Response.class.getName(), (String[])targetMethodParamsInfo.getTypes()), targetInstanceHandle, targetMethodParamsInfo.getHandles());
            mc.returnValue(resultHandle);
        }
    }

    private static void generateRRUniResponseBridge(Type handledExceptionType, ClassCreator cc, MethodDescriptor rrAsyncResponseDescriptor) {
        MethodCreator mc = cc.getMethodCreator("asyncResponse", Void.TYPE, new Class[]{Throwable.class, AsyncExceptionMapperContext.class});
        ResultHandle bridgeRRExceptionParam = mc.getMethodParam(0);
        ResultHandle bridgeRRContextParam = mc.getMethodParam(1);
        ResultHandle castedBridgeRRMethodParam = mc.checkCast(bridgeRRExceptionParam, handledExceptionType.name().toString());
        mc.returnValue(mc.invokeVirtualMethod(rrAsyncResponseDescriptor, mc.getThis(), new ResultHandle[]{castedBridgeRRMethodParam, bridgeRRContextParam}));
    }

    private static void generateRRUniResponse(MethodInfo targetMethod, ClassInfo targetClass, Type handledExceptionType, ClassCreator cc, MethodDescriptor rrAsyncResponseDescriptor, BiFunction<MethodCreator, ResultHandle, ResultHandle> targetInstanceHandleCreator) {
        ResultHandle uniHandle;
        MethodCreator mc = cc.getMethodCreator(rrAsyncResponseDescriptor);
        ResultHandle exceptionHandle = mc.getMethodParam(0);
        ResultHandle asyncContextHandle = mc.getMethodParam(1);
        ResultHandle serverContextHandle = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(AsyncExceptionMapperContext.class, (String)"serverRequestContext", ServerRequestContext.class, (Class[])new Class[0]), asyncContextHandle, new ResultHandle[0]);
        ResultHandle contextHandle = mc.checkCast(serverContextHandle, ResteasyReactiveRequestContext.class);
        ResultHandle targetInstanceHandle = targetInstanceHandleCreator.apply(mc, contextHandle);
        if (targetMethod.parameters().isEmpty()) {
            uniHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)targetClass.name().toString(), (String)targetMethod.name(), Uni.class, (Object[])new Object[0]), targetInstanceHandle, new ResultHandle[0]);
        } else {
            TargetMethodParamsInfo targetMethodParamsInfo = ServerExceptionMapperGenerator.getTargetMethodParamsInfo(targetMethod, targetClass, handledExceptionType, mc, exceptionHandle, contextHandle);
            uniHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((String)targetClass.name().toString(), (String)targetMethod.name(), (String)Uni.class.getName(), (String[])targetMethodParamsInfo.getTypes()), targetInstanceHandle, targetMethodParamsInfo.getHandles());
        }
        mc.invokeStaticMethod(MethodDescriptor.ofMethod(AsyncExceptionMappingUtil.class, (String)"handleUniResponse", Void.TYPE, (Class[])new Class[]{Uni.class, AsyncExceptionMapperContext.class}), new ResultHandle[]{uniHandle, asyncContextHandle});
        mc.returnValue(null);
    }

    private static TargetMethodParamsInfo getTargetMethodParamsInfo(MethodInfo targetMethod, ClassInfo targetClass, Type handledExceptionType, MethodCreator mc, ResultHandle exceptionHandle, ResultHandle contextHandle) {
        List parameters = targetMethod.parameters();
        ResultHandle[] targetMethodParamHandles = new ResultHandle[parameters.size()];
        String[] parameterTypes = new String[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            BranchResult ifNullBranch;
            AssignableResultHandle resourceInfo;
            ResultHandle runtimeResourceHandle;
            Type parameter = (Type)parameters.get(i);
            DotName paramDotName = parameter.name();
            parameterTypes[i] = paramDotName.toString();
            if (paramDotName.equals((Object)handledExceptionType.name())) {
                targetMethodParamHandles[i] = exceptionHandle;
                continue;
            }
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName) || ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)ResteasyReactiveRequestContext.class.getName(), (String)"getContainerRequestContext", ContainerRequestContextImpl.class, (Object[])new Object[0]), contextHandle, new ResultHandle[0]);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(mc, contextHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.HTTP_HEADERS.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(mc, contextHandle, targetMethodParamHandles, i, "getHttpHeaders", HttpHeadersImpl.class);
                continue;
            }
            if (ResteasyReactiveDotNames.REQUEST.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(mc, contextHandle, targetMethodParamHandles, i, "getRequest", ResteasyReactiveDotNames.REQUEST);
                continue;
            }
            if (QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST.equals((Object)paramDotName)) {
                ResultHandle routingContextHandle = GeneratorUtils.routingContextHandler(mc, contextHandle);
                targetMethodParamHandles[i] = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(RoutingContext.class, (String)"request", HttpServerRequest.class, (Class[])new Class[0]), routingContextHandle, new ResultHandle[0]);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(mc, contextHandle);
                resourceInfo = mc.createVariable(ResourceInfo.class);
                ifNullBranch = mc.ifNull(runtimeResourceHandle);
                ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
                ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getLazyMethod", ResteasyReactiveResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
                targetMethodParamHandles[i] = resourceInfo;
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(mc, contextHandle);
                resourceInfo = mc.createVariable(SimpleResourceInfo.class);
                ifNullBranch = mc.ifNull(runtimeResourceHandle);
                ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
                ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getSimplifiedResourceInfo", SimpleResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
                targetMethodParamHandles[i] = resourceInfo;
                continue;
            }
            if (ResteasyReactiveServerDotNames.ROUTING_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.routingContextHandler(mc, contextHandle);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + targetClass.name() + "' is not allowed");
        }
        return new TargetMethodParamsInfo(targetMethodParamHandles, parameterTypes);
    }

    private static ReturnType determineReturnType(MethodInfo targetMethod) {
        ParameterizedType parameterizedType;
        if (targetMethod.returnType().name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            return ReturnType.RESPONSE;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && (parameterizedType = targetMethod.returnType().asParameterizedType()).name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1 && ((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            return ReturnType.UNI_RESPONSE;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as an exception mapper as it does not declare 'Response' or 'Uni<Response>' or as its return type");
    }

    private static void checkModifiers(MethodInfo info) {
        if ((info.flags() & 2) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + info.declaringClass().name() + "' cannot be private as it is annotated with '@" + ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER + "'");
        }
        if ((info.flags() & 8) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + info.declaringClass().name() + "' cannot be static as it is annotated with '@" + ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER + "'");
        }
    }

    private static String getGeneratedClassName(MethodInfo targetMethod, Type handledExceptionType) {
        return targetMethod.declaringClass().name() + "$GeneratedExceptionHandlerFor$" + handledExceptionType.name().withoutPackagePrefix() + "$OfMethod$" + targetMethod.name();
    }

    private static class TargetMethodParamsInfo {
        private final ResultHandle[] handles;
        private final String[] types;

        public TargetMethodParamsInfo(ResultHandle[] handles, String[] types) {
            this.handles = handles;
            this.types = types;
        }

        public ResultHandle[] getHandles() {
            return this.handles;
        }

        public String[] getTypes() {
            return this.types;
        }
    }

    private static enum ReturnType {
        RESPONSE,
        UNI_RESPONSE;

    }
}

