/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.QuarkusContextProducers;
import io.quarkus.resteasy.reactive.server.spi.SubResourcesAsBeansBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BeanParam;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.server.injection.ContextProducers;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;

public class ResteasyReactiveCDIProcessor {
    @BuildStep
    AutoInjectAnnotationBuildItem contextInjection(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{ContextProducers.class, QuarkusContextProducers.class}).build());
        return new AutoInjectAnnotationBuildItem(new DotName[]{ResteasyReactiveServerDotNames.CONTEXT, DotName.createSimple((String)BeanParam.class.getName())});
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyReactiveDotNames.PATH, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyReactiveDotNames.APPLICATION_PATH, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyReactiveDotNames.PROVIDER, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    void subResourcesAsBeans(ResourceScanningResultBuildItem setupEndpointsResult, List<SubResourcesAsBeansBuildItem> subResourcesAsBeans, BuildProducer<AdditionalBeanBuildItem> producer) {
        if (subResourcesAsBeans.isEmpty() || setupEndpointsResult.getResult().getPossibleSubResources().isEmpty()) {
            return;
        }
        ArrayList<String> classNames = new ArrayList<String>(setupEndpointsResult.getResult().getPossibleSubResources().size());
        for (DotName subResourceClass : setupEndpointsResult.getResult().getPossibleSubResources().keySet()) {
            classNames.add(subResourceClass.toString());
        }
        producer.produce((BuildItem)new AdditionalBeanBuildItem(classNames.toArray(new String[0])));
    }

    @BuildStep
    void pathInterfaceImpls(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        ResourceScanningResult resourceScanningResult = resourceScanningResultBuildItem.get().getResult();
        Map pathInterfaces = resourceScanningResult.getPathInterfaces();
        ArrayList<String> impls = new ArrayList<String>();
        for (Map.Entry i : pathInterfaces.entrySet()) {
            ArrayList<ClassInfo> candidateBeans = new ArrayList<ClassInfo>(1);
            for (ClassInfo clazz : resourceScanningResult.getIndex().getAllKnownImplementors((DotName)i.getKey())) {
                if (Modifier.isAbstract(clazz.flags()) || clazz.enclosingClass() != null && !Modifier.isStatic(clazz.flags()) || clazz.enclosingMethod() != null) continue;
                candidateBeans.add(clazz);
            }
            if (candidateBeans.size() != 1) continue;
            impls.add(((ClassInfo)candidateBeans.get(0)).name().toString());
        }
        if (!impls.isEmpty()) {
            additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(impls.toArray(new String[0])).build());
        }
    }

    @BuildStep
    void additionalBeans(List<DynamicFeatureBuildItem> additionalDynamicFeatures, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<JaxrsFeatureBuildItem> featureBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        AdditionalBeanBuildItem.Builder additionalProviders = AdditionalBeanBuildItem.builder();
        for (DynamicFeatureBuildItem dynamicFeature : additionalDynamicFeatures) {
            if (dynamicFeature.isRegisterAsBean()) {
                additionalProviders.addBeanClass(dynamicFeature.getClassName());
                continue;
            }
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{dynamicFeature.getClassName()}));
        }
        for (JaxrsFeatureBuildItem feature : featureBuildItems) {
            if (feature.isRegisterAsBean()) {
                additionalProviders.addBeanClass(feature.getClassName());
                continue;
            }
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{feature.getClassName()}));
        }
        additionalBean.produce((BuildItem)additionalProviders.setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
    }
}

