/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.MediaType;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.CodeSizeEvaluator;

final class MessageBodyWriterTransformerUtils {
    private static final Logger LOGGER = Logger.getLogger(MessageBodyWriterTransformerUtils.class);

    private MessageBodyWriterTransformerUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean shouldAddAllWriteableMarker(String messageBodyWriterClassName, ClassLoader classLoader) {
        try (InputStream is = classLoader.getResourceAsStream(messageBodyWriterClassName.replace('.', '/') + ".class");){
            if (is == null) return false;
            AtomicBoolean result = new AtomicBoolean(false);
            ClassReader configClassReader = new ClassReader(is);
            configClassReader.accept((ClassVisitor)new MessageBodyWriterIsWriteableClassVisitor(result), 0);
            boolean bl = result.get();
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug((Object)(messageBodyWriterClassName + " class reading failed"), (Throwable)e);
        }
        return false;
    }

    private static class MessageBodyWriterIsWriteableMethodVisitor
    extends MethodVisitor {
        private final AtomicBoolean result;
        private int insnCount = 0;
        private boolean firstIsLoad1OnToStack = false;
        private boolean secondIsIReturn = false;
        private final CodeSizeEvaluator codeSizeEvaluator;

        private MessageBodyWriterIsWriteableMethodVisitor(CodeSizeEvaluator superMethodVisitor, AtomicBoolean result) {
            super(589824, (MethodVisitor)superMethodVisitor);
            this.codeSizeEvaluator = superMethodVisitor;
            this.result = result;
        }

        public void visitInsn(int opcode) {
            ++this.insnCount;
            if (opcode == 4 && this.insnCount == 1) {
                this.firstIsLoad1OnToStack = true;
            } else if (opcode == 172 && this.insnCount == 2) {
                this.secondIsIReturn = true;
            }
            super.visitInsn(opcode);
        }

        public void visitEnd() {
            super.visitEnd();
            this.result.set(this.insnCount == 2 && this.firstIsLoad1OnToStack && this.secondIsIReturn && this.codeSizeEvaluator.getMaxSize() == 2 && this.codeSizeEvaluator.getMinSize() == 2);
        }
    }

    private static class MessageBodyWriterIsWriteableClassVisitor
    extends ClassVisitor {
        private final AtomicBoolean result;
        private Optional<AtomicBoolean> rrIsWritableResult = Optional.empty();
        private Optional<AtomicBoolean> jaxRSIsWritableResult = Optional.empty();

        private MessageBodyWriterIsWriteableClassVisitor(AtomicBoolean result) {
            super(589824);
            this.result = result;
            this.result.set(false);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("isWriteable")) {
                if (("(Ljava/lang/Class;Ljava/lang/reflect/Type;Lorg/jboss/resteasy/reactive/server/spi/ResteasyReactiveResourceInfo;L" + MediaType.class.getName().replace('.', '/') + ";)Z").equals(descriptor)) {
                    AtomicBoolean rrResult = new AtomicBoolean(false);
                    this.rrIsWritableResult = Optional.of(rrResult);
                    return new MessageBodyWriterIsWriteableMethodVisitor(new CodeSizeEvaluator(superMethodVisitor), rrResult);
                }
                if (("(Ljava/lang/Class;Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;L" + MediaType.class.getName().replace('.', '/') + ";)Z").equals(descriptor)) {
                    AtomicBoolean standardResult = new AtomicBoolean(false);
                    this.jaxRSIsWritableResult = Optional.of(standardResult);
                    return new MessageBodyWriterIsWriteableMethodVisitor(new CodeSizeEvaluator(superMethodVisitor), standardResult);
                }
            }
            return superMethodVisitor;
        }

        public void visitEnd() {
            if (this.rrIsWritableResult.isPresent()) {
                this.result.set(this.rrIsWritableResult.get().get());
            } else if (this.jaxRSIsWritableResult.isPresent()) {
                this.result.set(this.jaxRSIsWritableResult.get().get());
            } else {
                this.result.set(false);
            }
            super.visitEnd();
        }
    }
}

