/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.server.deployment.DotNames;
import io.quarkus.resteasy.reactive.server.runtime.multipart.MultipartSupport;
import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.core.MediaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.processor.AsmUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.TypeArgMapper;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.common.util.types.TypeSignatureParser;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.DefaultFileUpload;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

final class MultipartPopulatorGenerator {
    private static final Logger LOGGER = Logger.getLogger(MultipartPopulatorGenerator.class);

    private MultipartPopulatorGenerator() {
    }

    static String generate(ClassInfo multipartClassInfo, ClassOutput classOutput, IndexView index) {
        if (!multipartClassInfo.hasNoArgsConstructor()) {
            throw new IllegalArgumentException("Classes annotated with '@MultipartForm' must contain a no-args constructor");
        }
        String multipartClassName = multipartClassInfo.name().toString();
        String generateClassName = multipartClassName + "_generated_populator";
        try (ClassCreator cc = new ClassCreator(classOutput, generateClassName, null, Object.class.getName(), new String[0]);){
            MethodCreator populate = cc.getMethodCreator("populate", Void.TYPE.getName(), new String[]{multipartClassName, ResteasyReactiveInjectionContext.class.getName()});
            populate.setModifiers(9);
            MethodCreator clinit = cc.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(9);
            ResultHandle instanceHandle = populate.getMethodParam(0);
            ResultHandle rrCtxHandle = populate.checkCast(populate.getMethodParam(1), ResteasyReactiveRequestContext.class);
            ResultHandle serverReqHandle = populate.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"serverRequest", ServerHttpRequest.class, (Class[])new Class[0]), rrCtxHandle, new ResultHandle[0]);
            ClassInfo currentClassInHierarchy = multipartClassInfo;
            while (true) {
                List fields = currentClassInHierarchy.fields();
                for (FieldInfo field : fields) {
                    MethodCreator bc;
                    AnnotationValue partTypeValue;
                    if (Modifier.isStatic(field.flags())) continue;
                    AnnotationInstance formParamInstance = field.annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
                    if (formParamInstance == null) {
                        formParamInstance = field.annotation(ResteasyReactiveDotNames.FORM_PARAM);
                    }
                    if (formParamInstance == null) continue;
                    boolean useFieldAccess = false;
                    String setterName = JavaBeanUtil.getSetterName((String)field.name());
                    org.jboss.jandex.Type fieldType = field.type();
                    DotName fieldDotName = fieldType.name();
                    MethodInfo setter = currentClassInHierarchy.method(setterName, new org.jboss.jandex.Type[]{fieldType});
                    if (setter == null) {
                        useFieldAccess = true;
                    }
                    if (!useFieldAccess && !Modifier.isPublic(setter.flags())) {
                        throw new IllegalArgumentException("Setter '" + setterName + "' of class '" + multipartClassInfo + "' must be public");
                    }
                    if (fieldDotName.equals((Object)DotNames.INPUT_STREAM_NAME) || fieldDotName.equals((Object)DotNames.INPUT_STREAM_READER_NAME)) {
                        throw new IllegalArgumentException("InputStream and InputStreamReader are not supported as a field type of a Multipart POJO class. Offending field is '" + field.name() + "' of class '" + multipartClassName + "'");
                    }
                    String formAttrName = field.name();
                    boolean formAttrNameSet = false;
                    AnnotationValue formParamValue = formParamInstance.value();
                    if (formParamValue != null) {
                        formAttrNameSet = true;
                        formAttrName = formParamValue.asString();
                    }
                    String partType = "text/plain";
                    AnnotationInstance partTypeInstance = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
                    if (partTypeInstance != null && (partTypeValue = partTypeInstance.value()) != null) {
                        partType = partTypeValue.asString();
                    }
                    ResultHandle formAttrNameHandle = populate.load(formAttrName);
                    AssignableResultHandle resultHandle = populate.createVariable(Object.class);
                    if (MultipartPopulatorGenerator.isFileRelatedType(fieldDotName)) {
                        ResultHandle fileUploadHandle = populate.invokeStaticMethod(MethodDescriptor.ofMethod(MultipartSupport.class, (String)"getFileUpload", DefaultFileUpload.class, (Class[])new Class[]{String.class, ResteasyReactiveRequestContext.class}), new ResultHandle[]{formAttrNameHandle, rrCtxHandle});
                        if (fieldDotName.equals((Object)DotNames.FIELD_UPLOAD_NAME)) {
                            populate.assign(resultHandle, fileUploadHandle);
                        } else if (fieldDotName.equals((Object)DotNames.PATH_NAME) || fieldDotName.equals((Object)DotNames.FILE_NAME)) {
                            BranchResult fileUploadNullBranch = populate.ifNull(fileUploadHandle);
                            BytecodeCreator fileUploadNullTrue = fileUploadNullBranch.trueBranch();
                            fileUploadNullTrue.assign(resultHandle, populate.loadNull());
                            fileUploadNullTrue.breakScope();
                            BytecodeCreator fileUploadFalse = fileUploadNullBranch.falseBranch();
                            ResultHandle pathHandle = fileUploadFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(DefaultFileUpload.class, (String)"uploadedFile", Path.class, (Class[])new Class[0]), fileUploadHandle, new ResultHandle[0]);
                            if (fieldDotName.equals((Object)DotNames.PATH_NAME)) {
                                fileUploadFalse.assign(resultHandle, pathHandle);
                            } else {
                                fileUploadFalse.assign(resultHandle, fileUploadFalse.invokeInterfaceMethod(MethodDescriptor.ofMethod(Path.class, (String)"toFile", File.class, (Class[])new Class[0]), pathHandle, new ResultHandle[0]));
                            }
                            fileUploadFalse.breakScope();
                        }
                    } else if (MultipartPopulatorGenerator.isListOfFileUpload(fieldType)) {
                        if (formAttrNameSet) {
                            ResultHandle fileUploadHandle;
                            org.jboss.jandex.Type fieldGenericType = (org.jboss.jandex.Type)fieldType.asParameterizedType().arguments().get(0);
                            if (fieldGenericType.name().equals((Object)DotNames.FIELD_UPLOAD_NAME)) {
                                fileUploadHandle = populate.invokeStaticMethod(MethodDescriptor.ofMethod(MultipartSupport.class, (String)"getFileUploads", List.class, (Class[])new Class[]{String.class, ResteasyReactiveRequestContext.class}), new ResultHandle[]{formAttrNameHandle, rrCtxHandle});
                            } else if (fieldGenericType.name().equals((Object)DotNames.PATH_NAME)) {
                                fileUploadHandle = populate.invokeStaticMethod(MethodDescriptor.ofMethod(MultipartSupport.class, (String)"getJavaPathFileUploads", List.class, (Class[])new Class[]{String.class, ResteasyReactiveRequestContext.class}), new ResultHandle[]{formAttrNameHandle, rrCtxHandle});
                            } else if (fieldGenericType.name().equals((Object)DotNames.FILE_NAME)) {
                                fileUploadHandle = populate.invokeStaticMethod(MethodDescriptor.ofMethod(MultipartSupport.class, (String)"getJavaIOFileUploads", List.class, (Class[])new Class[]{String.class, ResteasyReactiveRequestContext.class}), new ResultHandle[]{formAttrNameHandle, rrCtxHandle});
                            } else {
                                throw new IllegalArgumentException("Unhandled genetic type '" + fieldGenericType.name().toString() + "'");
                            }
                            populate.assign(resultHandle, fileUploadHandle);
                        } else {
                            ResultHandle allFileUploadsHandle = populate.invokeStaticMethod(MethodDescriptor.ofMethod(MultipartSupport.class, (String)"getFileUploads", List.class, (Class[])new Class[]{ResteasyReactiveRequestContext.class}), new ResultHandle[]{rrCtxHandle});
                            populate.assign(resultHandle, allFileUploadsHandle);
                        }
                    } else {
                        MultipartPopulatorGenerator.failIfFileTypeUsedAsGenericType(field, fieldType, fieldDotName);
                        if (fieldType.kind() == Type.Kind.ARRAY && fieldType.asArrayType().component().name().equals((Object)DotNames.BYTE_NAME)) {
                            throw new IllegalArgumentException("'byte[]' cannot be used to read multipart file contents. Offending field is '" + field.name() + "' of class '" + field.declaringClass().name() + "'. If you need to read the contents of the uploaded file, use 'Path' or 'File' as the field type and use File IO APIs to read the bytes, while making sure you annotate the endpoint with '@Blocking'");
                        }
                        if (fieldDotName.equals((Object)DotNames.STRING_NAME) && partType.equals("text/plain")) {
                            populate.assign(resultHandle, populate.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"getFormParameter", Object.class, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE}), rrCtxHandle, new ResultHandle[]{formAttrNameHandle, populate.load(true), populate.load(false)}));
                        } else {
                            FieldDescriptor typeField = ((FieldCreator)cc.getFieldCreator(field.name() + "_type", Class.class).setModifiers(10)).getFieldDescriptor();
                            FieldDescriptor genericTypeField = ((FieldCreator)cc.getFieldCreator(field.name() + "_genericType", Type.class).setModifiers(10)).getFieldDescriptor();
                            FieldDescriptor mediaTypeField = ((FieldCreator)cc.getFieldCreator(field.name() + "_mediaType", MediaType.class).setModifiers(10)).getFieldDescriptor();
                            ResultHandle typeHandle = clinit.invokeStaticMethod(MethodDescriptor.ofMethod(DeploymentUtils.class, (String)"loadClass", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{clinit.load(fieldDotName.toString())});
                            clinit.writeStaticField(typeField, typeHandle);
                            if (fieldType.kind() != Type.Kind.CLASS && fieldType.kind() != Type.Kind.PRIMITIVE) {
                                TypeArgMapper typeArgMapper = new TypeArgMapper(field.declaringClass(), index);
                                ResultHandle genericTypeHandle = clinit.invokeStaticMethod(MethodDescriptor.ofMethod(TypeSignatureParser.class, (String)"parse", Type.class, (Class[])new Class[]{String.class}), new ResultHandle[]{clinit.load(AsmUtil.getSignature((org.jboss.jandex.Type)fieldType, (Function)typeArgMapper))});
                                clinit.writeStaticField(genericTypeField, genericTypeHandle);
                            } else {
                                clinit.writeStaticField(genericTypeField, typeHandle);
                            }
                            clinit.writeStaticField(mediaTypeField, clinit.invokeStaticMethod(MethodDescriptor.ofMethod(MediaType.class, (String)"valueOf", MediaType.class, (Class[])new Class[]{String.class}), new ResultHandle[]{clinit.load(partType)}));
                            ResultHandle formStrValueHandle = populate.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"getFormParameter", Object.class, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE}), rrCtxHandle, new ResultHandle[]{formAttrNameHandle, populate.load(true), populate.load(false)});
                            populate.assign(resultHandle, populate.invokeStaticMethod(MethodDescriptor.ofMethod(MultipartSupport.class, (String)"convertFormAttribute", Object.class, (Class[])new Class[]{String.class, Class.class, Type.class, MediaType.class, ResteasyReactiveRequestContext.class, String.class}), new ResultHandle[]{formStrValueHandle, populate.readStaticField(typeField), populate.readStaticField(genericTypeField), populate.readStaticField(mediaTypeField), rrCtxHandle, formAttrNameHandle}));
                        }
                    }
                    if (useFieldAccess) {
                        bc = populate;
                        if (fieldType.kind() == Type.Kind.PRIMITIVE) {
                            bc = populate.ifNull((ResultHandle)resultHandle).falseBranch();
                        }
                        bc.writeInstanceField(FieldDescriptor.of((String)currentClassInHierarchy.name().toString(), (String)field.name(), (String)fieldDotName.toString()), instanceHandle, (ResultHandle)resultHandle);
                        continue;
                    }
                    bc = populate;
                    if (fieldType.kind() == Type.Kind.PRIMITIVE) {
                        bc = populate.ifNull((ResultHandle)resultHandle).falseBranch();
                    }
                    bc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)currentClassInHierarchy.name().toString(), (String)setterName, Void.TYPE, (Object[])new Object[]{fieldDotName.toString()}), instanceHandle, new ResultHandle[]{resultHandle});
                }
                DotName superClassDotName = currentClassInHierarchy.superName();
                if (superClassDotName.equals((Object)DotNames.OBJECT_NAME)) break;
                ClassInfo newCurrentClassInHierarchy = index.getClassByName(superClassDotName);
                if (newCurrentClassInHierarchy == null) {
                    if (superClassDotName.toString().startsWith("java.")) break;
                    LOGGER.warn((Object)("Class '" + superClassDotName + "' which is a parent class of '" + currentClassInHierarchy.name() + "' is not part of the Jandex index so its fields will be ignored. If you intended to include these fields, consider making the dependency part of the Jandex index by following the advice at: https://quarkus.io/guides/cdi-reference#bean_discovery"));
                    break;
                }
                currentClassInHierarchy = newCurrentClassInHierarchy;
            }
            clinit.returnValue(null);
            populate.returnValue(null);
        }
        return generateClassName;
    }

    private static boolean isFileRelatedType(DotName type) {
        return type.equals((Object)DotNames.FIELD_UPLOAD_NAME) || type.equals((Object)DotNames.PATH_NAME) || type.equals((Object)DotNames.FILE_NAME);
    }

    private static boolean isListOfFileUpload(org.jboss.jandex.Type fieldType) {
        ParameterizedType parameterizedType;
        if (fieldType.kind() == Type.Kind.PARAMETERIZED_TYPE && fieldType.name().equals((Object)ResteasyReactiveDotNames.LIST) && !(parameterizedType = fieldType.asParameterizedType()).arguments().isEmpty()) {
            DotName argTypeDotName = ((org.jboss.jandex.Type)parameterizedType.arguments().get(0)).name();
            return MultipartPopulatorGenerator.isFileRelatedType(argTypeDotName);
        }
        return false;
    }

    private static void failIfFileTypeUsedAsGenericType(FieldInfo field, org.jboss.jandex.Type fieldType, DotName fieldDotName) {
        DotName argTypeDotName;
        ParameterizedType parameterizedType;
        if (fieldType.kind() == Type.Kind.PARAMETERIZED_TYPE && !(parameterizedType = fieldType.asParameterizedType()).arguments().isEmpty() && MultipartPopulatorGenerator.isFileRelatedType(argTypeDotName = ((org.jboss.jandex.Type)parameterizedType.arguments().get(0)).name())) {
            throw new IllegalArgumentException("Type '" + argTypeDotName.withoutPackagePrefix() + "' cannot be used as a generic type of '" + fieldDotName.withoutPackagePrefix() + "'. Offending field is '" + field.name() + "' of class '" + field.declaringClass().name() + "'");
        }
    }
}

