/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.server.common.runtime.EndpointInvokerFactory;
import io.quarkus.resteasy.reactive.server.deployment.ClassInjectorTransformer;
import io.quarkus.resteasy.reactive.server.deployment.DotNames;
import io.quarkus.resteasy.reactive.server.deployment.FormDataOutputMapperGenerator;
import io.quarkus.resteasy.reactive.server.deployment.MultipartPopulatorGenerator;
import io.quarkus.resteasy.reactive.server.deployment.MultipartTransformer;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import io.quarkus.resteasy.reactive.server.runtime.multipart.MultipartMessageBodyWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.ws.rs.core.MediaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LoadedParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;

public class QuarkusServerEndpointIndexer
extends ServerEndpointIndexer {
    private final MethodCreator initConverters;
    private final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    private final BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildProducer;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;
    private final DefaultProducesHandler defaultProducesHandler;
    private final ResteasyReactiveRecorder resteasyReactiveRecorder;
    private final Map<String, String> multipartInputGeneratedPopulators = new HashMap<String, String>();
    private final Map<String, Boolean> multipartOutputGeneratedPopulators = new HashMap<String, Boolean>();
    private final Predicate<String> applicationClassPredicate;

    QuarkusServerEndpointIndexer(Builder builder) {
        super((ServerEndpointIndexer.AbstractBuilder)builder);
        this.initConverters = builder.initConverters;
        this.generatedClassBuildItemBuildProducer = builder.generatedClassBuildItemBuildProducer;
        this.bytecodeTransformerBuildProducer = builder.bytecodeTransformerBuildProducer;
        this.reflectiveClassProducer = builder.reflectiveClassProducer;
        this.defaultProducesHandler = builder.defaultProducesHandler;
        this.applicationClassPredicate = builder.applicationClassPredicate;
        this.resteasyReactiveRecorder = builder.resteasyReactiveRecorder;
    }

    protected String[] applyAdditionalDefaults(final Type nonAsyncReturnType) {
        List defaultMediaTypes = this.defaultProducesHandler.handle(new DefaultProducesHandler.Context(){

            public Type nonAsyncReturnType() {
                return nonAsyncReturnType;
            }

            public IndexView index() {
                return QuarkusServerEndpointIndexer.this.index;
            }

            public ResteasyReactiveConfig config() {
                return QuarkusServerEndpointIndexer.this.config;
            }
        });
        if (defaultMediaTypes != null && !defaultMediaTypes.isEmpty()) {
            String[] result = new String[defaultMediaTypes.size()];
            for (int i = 0; i < defaultMediaTypes.size(); ++i) {
                result[i] = ((MediaType)defaultMediaTypes.get(i)).toString();
            }
            return result;
        }
        return super.applyAdditionalDefaults(nonAsyncReturnType);
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ServerIndexedParameter builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        methodContext.put(GeneratedClassBuildItem.class.getName(), this.generatedClassBuildItemBuildProducer);
        methodContext.put(EndpointInvokerFactory.class.getName(), this.resteasyReactiveRecorder);
        return super.handleCustomParameter(anns, builder, paramType, field, methodContext);
    }

    protected ParameterConverterSupplier extractConverterImpl(String elementType, IndexView indexView, Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters) {
        LoadedParameterConverter delegate;
        String baseName;
        MethodDescriptor fromString = null;
        MethodDescriptor valueOf = null;
        MethodInfo stringCtor = null;
        String primitiveWrapperType = (String)primitiveTypes.get(elementType);
        String prefix = "";
        if (primitiveWrapperType != null) {
            valueOf = MethodDescriptor.ofMethod((Object)primitiveWrapperType, (String)"valueOf", (Object)primitiveWrapperType, (Object[])new Object[]{String.class});
            prefix = "io.quarkus.generated.";
        } else {
            ClassInfo type = indexView.getClassByName(DotName.createSimple((String)elementType));
            if (type != null) {
                for (MethodInfo i : type.methods()) {
                    boolean isNotPrivate;
                    boolean isStatic = (i.flags() & 8) != 0;
                    boolean bl = isNotPrivate = (i.flags() & 2) == 0;
                    if (i.parameters().size() != 1 || !isNotPrivate || !((Type)i.parameters().get(0)).name().equals((Object)ResteasyReactiveDotNames.STRING)) continue;
                    if (i.name().equals("<init>")) {
                        stringCtor = i;
                        continue;
                    }
                    if (i.name().equals("valueOf") && isStatic) {
                        valueOf = MethodDescriptor.of((MethodInfo)i);
                        continue;
                    }
                    if (!i.name().equals("fromString") || !isStatic) continue;
                    fromString = MethodDescriptor.of((MethodInfo)i);
                }
                if (type.isEnum() && fromString != null) {
                    valueOf = null;
                }
            }
        }
        if (stringCtor != null || valueOf != null || fromString != null) {
            Object effectivePrefix = prefix + elementType;
            if (((String)effectivePrefix).startsWith("java")) {
                effectivePrefix = ((String)effectivePrefix).replace("java", "javaq");
            }
            baseName = (String)effectivePrefix + "$quarkusrestparamConverter$";
            try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, this.applicationClassPredicate.test(elementType)), baseName, null, Object.class.getName(), new String[]{ParameterConverter.class.getName()});){
                MethodCreator mc = classCreator.getMethodCreator("convert", Object.class, new Class[]{Object.class});
                if (stringCtor != null) {
                    ResultHandle ret = mc.newInstance(stringCtor, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(ret);
                } else if (valueOf != null) {
                    ResultHandle ret = mc.invokeStaticMethod(valueOf, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(ret);
                } else if (fromString != null) {
                    ResultHandle ret = mc.invokeStaticMethod(fromString, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(ret);
                }
            }
            delegate = new LoadedParameterConverter().setClassName(baseName);
        } else {
            baseName = null;
            delegate = null;
        }
        existingConverters.put(elementType, baseName);
        if (hasRuntimeConverters) {
            return new RuntimeResolvedConverter.Supplier().setDelegate(delegate);
        }
        if (delegate == null) {
            throw new RuntimeException("Failed to find converter for " + elementType);
        }
        return delegate;
    }

    protected void handleFieldExtractors(String currentTypeName, Map<FieldInfo, ServerIndexedParameter> fieldExtractors, boolean superTypeIsInjectable) {
        this.bytecodeTransformerBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(currentTypeName, (BiFunction)new ClassInjectorTransformer(fieldExtractors, superTypeIsInjectable)));
    }

    protected void handleConverter(String currentTypeName, FieldInfo field) {
        this.initConverters.invokeStaticMethod(MethodDescriptor.ofMethod((Object)currentTypeName, (String)("__quarkus_init_converter__" + field.name()), Void.TYPE, (Object[])new Object[]{Deployment.class}), new ResultHandle[]{this.initConverters.getMethodParam(0)});
    }

    protected void handleMultipartForParamType(ClassInfo multipartClassInfo) {
        String className = multipartClassInfo.name().toString();
        if (this.multipartInputGeneratedPopulators.containsKey(className)) {
            return;
        }
        this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{className}));
        String populatorClassName = MultipartPopulatorGenerator.generate(multipartClassInfo, (ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, this.applicationClassPredicate.test(className)), this.index);
        this.multipartInputGeneratedPopulators.put(className, populatorClassName);
        ClassInfo currentClassInHierarchy = multipartClassInfo;
        while (true) {
            ClassInfo newCurrentClassInHierarchy;
            this.bytecodeTransformerBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(currentClassInHierarchy.name().toString(), (BiFunction)new MultipartTransformer(populatorClassName)));
            DotName superClassDotName = currentClassInHierarchy.superName();
            if (superClassDotName.equals((Object)DotNames.OBJECT_NAME) || (newCurrentClassInHierarchy = this.index.getClassByName(superClassDotName)) == null) break;
            currentClassInHierarchy = newCurrentClassInHierarchy;
        }
    }

    protected boolean handleMultipartForReturnType(AdditionalWriters additionalWriters, ClassInfo multipartClassInfo) {
        String className = multipartClassInfo.name().toString();
        Boolean canHandle = this.multipartOutputGeneratedPopulators.get(className);
        if (canHandle != null) {
            return canHandle;
        }
        canHandle = false;
        if (FormDataOutputMapperGenerator.isReturnTypeCompatible(multipartClassInfo, this.index)) {
            additionalWriters.add(MultipartMessageBodyWriter.class, "multipart/form-data", QuarkusServerEndpointIndexer.loadClass(className));
            String mapperClassName = FormDataOutputMapperGenerator.generate(multipartClassInfo, (ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, this.applicationClassPredicate.test(className)), this.index);
            this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{MultipartMessageBodyWriter.class.getName()}));
            this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{className}));
            this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{mapperClassName}));
            canHandle = true;
        }
        this.multipartOutputGeneratedPopulators.put(className, canHandle);
        return canHandle;
    }

    private static <T> Class<T> loadClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Builder
    extends ServerEndpointIndexer.AbstractBuilder<Builder> {
        private BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
        private BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildProducer;
        private BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;
        private ResteasyReactiveRecorder resteasyReactiveRecorder;
        private MethodCreator initConverters;
        private DefaultProducesHandler defaultProducesHandler = DefaultProducesHandler.Noop.INSTANCE;
        public Predicate<String> applicationClassPredicate;

        public QuarkusServerEndpointIndexer build() {
            return new QuarkusServerEndpointIndexer(this);
        }

        public MethodCreator getInitConverters() {
            return this.initConverters;
        }

        public Builder setBytecodeTransformerBuildProducer(BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildProducer) {
            this.bytecodeTransformerBuildProducer = bytecodeTransformerBuildProducer;
            return this;
        }

        public Builder setGeneratedClassBuildItemBuildProducer(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
            this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
            return this;
        }

        public Builder setReflectiveClassProducer(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
            this.reflectiveClassProducer = reflectiveClassProducer;
            return this;
        }

        public Builder setApplicationClassPredicate(Predicate<String> applicationClassPredicate) {
            this.applicationClassPredicate = applicationClassPredicate;
            return this;
        }

        public Builder setInitConverters(MethodCreator initConverters) {
            this.initConverters = initConverters;
            return this;
        }

        public Builder setResteasyReactiveRecorder(ResteasyReactiveRecorder resteasyReactiveRecorder) {
            this.resteasyReactiveRecorder = resteasyReactiveRecorder;
            return this;
        }

        public Builder setDefaultProducesHandler(DefaultProducesHandler defaultProducesHandler) {
            this.defaultProducesHandler = defaultProducesHandler;
            return this;
        }
    }
}

