/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.util.AsmUtil;
import java.util.Map;
import java.util.function.BiFunction;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.parameters.converters.DelegatingParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionContext;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionTarget;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassInjectorTransformer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final String WEB_APPLICATION_EXCEPTION_BINARY_NAME = WebApplicationException.class.getName().replace('.', '/');
    private static final String NOT_FOUND_EXCEPTION_BINARY_NAME = NotFoundException.class.getName().replace('.', '/');
    private static final String BAD_REQUEST_EXCEPTION_BINARY_NAME = BadRequestException.class.getName().replace('.', '/');
    private static final String PARAMETER_CONVERTER_BINARY_NAME = ParameterConverter.class.getName().replace('.', '/');
    private static final String PARAMETER_CONVERTER_DESCRIPTOR = "L" + PARAMETER_CONVERTER_BINARY_NAME + ";";
    private static final String QUARKUS_REST_INJECTION_TARGET_BINARY_NAME = ResteasyReactiveInjectionTarget.class.getName().replace('.', '/');
    private static final String QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME = ResteasyReactiveInjectionContext.class.getName().replace('.', '/');
    private static final String QUARKUS_REST_INJECTION_CONTEXT_DESCRIPTOR = "L" + QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME + ";";
    private static final String INJECT_METHOD_NAME = "__quarkus_rest_inject";
    private static final String INJECT_METHOD_DESCRIPTOR = "(" + QUARKUS_REST_INJECTION_CONTEXT_DESCRIPTOR + ")V";
    private static final String QUARKUS_REST_DEPLOYMENT_BINARY_NAME = Deployment.class.getName().replace('.', '/');
    private static final String QUARKUS_REST_DEPLOYMENT_DESCRIPTOR = "L" + QUARKUS_REST_DEPLOYMENT_BINARY_NAME + ";";
    static final String INIT_CONVERTER_METHOD_NAME = "__quarkus_init_converter__";
    private static final String INIT_CONVERTER_FIELD_NAME = "__quarkus_converter__";
    private static final String INIT_CONVERTER_METHOD_DESCRIPTOR = "(" + QUARKUS_REST_DEPLOYMENT_DESCRIPTOR + ")V";
    private final Map<FieldInfo, ServerIndexedParameter> fieldExtractors;
    private final boolean superTypeIsInjectable;

    public ClassInjectorTransformer(Map<FieldInfo, ServerIndexedParameter> fieldExtractors, boolean superTypeIsInjectable) {
        this.fieldExtractors = fieldExtractors;
        this.superTypeIsInjectable = superTypeIsInjectable;
    }

    @Override
    public ClassVisitor apply(String classname, ClassVisitor visitor) {
        return new ClassInjectorVisitor(589824, visitor, this.fieldExtractors, this.superTypeIsInjectable);
    }

    static class ClassInjectorVisitor
    extends ClassVisitor {
        private Map<FieldInfo, ServerIndexedParameter> fieldExtractors;
        private String thisName;
        private boolean superTypeIsInjectable;
        private String superTypeName;

        public ClassInjectorVisitor(int api, ClassVisitor classVisitor, Map<FieldInfo, ServerIndexedParameter> fieldExtractors, boolean superTypeIsInjectable) {
            super(api, classVisitor);
            this.fieldExtractors = fieldExtractors;
            this.superTypeIsInjectable = superTypeIsInjectable;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            access &= 0xFFFFFFF9;
            access |= 1;
            if (!this.superTypeIsInjectable) {
                String[] newInterfaces = new String[interfaces.length + 1];
                newInterfaces[0] = QUARKUS_REST_INJECTION_TARGET_BINARY_NAME;
                System.arraycopy(interfaces, 0, newInterfaces, 1, interfaces.length);
                super.visit(version, access, name, signature, superName, newInterfaces);
            } else {
                super.visit(version, access, name, signature, superName, interfaces);
            }
            this.superTypeName = superName;
            this.thisName = name;
        }

        public void visitEnd() {
            ServerIndexedParameter extractor;
            FieldInfo fieldInfo;
            MethodVisitor injectMethod = this.visitMethod(1, ClassInjectorTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, null, null);
            injectMethod.visitParameter("ctx", 0);
            injectMethod.visitCode();
            if (this.superTypeIsInjectable) {
                injectMethod.visitIntInsn(25, 0);
                injectMethod.visitIntInsn(25, 1);
                injectMethod.visitMethodInsn(183, this.superTypeName, ClassInjectorTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, false);
            }
            for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : this.fieldExtractors.entrySet()) {
                fieldInfo = entry.getKey();
                extractor = entry.getValue();
                switch (extractor.getType()) {
                    case BEAN: {
                        injectMethod.visitIntInsn(25, 0);
                        injectMethod.visitFieldInsn(180, this.thisName, fieldInfo.name(), AsmUtil.getDescriptor((Type)fieldInfo.type(), name -> null));
                        injectMethod.visitIntInsn(25, 1);
                        injectMethod.visitMethodInsn(185, QUARKUS_REST_INJECTION_TARGET_BINARY_NAME, ClassInjectorTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, true);
                        break;
                    }
                    case ASYNC_RESPONSE: 
                    case BODY: {
                        break;
                    }
                    case CONTEXT: {
                        break;
                    }
                    case FORM: {
                        this.injectParameterWithConverter(injectMethod, "getFormParameter", fieldInfo, extractor, true, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                    case HEADER: {
                        this.injectParameterWithConverter(injectMethod, "getHeader", fieldInfo, extractor, true, false, false);
                        break;
                    }
                    case MATRIX: {
                        this.injectParameterWithConverter(injectMethod, "getMatrixParameter", fieldInfo, extractor, true, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                    case COOKIE: {
                        this.injectParameterWithConverter(injectMethod, "getCookieParameter", fieldInfo, extractor, false, false, false);
                        break;
                    }
                    case PATH: {
                        this.injectParameterWithConverter(injectMethod, "getPathParameter", fieldInfo, extractor, false, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                    case QUERY: {
                        this.injectParameterWithConverter(injectMethod, "getQueryParameter", fieldInfo, extractor, true, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                }
            }
            injectMethod.visitInsn(177);
            injectMethod.visitEnd();
            injectMethod.visitMaxs(0, 0);
            for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : this.fieldExtractors.entrySet()) {
                fieldInfo = entry.getKey();
                extractor = entry.getValue();
                switch (extractor.getType()) {
                    case FORM: 
                    case HEADER: 
                    case MATRIX: 
                    case COOKIE: 
                    case PATH: 
                    case QUERY: {
                        ParameterConverterSupplier converter = extractor.getConverter();
                        if (converter == null) break;
                        this.generateConverterInitMethod(fieldInfo, converter, extractor.isSingle());
                    }
                }
            }
            super.visitEnd();
        }

        private void generateConverterInitMethod(FieldInfo fieldInfo, ParameterConverterSupplier converter, boolean single) {
            String converterFieldName = ClassInjectorTransformer.INIT_CONVERTER_FIELD_NAME + fieldInfo.name();
            FieldVisitor field = this.visitField(10, converterFieldName, PARAMETER_CONVERTER_DESCRIPTOR, null, null);
            field.visitEnd();
            converter = this.removeRuntimeResolvedConverterDelegate(converter);
            String delegateBinaryName = null;
            if (converter instanceof DelegatingParameterConverterSupplier) {
                ParameterConverterSupplier delegate = this.removeRuntimeResolvedConverterDelegate(((DelegatingParameterConverterSupplier)converter).getDelegate());
                if (delegate != null) {
                    delegateBinaryName = delegate.getClassName().replace('.', '/');
                }
            } else {
                delegateBinaryName = converter.getClassName().replace('.', '/');
            }
            MethodVisitor initConverterMethod = this.visitMethod(9, ClassInjectorTransformer.INIT_CONVERTER_METHOD_NAME + fieldInfo.name(), INIT_CONVERTER_METHOD_DESCRIPTOR, null, null);
            initConverterMethod.visitParameter("deployment", 0);
            initConverterMethod.visitCode();
            initConverterMethod.visitIntInsn(25, 0);
            initConverterMethod.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)("L" + this.thisName + ";")));
            initConverterMethod.visitLdcInsn((Object)fieldInfo.name());
            initConverterMethod.visitLdcInsn((Object)single);
            initConverterMethod.visitMethodInsn(182, QUARKUS_REST_DEPLOYMENT_BINARY_NAME, "getRuntimeParamConverter", "(Ljava/lang/Class;Ljava/lang/String;Z)" + PARAMETER_CONVERTER_DESCRIPTOR, false);
            if (delegateBinaryName != null) {
                Label notNull = new Label();
                initConverterMethod.visitInsn(89);
                initConverterMethod.visitJumpInsn(199, notNull);
                initConverterMethod.visitInsn(87);
                initConverterMethod.visitTypeInsn(187, delegateBinaryName);
                initConverterMethod.visitInsn(89);
                initConverterMethod.visitMethodInsn(183, delegateBinaryName, "<init>", "()V", false);
                initConverterMethod.visitTypeInsn(192, PARAMETER_CONVERTER_BINARY_NAME);
                initConverterMethod.visitLabel(notNull);
            }
            if (converter instanceof DelegatingParameterConverterSupplier) {
                String delegatorBinaryName = converter.getClassName().replace('.', '/');
                initConverterMethod.visitTypeInsn(187, delegatorBinaryName);
                initConverterMethod.visitInsn(90);
                initConverterMethod.visitInsn(95);
                initConverterMethod.visitMethodInsn(183, delegatorBinaryName, "<init>", "(" + PARAMETER_CONVERTER_DESCRIPTOR + ")V", false);
            }
            initConverterMethod.visitFieldInsn(179, this.thisName, converterFieldName, PARAMETER_CONVERTER_DESCRIPTOR);
            initConverterMethod.visitInsn(177);
            initConverterMethod.visitEnd();
            initConverterMethod.visitMaxs(0, 0);
        }

        private ParameterConverterSupplier removeRuntimeResolvedConverterDelegate(ParameterConverterSupplier converter) {
            ParameterConverterSupplier delegate;
            if (converter instanceof RuntimeResolvedConverter.Supplier && (delegate = ((RuntimeResolvedConverter.Supplier)converter).getDelegate()) != null) {
                return delegate;
            }
            return converter;
        }

        private void injectParameterWithConverter(MethodVisitor injectMethod, String methodName, FieldInfo fieldInfo, ServerIndexedParameter extractor, boolean extraSingleParameter, boolean extraEncodedParam, boolean encoded) {
            Label tryEnd = null;
            Label tryWebAppHandler = null;
            Label tryHandler = null;
            switch (extractor.getType()) {
                case FORM: 
                case HEADER: 
                case MATRIX: 
                case COOKIE: 
                case PATH: 
                case QUERY: {
                    Label tryStart = new Label();
                    tryEnd = new Label();
                    tryWebAppHandler = new Label();
                    tryHandler = new Label();
                    injectMethod.visitTryCatchBlock(tryStart, tryEnd, tryWebAppHandler, WEB_APPLICATION_EXCEPTION_BINARY_NAME);
                    injectMethod.visitTryCatchBlock(tryStart, tryEnd, tryHandler, "java/lang/Throwable");
                    injectMethod.visitLabel(tryStart);
                }
            }
            this.loadParameter(injectMethod, methodName, (IndexedParameter)extractor, extraSingleParameter, extraEncodedParam, encoded);
            Label valueWasNull = new Label();
            injectMethod.visitInsn(89);
            injectMethod.visitJumpInsn(198, valueWasNull);
            this.convertParameter(injectMethod, extractor, fieldInfo);
            injectMethod.visitIntInsn(25, 0);
            injectMethod.visitInsn(95);
            if (fieldInfo.type().kind() == Type.Kind.PRIMITIVE) {
                AsmUtil.unboxIfRequired((MethodVisitor)injectMethod, (Type)fieldInfo.type());
            } else {
                injectMethod.visitTypeInsn(192, fieldInfo.type().name().toString('/'));
            }
            injectMethod.visitFieldInsn(181, this.thisName, fieldInfo.name(), AsmUtil.getDescriptor((Type)fieldInfo.type(), name -> null));
            Label endLabel = new Label();
            injectMethod.visitJumpInsn(167, endLabel);
            injectMethod.visitLabel(valueWasNull);
            injectMethod.visitInsn(87);
            if (tryEnd != null) {
                String exceptionBinaryName;
                injectMethod.visitJumpInsn(167, endLabel);
                injectMethod.visitLabel(tryEnd);
                injectMethod.visitLabel(tryWebAppHandler);
                injectMethod.visitInsn(191);
                injectMethod.visitLabel(tryHandler);
                switch (extractor.getType()) {
                    case MATRIX: 
                    case PATH: 
                    case QUERY: {
                        exceptionBinaryName = NOT_FOUND_EXCEPTION_BINARY_NAME;
                        break;
                    }
                    case FORM: 
                    case HEADER: 
                    case COOKIE: {
                        exceptionBinaryName = BAD_REQUEST_EXCEPTION_BINARY_NAME;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Should not have been trying to catch exceptions for parameter of type " + extractor.getType());
                    }
                }
                injectMethod.visitTypeInsn(187, exceptionBinaryName);
                injectMethod.visitInsn(90);
                injectMethod.visitInsn(95);
                injectMethod.visitMethodInsn(183, exceptionBinaryName, "<init>", "(Ljava/lang/Throwable;)V", false);
                injectMethod.visitInsn(191);
            }
            injectMethod.visitLabel(endLabel);
        }

        private void convertParameter(MethodVisitor injectMethod, ServerIndexedParameter extractor, FieldInfo fieldInfo) {
            ParameterConverterSupplier converter = extractor.getConverter();
            if (converter != null) {
                String converterFieldName = ClassInjectorTransformer.INIT_CONVERTER_FIELD_NAME + fieldInfo.name();
                injectMethod.visitFieldInsn(178, this.thisName, converterFieldName, PARAMETER_CONVERTER_DESCRIPTOR);
                injectMethod.visitInsn(95);
                injectMethod.visitMethodInsn(185, PARAMETER_CONVERTER_BINARY_NAME, "convert", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            }
        }

        private void loadParameter(MethodVisitor injectMethod, String methodName, IndexedParameter extractor, boolean extraSingleParameter, boolean extraEncodedParam, boolean encoded) {
            String methodSignature;
            injectMethod.visitIntInsn(25, 1);
            injectMethod.visitLdcInsn((Object)extractor.getName());
            if (extraEncodedParam && extraSingleParameter) {
                injectMethod.visitLdcInsn((Object)extractor.isSingle());
                injectMethod.visitLdcInsn((Object)encoded);
                methodSignature = "(Ljava/lang/String;ZZ)Ljava/lang/Object;";
            } else if (extraEncodedParam) {
                injectMethod.visitLdcInsn((Object)encoded);
                methodSignature = "(Ljava/lang/String;Z)Ljava/lang/String;";
            } else if (extraSingleParameter) {
                injectMethod.visitLdcInsn((Object)extractor.isSingle());
                methodSignature = "(Ljava/lang/String;Z)Ljava/lang/Object;";
            } else {
                methodSignature = "(Ljava/lang/String;)Ljava/lang/String;";
            }
            injectMethod.visitMethodInsn(185, QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME, methodName, methodSignature, true);
            if (extractor.getDefaultValue() != null) {
                injectMethod.visitInsn(89);
                Label wasNonNullTarget = new Label();
                Label setDefaultValueTarget = new Label();
                injectMethod.visitJumpInsn(198, setDefaultValueTarget);
                if (extractor.isObtainedAsCollection()) {
                    injectMethod.visitInsn(89);
                    injectMethod.visitTypeInsn(192, "java/util/Collection");
                    injectMethod.visitMethodInsn(185, "java/util/Collection", "isEmpty", "()Z", true);
                    injectMethod.visitJumpInsn(154, setDefaultValueTarget);
                }
                injectMethod.visitJumpInsn(167, wasNonNullTarget);
                injectMethod.visitLabel(setDefaultValueTarget);
                injectMethod.visitInsn(87);
                injectMethod.visitLdcInsn((Object)extractor.getDefaultValue());
                injectMethod.visitLabel(wasNonNullTarget);
            }
        }
    }
}

