/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.ClientProxyUnwrapper;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RecordableConstructorBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.netty.deployment.MinNettyAllocatorMaxOrderBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.FactoryUtils;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusFactoryCreator;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.SerializersUtil;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig;
import io.quarkus.resteasy.reactive.server.deployment.ClassLevelExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ContextResolversBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.CustomResourceProducersGenerator;
import io.quarkus.resteasy.reactive.server.deployment.EndpointConfig;
import io.quarkus.resteasy.reactive.server.deployment.ExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ParamConverterProvidersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusInvokerFactory;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusMultipartParamHandler;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusMultipartReturnTypeHandler;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusServerEndpointIndexer;
import io.quarkus.resteasy.reactive.server.deployment.RequestContextFactoryBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentInfoBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerConfig;
import io.quarkus.resteasy.reactive.server.deployment.SecurityTransformerUtils;
import io.quarkus.resteasy.reactive.server.deployment.ServerSerialisersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.SetupEndpointsResultBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveInitialiser;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRuntimeRecorder;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveServerRuntimeConfig;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.ForbiddenExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityHandler;
import io.quarkus.resteasy.reactive.server.runtime.security.SecurityContextOverrideHandler;
import io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.vertx.deployment.CopyVertxContextDataBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.file.AsyncFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.core.SingletonBeanFactory;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceDynamicFeature;
import org.jboss.resteasy.reactive.common.model.ResourceFeature;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.util.Encode;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.DynamicFeatures;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.generation.converters.GeneratedConverterIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.generation.exceptionmappers.ServerExceptionMapperGenerator;
import org.jboss.resteasy.reactive.server.processor.generation.injection.TransformedFieldInjectionIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.GeneratedHandlerMultipartReturnTypeIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.GeneratedMultipartParamIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResponseHeaderMethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResponseStatusMethodScanner;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerMutinyAsyncFileMessageBodyWriter;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerMutinyBufferMessageBodyWriter;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerVertxAsyncFileMessageBodyWriter;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerVertxBufferMessageBodyWriter;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveProcessor {
    private static final String QUARKUS_INIT_CLASS = "io.quarkus.rest.runtime.__QuarkusInit";
    private static final Logger log = Logger.getLogger("io.quarkus.resteasy.reactive.server");
    private static final Predicate<Object[]> isEmpty = array -> array == null || ((Object[])array).length == 0;
    private static final Set<DotName> CONTEXT_TYPES = Set.of(DotName.createSimple((String)HttpServerRequest.class.getName()), DotName.createSimple((String)HttpServerResponse.class.getName()), DotName.createSimple((String)RoutingContext.class.getName()));
    private static final int SECURITY_EXCEPTION_MAPPERS_PRIORITY = 5001;

    @BuildStep
    public FeatureBuildItem buildSetup() {
        return new FeatureBuildItem(Feature.RESTEASY_REACTIVE);
    }

    @BuildStep
    MinNettyAllocatorMaxOrderBuildItem setMinimalNettyMaxOrderSize() {
        return new MinNettyAllocatorMaxOrderBuildItem(3);
    }

    @BuildStep
    void recordableConstructor(BuildProducer<RecordableConstructorBuildItem> ctors) {
        ctors.produce((BuildItem)new RecordableConstructorBuildItem(ServerResourceMethod.class));
        ctors.produce((BuildItem)new RecordableConstructorBuildItem(ServerMethodParameter.class));
    }

    @BuildStep
    MethodScannerBuildItem responseStatusSupport() {
        return new MethodScannerBuildItem((MethodScanner)new ResponseStatusMethodScanner());
    }

    @BuildStep
    MethodScannerBuildItem responseHeaderSupport() {
        return new MethodScannerBuildItem((MethodScanner)new ResponseHeaderMethodScanner());
    }

    @BuildStep
    void vertxIntegration(BuildProducer<MessageBodyWriterBuildItem> writerBuildItemBuildProducer) {
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerVertxBufferMessageBodyWriter.class.getName(), Buffer.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerMutinyBufferMessageBodyWriter.class.getName(), io.vertx.mutiny.core.buffer.Buffer.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerVertxAsyncFileMessageBodyWriter.class.getName(), io.vertx.core.file.AsyncFile.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerMutinyAsyncFileMessageBodyWriter.class.getName(), AsyncFile.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
    }

    @BuildStep
    void generateCustomProducer(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Map resourcesThatNeedCustomProducer = resourceScanningResultBuildItem.get().getResult().getResourcesThatNeedCustomProducer();
        Set beanParams = resourceScanningResultBuildItem.get().getResult().getBeanParams();
        if (!resourcesThatNeedCustomProducer.isEmpty() || !beanParams.isEmpty()) {
            CustomResourceProducersGenerator.generate(resourcesThatNeedCustomProducer, beanParams, generatedBeanBuildItemBuildProducer, additionalBeanBuildItemBuildProducer);
        }
    }

    @BuildStep
    void handleClassLevelExceptionMappers(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ClassLevelExceptionMappersBuildItem> classLevelExceptionMappers) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        List methodExceptionMapper = resourceScanningResultBuildItem.get().getResult().getClassLevelExceptionMappers();
        if (methodExceptionMapper.isEmpty()) {
            return;
        }
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        HashMap<DotName, Map<String, String>> resultingMappers = new HashMap<DotName, Map<String, String>>(methodExceptionMapper.size());
        for (MethodInfo methodInfo : methodExceptionMapper) {
            Map classMappers;
            Map generationResult = ServerExceptionMapperGenerator.generatePerClassMapper((MethodInfo)methodInfo, (ClassOutput)classOutput, Set.of(QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST, QuarkusResteasyReactiveDotNames.HTTP_SERVER_RESPONSE, QuarkusResteasyReactiveDotNames.ROUTING_CONTEXT), Set.of(Unremovable.class.getName()));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, generationResult.values().toArray(new String[0])));
            DotName classDotName = methodInfo.declaringClass().name();
            if (resultingMappers.containsKey(classDotName)) {
                classMappers = (Map)resultingMappers.get(classDotName);
            } else {
                classMappers = new HashMap();
                resultingMappers.put(classDotName, classMappers);
            }
            classMappers.putAll(generationResult);
        }
        classLevelExceptionMappers.produce((BuildItem)new ClassLevelExceptionMappersBuildItem(resultingMappers));
    }

    @BuildStep
    void registerCustomExceptionMappers(BuildProducer<CustomExceptionMapperBuildItem> customExceptionMapper) {
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(AuthenticationFailedExceptionMapper.class.getName()));
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(UnauthorizedExceptionMapper.class.getName()));
    }

    @BuildStep
    public void unremoveableBeans(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<UnremovableBeanBuildItem> unremoveableBeans) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Set beanParams = resourceScanningResultBuildItem.get().getResult().getBeanParams();
        unremoveableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])beanParams.toArray(new String[0])));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, useIdentityComparisonForParameters=false)
    public void setupEndpoints(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BeanContainerBuildItem beanContainerBuildItem, ResteasyReactiveConfig config, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, ResteasyReactiveRecorder recorder, List<ServerDefaultProducesHandlerBuildItem> serverDefaultProducesHandlers, Optional<ClassLevelExceptionMappersBuildItem> classLevelExceptionMappers, BuildProducer<SetupEndpointsResultBuildItem> setupEndpointsResultProducer, BuildProducer<ResteasyReactiveResourceMethodEntriesBuildItem> resourceMethodEntriesBuildItemBuildProducer, final BuildProducer<ReflectiveClassBuildItem> reflectiveClass, final BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, ApplicationResultBuildItem applicationResultBuildItem, ParamConverterProvidersBuildItem paramConverterProvidersBuildItem, List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems, List<MethodScannerBuildItem> methodScanners, List<AnnotationsTransformerBuildItem> annotationTransformerBuildItems, Capabilities capabilities) throws NoSuchMethodException {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        final IndexView index = beanArchiveIndexBuildItem.getIndex();
        ResourceScanningResult result = resourceScanningResultBuildItem.get().getResult();
        Map scannedResources = result.getScannedResources();
        Map scannedResourcePaths = result.getScannedResourcePaths();
        Map pathInterfaces = result.getPathInterfaces();
        ApplicationScanningResult appResult = applicationResultBuildItem.getResult();
        Set singletonClasses = appResult.getSingletonClasses();
        HashMap existingConverters = new HashMap();
        ArrayList<ResourceClass> resourceClasses = new ArrayList<ResourceClass>();
        ArrayList<ResourceClass> subResourceClasses = new ArrayList<ResourceClass>();
        AdditionalReaders additionalReaders = new AdditionalReaders();
        AdditionalWriters additionalWriters = new AdditionalWriters();
        HashMap injectableBeans = new HashMap();
        ParamConverterProviders paramConverterProviders = paramConverterProvidersBuildItem.getParamConverterProviders();
        Function<String, BeanFactory> factoryFunction = s -> FactoryUtils.factory((String)s, (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem);
        paramConverterProviders.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.sort();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator c = new ClassCreator((ClassOutput)classOutput, QUARKUS_INIT_CLASS, null, Object.class.getName(), new String[]{ResteasyReactiveInitialiser.class.getName()});
             MethodCreator initConverters = c.getMethodCreator("init", Void.TYPE, new Class[]{Deployment.class});){
            final ArrayList<ResteasyReactiveResourceMethodEntriesBuildItem.Entry> resourceMethodEntries = new ArrayList<ResteasyReactiveResourceMethodEntriesBuildItem.Entry>();
            Predicate<String> applicationClassPredicate = s -> {
                for (ApplicationClassPredicateBuildItem i : applicationClassPredicateBuildItems) {
                    if (!i.test(s)) continue;
                    return true;
                }
                return false;
            };
            BiConsumer<String, BiFunction> transformationConsumer = (name, function) -> bytecodeTransformerBuildItemBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(name, function));
            QuarkusServerEndpointIndexer.Builder serverEndpointIndexerBuilder = ((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)new QuarkusServerEndpointIndexer.Builder(capabilities).addMethodScanners(methodScanners.stream().map(MethodScannerBuildItem::getMethodScanner).collect(Collectors.toList()))).setIndex(index)).addContextTypes(CONTEXT_TYPES)).setFactoryCreator((Function)new QuarkusFactoryCreator((ResteasyReactiveCommonRecorder)recorder, beanContainerBuildItem.getValue()))).setEndpointInvokerFactory(new QuarkusInvokerFactory(generatedClassBuildItemBuildProducer, recorder))).setGeneratedClassBuildItemBuildProducer(generatedClassBuildItemBuildProducer).setBytecodeTransformerBuildProducer(bytecodeTransformerBuildItemBuildProducer).setReflectiveClassProducer(reflectiveClassBuildItemBuildProducer).setExistingConverters(existingConverters)).setScannedResourcePaths(scannedResourcePaths)).setConfig(this.createRestReactiveConfig(config))).setAdditionalReaders(additionalReaders)).setHttpAnnotationToMethod(result.getHttpAnnotationToMethod())).setInjectableBeans(injectableBeans)).setAdditionalWriters(additionalWriters)).setDefaultBlocking(appResult.getBlockingDefault())).setApplicationScanningResult(appResult)).setMultipartParameterIndexerExtension((EndpointIndexer.MultipartParameterIndexerExtension)new GeneratedMultipartParamIndexerExtension(transformationConsumer, (ClassOutput)classOutput))).setMultipartReturnTypeIndexerExtension((EndpointIndexer.MultipartReturnTypeIndexerExtension)new GeneratedHandlerMultipartReturnTypeIndexerExtension((ClassOutput)classOutput))).setFieldInjectionIndexerExtension((ServerEndpointIndexer.FieldInjectionIndexerExtension)new TransformedFieldInjectionIndexerExtension(transformationConsumer, false, field -> initConverters.invokeStaticMethod(MethodDescriptor.ofMethod((Object)field.getInjectedClassName(), (String)field.getMethodName(), Void.TYPE, (Object[])new Object[]{Deployment.class}), new ResultHandle[]{initConverters.getMethodParam(0)})))).setConverterSupplierIndexerExtension((ServerEndpointIndexer.ConverterSupplierIndexerExtension)new GeneratedConverterIndexerExtension(name -> new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, applicationClassPredicate.test((String)name))))).setHasRuntimeConverters(!paramConverterProviders.getParamConverterProviders().isEmpty())).setClassLevelExceptionMappers(classLevelExceptionMappers.isPresent() ? classLevelExceptionMappers.get().getMappers() : Collections.emptyMap())).setResourceMethodCallback(new Consumer<EndpointIndexer.ResourceMethodCallbackData>(){

                @Override
                public void accept(EndpointIndexer.ResourceMethodCallbackData entry) {
                    MethodInfo method = entry.getMethodInfo();
                    resourceMethodEntries.add(new ResteasyReactiveResourceMethodEntriesBuildItem.Entry(entry.getBasicResourceClassInfo(), method, entry.getActualEndpointInfo(), entry.getResourceMethod()));
                    String source = ResteasyReactiveProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                    ClassInfo classInfoWithSecurity = ResteasyReactiveProcessor.this.consumeStandardSecurityAnnotations(method, entry.getActualEndpointInfo(), index, c -> c);
                    if (classInfoWithSecurity != null) {
                        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, false, new String[]{entry.getActualEndpointInfo().name().toString()}));
                    }
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                    for (short i = 0; i < method.parameters().size(); i = (short)(i + 1)) {
                        Type parameterType = (Type)method.parameters().get(i);
                        if (this.hasAnnotation(method, i, ResteasyReactiveServerDotNames.CONTEXT)) continue;
                        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                    }
                }

                private boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
                    for (AnnotationInstance annotationInstance : method.annotations()) {
                        AnnotationTarget target = annotationInstance.target();
                        if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
                        return true;
                    }
                    return false;
                }
            })).setResteasyReactiveRecorder(recorder).setApplicationClassPredicate(applicationClassPredicate);
            if (!serverDefaultProducesHandlers.isEmpty()) {
                ArrayList<DefaultProducesHandler> handlers = new ArrayList<DefaultProducesHandler>(serverDefaultProducesHandlers.size());
                for (ServerDefaultProducesHandlerBuildItem serverDefaultProducesHandlerBuildItem : serverDefaultProducesHandlers) {
                    handlers.add(serverDefaultProducesHandlerBuildItem.getDefaultProducesHandler());
                }
                serverEndpointIndexerBuilder.setDefaultProducesHandler((DefaultProducesHandler)new DefaultProducesHandler.DelegatingDefaultProducesHandler(handlers));
            }
            if (!annotationTransformerBuildItems.isEmpty()) {
                ArrayList<AnnotationsTransformer> annotationsTransformers = new ArrayList<AnnotationsTransformer>(annotationTransformerBuildItems.size());
                for (AnnotationsTransformerBuildItem annotationsTransformerBuildItem : annotationTransformerBuildItems) {
                    annotationsTransformers.add(annotationsTransformerBuildItem.getAnnotationsTransformer());
                }
                serverEndpointIndexerBuilder.setAnnotationsTransformers(annotationsTransformers);
            }
            serverEndpointIndexerBuilder.setMultipartReturnTypeIndexerExtension(new QuarkusMultipartReturnTypeHandler(generatedClassBuildItemBuildProducer, applicationClassPredicate, reflectiveClassBuildItemBuildProducer));
            serverEndpointIndexerBuilder.setMultipartParameterIndexerExtension(new QuarkusMultipartParamHandler(generatedClassBuildItemBuildProducer, applicationClassPredicate, reflectiveClassBuildItemBuildProducer, bytecodeTransformerBuildItemBuildProducer));
            QuarkusServerEndpointIndexer serverEndpointIndexer = serverEndpointIndexerBuilder.build();
            HashMap<String, List<EndpointConfig>> allMethods = new HashMap<String, List<EndpointConfig>>();
            for (ClassInfo classInfo : scannedResources.values()) {
                Optional endpoints = serverEndpointIndexer.createEndpoints(classInfo, true);
                if (!endpoints.isPresent()) continue;
                if (singletonClasses.contains(classInfo.name().toString())) {
                    ((ResourceClass)endpoints.get()).setFactory((BeanFactory)new SingletonBeanFactory(classInfo.name().toString()));
                }
                resourceClasses.add((ResourceClass)endpoints.get());
                for (ResourceMethod rm : ((ResourceClass)endpoints.get()).getMethods()) {
                    this.addResourceMethodByPath(allMethods, ((ResourceClass)endpoints.get()).getPath(), classInfo, rm);
                }
            }
            this.checkForDuplicateEndpoint(config, allMethods);
            ArrayDeque<ClassInfo> toScan = new ArrayDeque<ClassInfo>();
            for (DotName methodAnnotation : result.getHttpAnnotationToMethod().keySet()) {
                for (AnnotationInstance instance : index.getAnnotations(methodAnnotation)) {
                    MethodInfo method = instance.target().asMethod();
                    ClassInfo classInfo = method.declaringClass();
                    toScan.add(classInfo);
                }
            }
            for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.PATH)) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo method = instance.target().asMethod();
                ClassInfo classInfo = method.declaringClass();
                toScan.add(classInfo);
            }
            HashMap<DotName, ClassInfo> hashMap = new HashMap<DotName, ClassInfo>();
            while (!toScan.isEmpty()) {
                ClassInfo classInfo = (ClassInfo)toScan.poll();
                if (scannedResources.containsKey(classInfo.name()) || pathInterfaces.containsKey(classInfo.name()) || hashMap.containsKey(classInfo.name())) continue;
                hashMap.put(classInfo.name(), classInfo);
                Optional endpoints = serverEndpointIndexer.createEndpoints(classInfo, false);
                if (endpoints.isPresent()) {
                    subResourceClasses.add((ResourceClass)endpoints.get());
                }
                toScan.addAll(index.getKnownDirectImplementors(classInfo.name()));
                toScan.addAll(index.getKnownDirectSubclasses(classInfo.name()));
            }
            setupEndpointsResultProducer.produce((BuildItem)new SetupEndpointsResultBuildItem(resourceClasses, subResourceClasses, additionalReaders, additionalWriters));
            resourceMethodEntriesBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveResourceMethodEntriesBuildItem(resourceMethodEntries));
            initConverters.returnValue(null);
        }
        this.handleDateFormatReflection(reflectiveClass, index);
    }

    private void handleDateFormatReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, IndexView index) {
        Collection dateFormatInstances = index.getAnnotations(ResteasyReactiveDotNames.DATE_FORMAT);
        if (dateFormatInstances.isEmpty()) {
            return;
        }
        ArrayList<String> dateTimeFormatterProviderClassNames = new ArrayList<String>();
        for (AnnotationInstance instance : dateFormatInstances) {
            AnnotationValue dateTimeFormatterProviderValue = instance.value("dateTimeFormatterProvider");
            if (dateTimeFormatterProviderValue == null) continue;
            dateTimeFormatterProviderClassNames.add(dateTimeFormatterProviderValue.asClass().name().toString());
        }
        if (!dateTimeFormatterProviderClassNames.isEmpty()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, false, dateTimeFormatterProviderClassNames.toArray(new String[0])));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, useIdentityComparisonForParameters=false)
    public void serverSerializers(ResteasyReactiveRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, ApplicationResultBuildItem applicationResultBuildItem, List<MessageBodyReaderBuildItem> additionalMessageBodyReaders, List<MessageBodyWriterBuildItem> additionalMessageBodyWriters, List<MessageBodyReaderOverrideBuildItem> messageBodyReaderOverrideBuildItems, List<MessageBodyWriterOverrideBuildItem> messageBodyWriterOverrideBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServerSerialisersBuildItem> serverSerializersProducer) {
        ServerSerialisers serialisers = recorder.createServerSerialisers();
        SerializersUtil.setupSerializers((ResteasyReactiveCommonRecorder)recorder, reflectiveClass, additionalMessageBodyReaders, additionalMessageBodyWriters, messageBodyReaderOverrideBuildItems, messageBodyWriterOverrideBuildItems, (BeanContainerBuildItem)beanContainerBuildItem, (ApplicationResultBuildItem)applicationResultBuildItem, (Serialisers)serialisers, (RuntimeType)RuntimeType.SERVER);
        for (Serialisers.BuiltinWriter builtinWriter : ServerSerialisers.BUILTIN_WRITERS) {
            this.registerWriter(recorder, serialisers, builtinWriter.entityClass.getName(), builtinWriter.writerClass.getName(), beanContainerBuildItem.getValue(), builtinWriter.mediaType);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{builtinWriter.writerClass.getName()}));
        }
        for (Serialisers.BuiltinReader builtinReader : ServerSerialisers.BUILTIN_READERS) {
            this.registerReader(recorder, serialisers, builtinReader.entityClass.getName(), builtinReader.readerClass.getName(), beanContainerBuildItem.getValue(), builtinReader.mediaType, builtinReader.constraint);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{builtinReader.readerClass.getName()}));
        }
        serverSerializersProducer.produce((BuildItem)new ServerSerialisersBuildItem(serialisers));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, useIdentityComparisonForParameters=false)
    public void setupDeployment(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BeanContainerBuildItem beanContainerBuildItem, Capabilities capabilities, ResteasyReactiveConfig config, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, ResteasyReactiveRecorder recorder, RecorderContext recorderContext, ShutdownContextBuildItem shutdownContext, HttpBuildTimeConfig vertxConfig, SetupEndpointsResultBuildItem setupEndpointsResult, ServerSerialisersBuildItem serverSerialisersBuildItem, List<DynamicFeatureBuildItem> dynamicFeatures, List<JaxrsFeatureBuildItem> features, Optional<RequestContextFactoryBuildItem> requestContextFactoryBuildItem, BuildProducer<ResteasyReactiveDeploymentInfoBuildItem> quarkusRestDeploymentInfoBuildItemBuildProducer, BuildProducer<ResteasyReactiveDeploymentBuildItem> quarkusRestDeploymentBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RouteBuildItem> routes, ApplicationResultBuildItem applicationResultBuildItem, ResourceInterceptorsBuildItem resourceInterceptorsBuildItem, ExceptionMappersBuildItem exceptionMappersBuildItem, ParamConverterProvidersBuildItem paramConverterProvidersBuildItem, ContextResolversBuildItem contextResolversBuildItem, ResteasyReactiveServerConfig serverConfig, LaunchModeBuildItem launchModeBuildItem, List<CopyVertxContextDataBuildItem> copyVertxContextDataBuildItems) throws NoSuchMethodException {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        recorderContext.registerNonDefaultConstructor(MediaType.class.getDeclaredConstructor(String.class, String.class, String.class), mediaType -> Stream.of(mediaType.getType(), mediaType.getSubtype(), mediaType.getParameters()).collect(Collectors.toList()));
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        ApplicationScanningResult appResult = applicationResultBuildItem.getResult();
        Set singletonClasses = appResult.getSingletonClasses();
        Application application = appResult.getApplication();
        List<ResourceClass> resourceClasses = setupEndpointsResult.getResourceClasses();
        List<ResourceClass> subResourceClasses = setupEndpointsResult.getSubResourceClasses();
        AdditionalReaders additionalReaders = setupEndpointsResult.getAdditionalReaders();
        AdditionalWriters additionalWriters = setupEndpointsResult.getAdditionalWriters();
        ResourceInterceptors interceptors = resourceInterceptorsBuildItem.getResourceInterceptors();
        ExceptionMapping exceptionMapping = exceptionMappersBuildItem.getExceptionMapping();
        ContextResolvers contextResolvers = contextResolversBuildItem.getContextResolvers();
        ParamConverterProviders paramConverterProviders = paramConverterProvidersBuildItem.getParamConverterProviders();
        Function<String, BeanFactory> factoryFunction = s -> FactoryUtils.factory((String)s, (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem);
        interceptors.initializeDefaultFactories(factoryFunction);
        exceptionMapping.initializeDefaultFactories(factoryFunction);
        contextResolvers.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.sort();
        interceptors.sort();
        interceptors.getContainerRequestFilters().validateThreadModel();
        Features feats = new Features();
        for (JaxrsFeatureBuildItem jaxrsFeatureBuildItem : features) {
            ResourceFeature resourceFeature = new ResourceFeature();
            resourceFeature.setFactory(FactoryUtils.factory((String)jaxrsFeatureBuildItem.getClassName(), (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem));
            feats.addFeature(resourceFeature);
        }
        DynamicFeatures dynamicFeats = new DynamicFeatures();
        for (DynamicFeatureBuildItem dynamicFeatureBuildItem : dynamicFeatures) {
            ResourceDynamicFeature resourceFeature = new ResourceDynamicFeature();
            resourceFeature.setFactory(recorder.factory(dynamicFeatureBuildItem.getClassName(), beanContainerBuildItem.getValue()));
            dynamicFeats.addFeature(resourceFeature);
        }
        ServerSerialisers serverSerialisers = serverSerialisersBuildItem.getSerialisers();
        for (AdditionalReaderWriter.Entry additionalReader : additionalReaders.get()) {
            String readerClass = additionalReader.getHandlerClass();
            this.registerReader(recorder, serverSerialisers, additionalReader.getEntityClass(), readerClass, beanContainerBuildItem.getValue(), additionalReader.getMediaType(), additionalReader.getConstraint());
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{readerClass}));
        }
        for (AdditionalReaderWriter.Entry entry : additionalWriters.get()) {
            String writerClass = entry.getHandlerClass();
            this.registerWriter(recorder, serverSerialisers, entry.getEntityClass(), writerClass, beanContainerBuildItem.getValue(), entry.getMediaType());
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{writerClass}));
        }
        BeanFactory beanFactory = recorder.factory(QUARKUS_INIT_CLASS, beanContainerBuildItem.getValue());
        String applicationPath = this.determineApplicationPath(appResult, this.getAppPath(serverConfig.path));
        if (applicationPath != null && applicationPath.contains("%")) {
            applicationPath = Encode.decodePath((String)applicationPath);
        }
        String deploymentPath = this.sanitizeApplicationPath(applicationPath);
        Class applicationClass = application == null ? Application.class : application.getClass();
        DeploymentInfo deploymentInfo = new DeploymentInfo().setInterceptors(interceptors.sort()).setResteasyReactiveConfig(this.createRestReactiveConfig(config)).setExceptionMapping(exceptionMapping).setCtxResolvers(contextResolvers).setFeatures(feats).setClientProxyUnwrapper((Function)new ClientProxyUnwrapper()).setApplicationSupplier(recorder.handleApplication(applicationClass, singletonClasses.isEmpty())).setFactoryCreator(recorder.factoryCreator(beanContainerBuildItem.getValue())).setDynamicFeatures(dynamicFeats).setSerialisers(serverSerialisers).setApplicationPath(applicationPath).setGlobalHandlerCustomizers(Collections.singletonList(new SecurityContextOverrideHandler.Customizer())).setResourceClasses(resourceClasses).setDevelopmentMode(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT).setLocatableResourceClasses(subResourceClasses).setParamConverterProviders(paramConverterProviders);
        quarkusRestDeploymentInfoBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveDeploymentInfoBuildItem(deploymentInfo));
        boolean servletPresent = false;
        int orderAdd = 1;
        if (capabilities.isPresent("io.quarkus.servlet")) {
            orderAdd = -1;
            servletPresent = true;
        }
        RuntimeValue deployment = recorder.createDeployment(deploymentInfo, beanContainerBuildItem.getValue(), (ShutdownContext)shutdownContext, vertxConfig, (RequestContextFactory)requestContextFactoryBuildItem.map(RequestContextFactoryBuildItem::getFactory).orElse(null), beanFactory, launchModeBuildItem.getLaunchMode(), servletPresent, copyVertxContextDataBuildItems.stream().map(CopyVertxContextDataBuildItem::getProperty).collect(Collectors.toList()));
        quarkusRestDeploymentBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveDeploymentBuildItem((RuntimeValue<Deployment>)deployment, deploymentPath));
        if (!requestContextFactoryBuildItem.isPresent()) {
            Handler handler = recorder.handler(deployment);
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute(deploymentPath, Integer.valueOf(10000 + orderAdd)).handler(handler).build());
            Object matchPath = deploymentPath;
            matchPath = ((String)matchPath).endsWith("/") ? (String)matchPath + "*" : (String)matchPath + "/*";
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute((String)matchPath, Integer.valueOf(10000 + orderAdd)).handler(handler).build());
        }
    }

    private void checkForDuplicateEndpoint(ResteasyReactiveConfig config, Map<String, List<EndpointConfig>> allMethods) {
        String message = allMethods.values().stream().map(this::getDuplicateEndpointMessage).filter(Objects::nonNull).collect(Collectors.joining());
        if (message.length() > 0) {
            if (config.failOnDuplicate) {
                throw new ConfigurationError(message);
            }
            log.warning(message);
        }
    }

    private void addResourceMethodByPath(Map<String, List<EndpointConfig>> allMethods, String path, ClassInfo info, ResourceMethod rm) {
        allMethods.computeIfAbsent(this.getEndpointClassifier(rm, path), key -> new ArrayList()).addAll(this.getEndpointConfigs(path, info, rm));
    }

    private String getEndpointClassifier(ResourceMethod resourceMethod, String path) {
        return resourceMethod.getHttpMethod() + " " + (path.equals("/") ? "" : path) + resourceMethod.getPath();
    }

    private String getDuplicateEndpointMessage(List<EndpointConfig> endpoints) {
        StringBuilder message = new StringBuilder();
        if (endpoints.size() < 2) {
            return null;
        }
        Map<String, List<EndpointConfig>> duplicatesByMimeTypes = endpoints.stream().collect(Collectors.groupingBy(EndpointConfig::toString));
        for (Map.Entry<String, List<EndpointConfig>> duplicates : duplicatesByMimeTypes.entrySet()) {
            if (duplicates.getValue().size() < 2) continue;
            message.append(endpoints.get(0).getExposedEndpoint()).append(" is declared by :").append(System.lineSeparator());
            for (EndpointConfig config : duplicates.getValue()) {
                message.append(config.toCompleteString()).append(System.lineSeparator());
            }
        }
        return message.toString();
    }

    private List<EndpointConfig> getEndpointConfigs(String path, ClassInfo info, ResourceMethod rm) {
        ArrayList<EndpointConfig> result = new ArrayList<EndpointConfig>();
        String exposingMethod = info.name().toString() + "#" + rm.getName();
        if (isEmpty.test(rm.getConsumes()) && isEmpty.test(rm.getProduces())) {
            result.add(new EndpointConfig(path, rm.getHttpMethod(), null, null, exposingMethod));
        } else if (isEmpty.negate().test(rm.getConsumes()) && isEmpty.test(rm.getProduces())) {
            for (String consume : rm.getConsumes()) {
                result.add(new EndpointConfig(path, rm.getHttpMethod(), consume, null, exposingMethod));
            }
        } else if (isEmpty.test(rm.getConsumes()) && isEmpty.negate().test(rm.getProduces())) {
            for (String produce : rm.getProduces()) {
                result.add(new EndpointConfig(path, rm.getHttpMethod(), null, produce, exposingMethod));
            }
        } else {
            for (String consume : rm.getConsumes()) {
                for (String produce : rm.getProduces()) {
                    result.add(new EndpointConfig(path, rm.getHttpMethod(), consume, produce, exposingMethod));
                }
            }
        }
        return result;
    }

    private org.jboss.resteasy.reactive.common.ResteasyReactiveConfig createRestReactiveConfig(ResteasyReactiveConfig config) {
        Config mpConfig = ConfigProvider.getConfig();
        return new org.jboss.resteasy.reactive.common.ResteasyReactiveConfig(this.getEffectivePropertyValue("input-buffer-size", config.inputBufferSize.asLongValue(), Long.class, mpConfig).longValue(), this.getEffectivePropertyValue("output-buffer-size", config.outputBufferSize, Integer.class, mpConfig).intValue(), this.getEffectivePropertyValue("single-default-produces", config.singleDefaultProduces, Boolean.class, mpConfig).booleanValue(), this.getEffectivePropertyValue("default-produces", config.defaultProduces, Boolean.class, mpConfig).booleanValue());
    }

    private <T> T getEffectivePropertyValue(String legacyPropertyName, T newPropertyValue, Class<T> propertyType, Config mpConfig) {
        Optional legacyPropertyValue = mpConfig.getOptionalValue("quarkus.rest." + legacyPropertyName, propertyType);
        if (legacyPropertyValue.isPresent()) {
            return legacyPropertyValue.get();
        }
        return newPropertyValue;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void applyRuntimeConfig(ResteasyReactiveRuntimeRecorder recorder, Optional<ResteasyReactiveDeploymentBuildItem> deployment, ResteasyReactiveServerRuntimeConfig resteasyReactiveServerRuntimeConf) {
        if (!deployment.isPresent()) {
            return;
        }
        recorder.configure(deployment.get().getDeployment(), resteasyReactiveServerRuntimeConf);
    }

    @BuildStep
    public void securityExceptionMappers(BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationCompletionExceptionMapper.class.getName(), AuthenticationCompletionException.class.getName(), Integer.valueOf(5001), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationRedirectExceptionMapper.class.getName(), AuthenticationRedirectException.class.getName(), Integer.valueOf(5001), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(ForbiddenExceptionMapper.class.getName(), ForbiddenException.class.getName(), Integer.valueOf(5001), false));
    }

    @BuildStep
    MethodScannerBuildItem integrateEagerSecurity(Capabilities capabilities, CombinedIndexBuildItem indexBuildItem) {
        if (!capabilities.isPresent("io.quarkus.security")) {
            return null;
        }
        final IndexView index = indexBuildItem.getComputingIndex();
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                return Objects.requireNonNullElse(ResteasyReactiveProcessor.this.consumeStandardSecurityAnnotations(method, actualEndpointClass, index, c -> Collections.singletonList(new EagerSecurityHandler.Customizer())), Collections.emptyList());
            }
        });
    }

    private <T> T consumeStandardSecurityAnnotations(MethodInfo methodInfo, ClassInfo classInfo, IndexView index, Function<ClassInfo, T> function) {
        if (SecurityTransformerUtils.hasStandardSecurityAnnotation(methodInfo)) {
            return function.apply(methodInfo.declaringClass());
        }
        ClassInfo c = classInfo;
        while (c.superName() != null) {
            if (SecurityTransformerUtils.hasStandardSecurityAnnotation(c)) {
                return function.apply(c);
            }
            c = index.getClassByName(c.superName());
        }
        return null;
    }

    private Optional<String> getAppPath(Optional<String> newPropertyValue) {
        Optional legacyProperty = ConfigProvider.getConfig().getOptionalValue("quarkus.rest.path", String.class);
        if (legacyProperty.isPresent()) {
            return legacyProperty;
        }
        return newPropertyValue;
    }

    private String determineApplicationPath(ApplicationScanningResult appResult, Optional<String> defaultPath) {
        if (appResult.getSelectedAppClass() == null) {
            return defaultPath.orElse("/");
        }
        AnnotationInstance applicationPathValue = appResult.getSelectedAppClass().classAnnotation(ResteasyReactiveDotNames.APPLICATION_PATH);
        if (applicationPathValue == null) {
            return defaultPath.orElse("/");
        }
        String applicationPath = null;
        if (applicationPathValue.value() != null) {
            applicationPath = applicationPathValue.value().asString();
        }
        return applicationPath;
    }

    private String sanitizeApplicationPath(String applicationPath) {
        if (applicationPath == null || ((String)applicationPath).isEmpty() || "/".equals(applicationPath)) {
            return "/";
        }
        if (((String)(applicationPath = ((String)applicationPath).trim())).equals("/")) {
            applicationPath = "";
        }
        if (!((String)applicationPath).startsWith("/")) {
            applicationPath = "/" + (String)applicationPath;
        }
        if (((String)applicationPath).endsWith("/")) {
            applicationPath = ((String)applicationPath).substring(0, ((String)applicationPath).length() - 1);
        }
        return applicationPath;
    }

    private void registerWriter(ResteasyReactiveRecorder recorder, ServerSerialisers serialisers, String entityClass, String writerClass, BeanContainer beanContainer, String mediaType) {
        ResourceWriter writer = new ResourceWriter();
        writer.setFactory(recorder.factory(writerClass, beanContainer));
        writer.setMediaTypeStrings(Collections.singletonList(mediaType));
        recorder.registerWriter((Serialisers)serialisers, entityClass, writer);
    }

    private void registerReader(ResteasyReactiveRecorder recorder, ServerSerialisers serialisers, String entityClass, String readerClass, BeanContainer beanContainer, String mediaType, RuntimeType constraint) {
        ResourceReader reader = new ResourceReader();
        reader.setFactory(recorder.factory(readerClass, beanContainer));
        reader.setMediaTypeStrings(Collections.singletonList(mediaType));
        reader.setConstraint(constraint);
        recorder.registerReader((Serialisers)serialisers, entityClass, reader);
    }
}

