/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BuildTimeEnabledProcessor;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.LookupConditionsProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsContributorBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.CompressionScanner;
import io.quarkus.resteasy.reactive.server.deployment.ContextResolversBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ParamConverterProvidersBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.server.spi.UnwrappedExceptionBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.ContextResolverBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ParamConverterBuildItem;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import jakarta.transaction.RollbackException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.core.BlockingNotAllowedException;
import org.jboss.resteasy.reactive.common.model.ResourceContextResolver;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceParamConverterProvider;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveInterceptorScanner;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.processor.generation.exceptionmappers.ServerExceptionMapperGenerator;
import org.jboss.resteasy.reactive.server.processor.generation.filters.FilterGeneration;
import org.jboss.resteasy.reactive.server.processor.scanning.AsyncReturnTypeScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.CacheControlScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveContextResolverScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveExceptionMappingScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveFeatureScanner;
import org.jboss.resteasy.reactive.server.processor.util.GeneratedClass;

public class ResteasyReactiveScanningProcessor {
    public static final Set<DotName> CONDITIONAL_BEAN_ANNOTATIONS = new HashSet<DotName>(BuildTimeEnabledProcessor.BUILD_TIME_ENABLED_BEAN_ANNOTATIONS);

    @BuildStep
    public MethodScannerBuildItem asyncSupport() {
        return new MethodScannerBuildItem((MethodScanner)new AsyncReturnTypeScanner());
    }

    @BuildStep
    public MethodScannerBuildItem cacheControlSupport() {
        return new MethodScannerBuildItem((MethodScanner)new CacheControlScanner());
    }

    @BuildStep
    public MethodScannerBuildItem compressionSupport(HttpBuildTimeConfig httpBuildTimeConfig) {
        return new MethodScannerBuildItem((MethodScanner)new CompressionScanner(httpBuildTimeConfig));
    }

    @BuildStep
    public ResourceInterceptorsContributorBuildItem scanForInterceptors(final CombinedIndexBuildItem combinedIndexBuildItem, final ApplicationResultBuildItem applicationResultBuildItem) {
        return new ResourceInterceptorsContributorBuildItem((Consumer)new Consumer<ResourceInterceptors>(){

            @Override
            public void accept(ResourceInterceptors interceptors) {
                ResteasyReactiveInterceptorScanner.scanForContainerRequestFilters((ResourceInterceptors)interceptors, (IndexView)combinedIndexBuildItem.getIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
            }
        });
    }

    @BuildStep
    public List<UnwrappedExceptionBuildItem> defaultUnwrappedException() {
        return List.of(new UnwrappedExceptionBuildItem(ArcUndeclaredThrowableException.class), new UnwrappedExceptionBuildItem(RollbackException.class));
    }

    @BuildStep
    public ExceptionMappersBuildItem scanForExceptionMappers(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<ExceptionMapperBuildItem> mappers, List<UnwrappedExceptionBuildItem> unwrappedExceptions, Capabilities capabilities) {
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ExceptionMapping exceptions = ResteasyReactiveExceptionMappingScanner.scanForExceptionMappers((IndexView)combinedIndexBuildItem.getComputingIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
        exceptions.addBlockingProblem(BlockingOperationNotAllowedException.class);
        exceptions.addBlockingProblem(BlockingNotAllowedException.class);
        for (UnwrappedExceptionBuildItem unwrappedExceptionBuildItem : unwrappedExceptions) {
            exceptions.addUnwrappedException(unwrappedExceptionBuildItem.getThrowableClass().getName());
        }
        if (capabilities.isPresent("io.quarkus.hibernate.reactive")) {
            exceptions.addNonBlockingProblem((Predicate)new ExceptionMapping.ExceptionTypeAndMessageContainsPredicate(IllegalStateException.class, "HR000068"));
        }
        for (Map.Entry entry : exceptions.getMappers().entrySet()) {
            beanBuilder.addBeanClass(((ResourceExceptionMapper)entry.getValue()).getClassName());
        }
        for (ExceptionMapperBuildItem exceptionMapperBuildItem : mappers) {
            if (exceptionMapperBuildItem.isRegisterAsBean()) {
                beanBuilder.addBeanClass(exceptionMapperBuildItem.getClassName());
            } else {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{exceptionMapperBuildItem.getClassName()}));
            }
            int priority = 5000;
            if (exceptionMapperBuildItem.getPriority() != null) {
                priority = exceptionMapperBuildItem.getPriority();
            }
            ResourceExceptionMapper mapper = new ResourceExceptionMapper();
            mapper.setPriority(priority);
            mapper.setClassName(exceptionMapperBuildItem.getClassName());
            ResteasyReactiveScanningProcessor.addRuntimeCheckIfNecessary(exceptionMapperBuildItem, (ResourceExceptionMapper<Throwable>)mapper);
            exceptions.addExceptionMapper(exceptionMapperBuildItem.getHandledExceptionName(), mapper);
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.build());
        return new ExceptionMappersBuildItem(exceptions);
    }

    private static void addRuntimeCheckIfNecessary(ExceptionMapperBuildItem additionalExceptionMapper, ResourceExceptionMapper<Throwable> mapper) {
        ClassInfo declaringClass = additionalExceptionMapper.getDeclaringClass();
        if (declaringClass != null) {
            boolean needsRuntimeCheck = false;
            List classAnnotations = declaringClass.declaredAnnotations();
            for (AnnotationInstance classAnnotation : classAnnotations) {
                if (!CONDITIONAL_BEAN_ANNOTATIONS.contains(classAnnotation.name())) continue;
                needsRuntimeCheck = true;
                break;
            }
            if (needsRuntimeCheck) {
                mapper.setDiscardAtRuntime((Supplier)new ResourceExceptionMapper.DiscardAtRuntimeIfBeanIsUnavailable(declaringClass.name().toString()));
            }
        }
    }

    @BuildStep
    public ParamConverterProvidersBuildItem scanForParamConverters(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<ParamConverterBuildItem> paramConverterBuildItems) {
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ParamConverterProviders paramConverterProviders = new ParamConverterProviders();
        for (ParamConverterBuildItem additionalParamConverter : paramConverterBuildItems) {
            if (additionalParamConverter.isRegisterAsBean()) {
                beanBuilder.addBeanClass(additionalParamConverter.getClassName());
            } else {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{additionalParamConverter.getClassName()}));
            }
            int priority = 5000;
            if (additionalParamConverter.getPriority() != null) {
                priority = additionalParamConverter.getPriority();
            }
            ResourceParamConverterProvider provider = new ResourceParamConverterProvider();
            provider.setPriority(Integer.valueOf(priority));
            provider.setClassName(additionalParamConverter.getClassName());
            paramConverterProviders.addParamConverterProviders(provider);
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.build());
        return new ParamConverterProvidersBuildItem(paramConverterProviders);
    }

    @BuildStep
    public void scanForDynamicFeatures(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<DynamicFeatureBuildItem> dynamicFeatureBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Set features = ResteasyReactiveFeatureScanner.scanForDynamicFeatures((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (String dynamicFeatureClass : features) {
            dynamicFeatureBuildItemBuildProducer.produce((BuildItem)new DynamicFeatureBuildItem(dynamicFeatureClass, true));
        }
    }

    @BuildStep
    public void scanForFeatures(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<JaxrsFeatureBuildItem> featureBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Set features = ResteasyReactiveFeatureScanner.scanForFeatures((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (String feature : features) {
            featureBuildItemBuildProducer.produce((BuildItem)new JaxrsFeatureBuildItem(feature, true));
        }
    }

    @BuildStep
    public ContextResolversBuildItem scanForContextResolvers(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<ContextResolverBuildItem> additionalResolvers) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ContextResolvers resolvers = ResteasyReactiveContextResolverScanner.scanForContextResolvers((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (Map.Entry entry : resolvers.getResolvers().entrySet()) {
            for (ResourceContextResolver i : (List)entry.getValue()) {
                beanBuilder.addBeanClass(i.getClassName());
            }
        }
        for (ContextResolverBuildItem i : additionalResolvers) {
            if (i.isRegisterAsBean()) {
                beanBuilder.addBeanClass(i.getClassName());
            } else {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{i.getClassName()}));
            }
            ResourceContextResolver resolver = new ResourceContextResolver();
            resolver.setClassName(i.getClassName());
            resolver.setMediaTypeStrings(i.getMediaTypes());
            try {
                resolvers.addContextResolver(Class.forName(i.getProvidedType(), false, Thread.currentThread().getContextClassLoader()), resolver);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load handled exception type " + i.getProvidedType(), e);
            }
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.build());
        return new ContextResolversBuildItem(resolvers);
    }

    @BuildStep
    public void scanForParamConverters(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<ParamConverterBuildItem> paramConverterBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Collection paramConverterProviders = index.getAllKnownImplementors(ResteasyReactiveDotNames.PARAM_CONVERTER_PROVIDER);
        for (ClassInfo converterClass : paramConverterProviders) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationResultBuildItem.getResult().keepProvider(converterClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            AnnotationInstance priorityInstance = converterClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            paramConverterBuildItemBuildProducer.produce((BuildItem)new ParamConverterBuildItem(converterClass.name().toString(), priorityInstance != null ? priorityInstance.value().asInt() : 5000, true));
        }
    }

    @BuildStep
    public void handleCustomAnnotatedMethods(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBean, List<CustomContainerRequestFilterBuildItem> customContainerRequestFilters, List<CustomContainerResponseFilterBuildItem> customContainerResponseFilters, List<CustomExceptionMapperBuildItem> customExceptionMappers, BuildProducer<ContainerRequestFilterBuildItem> additionalContainerRequestFilters, BuildProducer<ContainerResponseFilterBuildItem> additionalContainerResponseFilters, BuildProducer<ExceptionMapperBuildItem> additionalExceptionMappers, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        AdditionalBeanBuildItem.Builder additionalBeans = AdditionalBeanBuildItem.builder();
        if (!(customContainerRequestFilters.isEmpty() && customContainerResponseFilters.isEmpty() && customExceptionMappers.isEmpty())) {
            Indexer indexer = new Indexer();
            HashSet additionalIndex = new HashSet();
            for (CustomContainerRequestFilterBuildItem customContainerRequestFilterBuildItem : customContainerRequestFilters) {
                IndexingUtil.indexClass((String)customContainerRequestFilterBuildItem.getClassName(), (Indexer)indexer, (IndexView)combinedIndexBuildItem.getIndex(), (Set)additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            for (CustomContainerResponseFilterBuildItem customContainerResponseFilterBuildItem : customContainerResponseFilters) {
                IndexingUtil.indexClass((String)customContainerResponseFilterBuildItem.getClassName(), (Indexer)indexer, (IndexView)combinedIndexBuildItem.getIndex(), (Set)additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            for (CustomExceptionMapperBuildItem customExceptionMapperBuildItem : customExceptionMappers) {
                IndexingUtil.indexClass((String)customExceptionMapperBuildItem.getClassName(), (Indexer)indexer, (IndexView)combinedIndexBuildItem.getIndex(), (Set)additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            index = CompositeIndex.create((IndexView[])new IndexView[]{index, indexer.complete()});
        }
        List generatedFilters = FilterGeneration.generate((IndexView)index, Set.of(QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST, QuarkusResteasyReactiveDotNames.HTTP_SERVER_RESPONSE, QuarkusResteasyReactiveDotNames.ROUTING_CONTEXT), Set.of(Unremovable.class.getName()), methodInfo -> {
            List methodAnnotations = methodInfo.annotations();
            for (AnnotationInstance methodAnnotation : methodAnnotations) {
                if (!CONDITIONAL_BEAN_ANNOTATIONS.contains(methodAnnotation.name())) continue;
                throw new RuntimeException("The combination of '@" + methodAnnotation.name().withoutPackagePrefix() + "' and '@ServerRequestFilter' or '@ServerResponseFilter' is not allowed. Offending method is '" + methodInfo.name() + "' of class '" + methodInfo.declaringClass().name() + "'");
            }
            List classAnnotations = methodInfo.declaringClass().declaredAnnotations();
            for (AnnotationInstance classAnnotation : classAnnotations) {
                if (!CONDITIONAL_BEAN_ANNOTATIONS.contains(classAnnotation.name())) continue;
                return true;
            }
            return false;
        });
        for (FilterGeneration.GeneratedFilter generated : generatedFilters) {
            for (GeneratedClass i : generated.getGeneratedClasses()) {
                generatedBean.produce((BuildItem)new GeneratedBeanBuildItem(i.getName(), i.getData()));
            }
            if (generated.isRequestFilter()) {
                additionalBeans.addBeanClass(generated.getDeclaringClassName());
                ContainerRequestFilterBuildItem.Builder builder = ((ContainerRequestFilterBuildItem.Builder)((ContainerRequestFilterBuildItem.Builder)new ContainerRequestFilterBuildItem.Builder(generated.getGeneratedClassName()).setRegisterAsBean(false)).setPriority(generated.getPriority())).setPreMatching(generated.isPreMatching()).setNonBlockingRequired(generated.isNonBlocking()).setWithFormRead(generated.isWithFormRead()).setFilterSourceMethod(generated.getFilterSourceMethod());
                if (!generated.getNameBindingNames().isEmpty()) {
                    builder.setNameBindingNames(generated.getNameBindingNames());
                }
                additionalContainerRequestFilters.produce((BuildItem)builder.build());
                continue;
            }
            additionalBeans.addBeanClass(generated.getDeclaringClassName());
            ContainerResponseFilterBuildItem.Builder builder = ((ContainerResponseFilterBuildItem.Builder)((ContainerResponseFilterBuildItem.Builder)new ContainerResponseFilterBuildItem.Builder(generated.getGeneratedClassName()).setRegisterAsBean(false)).setPriority(generated.getPriority())).setFilterSourceMethod(generated.getFilterSourceMethod());
            if (!generated.getNameBindingNames().isEmpty()) {
                builder.setNameBindingNames(generated.getNameBindingNames());
            }
            additionalContainerResponseFilters.produce((BuildItem)builder.build());
        }
        HashSet classLevelExceptionMappers = new HashSet(resourceScanningResultBuildItem.map(s -> s.getResult().getClassLevelExceptionMappers()).orElse(Collections.emptyList()));
        for (AnnotationInstance annotationInstance : index.getAnnotations(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER)) {
            MethodInfo methodInfo2;
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD || classLevelExceptionMappers.contains(methodInfo2 = annotationInstance.target().asMethod())) continue;
            additionalBeans.addBeanClass(methodInfo2.declaringClass().name().toString());
            Map generatedClassNames = ServerExceptionMapperGenerator.generateGlobalMapper((MethodInfo)methodInfo2, (ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBean), Set.of(QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST, QuarkusResteasyReactiveDotNames.HTTP_SERVER_RESPONSE, QuarkusResteasyReactiveDotNames.ROUTING_CONTEXT), Set.of(Unremovable.class.getName()), m -> {
                List methodAnnotations = m.annotations();
                for (AnnotationInstance methodAnnotation : methodAnnotations) {
                    if (!CONDITIONAL_BEAN_ANNOTATIONS.contains(methodAnnotation.name())) continue;
                    throw new RuntimeException("The combination of '@" + methodAnnotation.name().withoutPackagePrefix() + "' and '@ServerExceptionMapper' is not allowed. Offending method is '" + m.name() + "' of class '" + m.declaringClass().name() + "'");
                }
                List classAnnotations = m.declaringClass().declaredAnnotations();
                for (AnnotationInstance classAnnotation : classAnnotations) {
                    if (!CONDITIONAL_BEAN_ANNOTATIONS.contains(classAnnotation.name())) continue;
                    return true;
                }
                return false;
            });
            for (Map.Entry entry : generatedClassNames.entrySet()) {
                ExceptionMapperBuildItem.Builder builder = new ExceptionMapperBuildItem.Builder((String)entry.getValue(), (String)entry.getKey()).setRegisterAsBean(false).setDeclaringClass(methodInfo2.declaringClass());
                AnnotationValue priorityValue = annotationInstance.value("priority");
                if (priorityValue != null) {
                    builder.setPriority(Integer.valueOf(priorityValue.asInt()));
                }
                additionalExceptionMappers.produce((BuildItem)builder.build());
            }
        }
        additionalBean.produce((BuildItem)additionalBeans.setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
    }

    static {
        CONDITIONAL_BEAN_ANNOTATIONS.addAll(LookupConditionsProcessor.LOOKUP_BEAN_ANNOTATIONS);
    }
}

