/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.security.Authenticated;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class SecurityTransformerUtils {
    public static final Set<DotName> SECURITY_BINDINGS = new HashSet<DotName>();

    public static boolean hasStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.hasStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static boolean hasStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.hasStandardSecurityAnnotation(classInfo.classAnnotations());
    }

    private static boolean hasStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_BINDINGS.contains(instance.name())) continue;
            return true;
        }
        return false;
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(classInfo.classAnnotations());
    }

    private static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_BINDINGS.contains(instance.name())) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    static {
        SECURITY_BINDINGS.add(DotName.createSimple((String)RolesAllowed.class.getName()));
        SECURITY_BINDINGS.add(DotName.createSimple((String)Authenticated.class.getName()));
        SECURITY_BINDINGS.add(DotName.createSimple((String)DenyAll.class.getName()));
        SECURITY_BINDINGS.add(DotName.createSimple((String)PermitAll.class.getName()));
    }
}

