/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.JsonDefaultProducersHandler;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ScannedSerializer;
import org.jboss.resteasy.reactive.common.processor.scanning.SerializerScanningResult;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;
import org.jboss.resteasy.reactive.server.spi.EndpointInvokerFactory;

public class QuarkusServerEndpointIndexer
extends ServerEndpointIndexer {
    private static final Logger LOGGER = Logger.getLogger(QuarkusServerEndpointIndexer.class);
    private final Capabilities capabilities;
    private final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    private final DefaultProducesHandler defaultProducesHandler;
    private final JsonDefaultProducersHandler jsonDefaultProducersHandler;
    private final ResteasyReactiveRecorder resteasyReactiveRecorder;
    private SerializerScanningResult serializerScanningResult;
    private DefaultProducesHandler.Context currentDefaultProducesContext;

    QuarkusServerEndpointIndexer(Builder builder) {
        super((ServerEndpointIndexer.AbstractBuilder)builder);
        this.capabilities = builder.capabilities;
        this.generatedClassBuildItemBuildProducer = builder.generatedClassBuildItemBuildProducer;
        this.defaultProducesHandler = builder.defaultProducesHandler;
        this.resteasyReactiveRecorder = builder.resteasyReactiveRecorder;
        this.jsonDefaultProducersHandler = new JsonDefaultProducersHandler();
    }

    protected void setupApplyDefaults(final Type nonAsyncReturnType, final DotName httpMethod) {
        this.currentDefaultProducesContext = new DefaultProducesHandler.Context(){

            public Type nonAsyncReturnType() {
                return nonAsyncReturnType;
            }

            public DotName httpMethod() {
                return httpMethod;
            }

            public IndexView index() {
                return QuarkusServerEndpointIndexer.this.applicationIndex;
            }

            public ResteasyReactiveConfig config() {
                return QuarkusServerEndpointIndexer.this.config;
            }
        };
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        List defaultMediaTypes = this.defaultProducesHandler.handle(this.currentDefaultProducesContext);
        if (defaultMediaTypes != null && !defaultMediaTypes.isEmpty()) {
            String[] result = new String[defaultMediaTypes.size()];
            for (int i = 0; i < defaultMediaTypes.size(); ++i) {
                result[i] = ((MediaType)defaultMediaTypes.get(i)).toString();
            }
            return result;
        }
        return super.applyAdditionalDefaults(nonAsyncReturnType);
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ServerIndexedParameter builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        methodContext.put(GeneratedClassBuildItem.class.getName(), this.generatedClassBuildItemBuildProducer);
        methodContext.put(EndpointInvokerFactory.class.getName(), this.resteasyReactiveRecorder);
        return super.handleCustomParameter(anns, builder, paramType, field, methodContext);
    }

    protected void handleAdditionalMethodProcessing(ServerResourceMethod method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
        super.handleAdditionalMethodProcessing(method, currentClassInfo, info, annotationStore);
        this.warnAboutMissingJsonProviderIfNeeded(method, info);
    }

    private void warnAboutMissingJsonProviderIfNeeded(ServerResourceMethod method, MethodInfo info) {
        if (!this.capabilities.isCapabilityWithPrefixMissing("io.quarkus.resteasy.reactive.json")) {
            return;
        }
        if (this.hasJson(method) || this.hasNoTypesDefined(method) && this.isDefaultJson()) {
            if (this.serializerScanningResult == null) {
                this.serializerScanningResult = ResteasyReactiveScanner.scanForSerializers((IndexView)this.index, (ApplicationScanningResult)this.applicationScanningResult);
            }
            boolean appProvidedJsonReaderExists = this.appProvidedJsonProviderExists(this.serializerScanningResult.getReaders());
            boolean appProvidedJsonWriterExists = this.appProvidedJsonProviderExists(this.serializerScanningResult.getWriters());
            if (!appProvidedJsonReaderExists || !appProvidedJsonWriterExists) {
                LOGGER.warnf("Quarkus detected the use of JSON in JAX-RS method '" + info.declaringClass().name() + "#" + info.name() + "' but no JSON extension has been added. Consider adding 'quarkus-resteasy-reactive-jackson' or 'quarkus-resteasy-reactive-jsonb'.", new Object[0]);
            }
        }
    }

    private boolean appProvidedJsonProviderExists(List<ScannedSerializer> providers) {
        boolean appProvidedJsonReaderExists = false;
        for (ScannedSerializer provider : providers) {
            for (String mt : provider.getMediaTypeStrings()) {
                if (!this.isJson(mt)) continue;
                appProvidedJsonReaderExists = true;
                break;
            }
            if (!appProvidedJsonReaderExists) continue;
            break;
        }
        return appProvidedJsonReaderExists;
    }

    private boolean isDefaultJson() {
        List mediaTypes = this.jsonDefaultProducersHandler.handle(this.currentDefaultProducesContext);
        for (MediaType mediaType : mediaTypes) {
            if (!this.isJson(mediaType.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean hasJson(ServerResourceMethod method) {
        return this.hasJson(method.getProduces()) || this.hasJson(method.getConsumes()) || this.isJson(method.getStreamElementType());
    }

    private boolean hasNoTypesDefined(ServerResourceMethod method) {
        return !(method.getProduces() != null && method.getProduces().length != 0 || method.getConsumes() != null && method.getConsumes().length != 0 || method.getStreamElementType() != null);
    }

    private boolean hasJson(String[] types) {
        if (types == null) {
            return false;
        }
        for (String type : types) {
            if (!this.isJson(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isJson(String type) {
        if (type == null) {
            return false;
        }
        return type.startsWith("application/json");
    }

    public static final class Builder
    extends ServerEndpointIndexer.AbstractBuilder<Builder> {
        private final Capabilities capabilities;
        private BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
        private ResteasyReactiveRecorder resteasyReactiveRecorder;
        private DefaultProducesHandler defaultProducesHandler = DefaultProducesHandler.Noop.INSTANCE;
        public Predicate<String> applicationClassPredicate;

        public Builder(Capabilities capabilities) {
            this.capabilities = capabilities;
        }

        public QuarkusServerEndpointIndexer build() {
            return new QuarkusServerEndpointIndexer(this);
        }

        public Builder setGeneratedClassBuildItemBuildProducer(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
            this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
            return this;
        }

        public Builder setApplicationClassPredicate(Predicate<String> applicationClassPredicate) {
            this.applicationClassPredicate = applicationClassPredicate;
            return this;
        }

        public Builder setResteasyReactiveRecorder(ResteasyReactiveRecorder resteasyReactiveRecorder) {
            this.resteasyReactiveRecorder = resteasyReactiveRecorder;
            return this;
        }

        public Builder setDefaultProducesHandler(DefaultProducesHandler defaultProducesHandler) {
            this.defaultProducesHandler = defaultProducesHandler;
            return this;
        }
    }
}

