/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonView;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.jackson.CustomSerialization;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class ResteasyReactiveCommonJacksonProcessor {
    private static final DotName JSON_VIEW = DotName.createSimple((String)JsonView.class.getName());
    private static final DotName CUSTOM_SERIALIZATION = DotName.createSimple((String)CustomSerialization.class.getName());

    @BuildStep
    void handleJsonAnnotations(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Collection resourceClasses = resourceScanningResultBuildItem.get().getResult().getScannedResources().values();
        HashSet<String> classesNeedingReflectionOnMethods = new HashSet<String>();
        for (ClassInfo resourceClass : resourceClasses) {
            DotName resourceClassDotName = resourceClass.name();
            if (resourceClass.annotations().containsKey(JSON_VIEW)) {
                classesNeedingReflectionOnMethods.add(resourceClassDotName.toString());
                continue;
            }
            if (!resourceClass.annotations().containsKey(CUSTOM_SERIALIZATION)) continue;
            classesNeedingReflectionOnMethods.add(resourceClassDotName.toString());
            for (AnnotationInstance instance : (List)resourceClass.annotations().get(CUSTOM_SERIALIZATION)) {
                AnnotationValue annotationValue = instance.value();
                if (annotationValue == null) continue;
                Type biFunctionType = annotationValue.asClass();
                ClassInfo biFunctionClassInfo = index.getIndex().getClassByName(biFunctionType.name());
                if (biFunctionClassInfo != null && !biFunctionClassInfo.hasNoArgsConstructor()) {
                    throw new RuntimeException("Class '" + biFunctionClassInfo.name() + "' must contain a no-args constructor");
                }
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{biFunctionType.name().toString()}));
            }
        }
        if (!classesNeedingReflectionOnMethods.isEmpty()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, classesNeedingReflectionOnMethods.toArray(new String[0])));
        }
    }
}

