/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonView;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.jackson.CustomSerialization;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.JacksonMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.JacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyWriter;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class ResteasyReactiveJacksonProcessor {
    private static final DotName JSON_VIEW = DotName.createSimple((String)JsonView.class.getName());
    private static final DotName CUSTOM_SERIALIZATION = DotName.createSimple((String)CustomSerialization.class.getName());

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_JACKSON));
    }

    @BuildStep
    ServerDefaultProducesHandlerBuildItem jsonDefault() {
        return ServerDefaultProducesHandlerBuildItem.json();
    }

    @BuildStep
    void additionalProviders(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JacksonMessageBodyReader.class.getName()).addBeanClass(JacksonMessageBodyWriter.class.getName()).setUnremovable().build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(JacksonMessageBodyReader.class.getName(), Object.class.getName(), Collections.singletonList("application/json")));
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(VertxJsonArrayMessageBodyReader.class.getName(), JsonArray.class.getName(), Collections.singletonList("application/json")));
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(VertxJsonObjectMessageBodyReader.class.getName(), JsonObject.class.getName(), Collections.singletonList("application/json")));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(JacksonMessageBodyWriter.class.getName(), Object.class.getName(), Collections.singletonList("application/json")));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(VertxJsonArrayMessageBodyWriter.class.getName(), JsonArray.class.getName(), Collections.singletonList("application/json")));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(VertxJsonObjectMessageBodyWriter.class.getName(), JsonObject.class.getName(), Collections.singletonList("application/json")));
    }

    @BuildStep
    void handleJsonAnnotations(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Collection resourceClasses = resourceScanningResultBuildItem.get().getResult().getScannedResources().values();
        HashSet<String> classesNeedingReflectionOnMethods = new HashSet<String>();
        for (ClassInfo resourceClass : resourceClasses) {
            DotName resourceClassDotName = resourceClass.name();
            if (resourceClass.annotations().containsKey(JSON_VIEW)) {
                classesNeedingReflectionOnMethods.add(resourceClassDotName.toString());
                continue;
            }
            if (!resourceClass.annotations().containsKey(CUSTOM_SERIALIZATION)) continue;
            classesNeedingReflectionOnMethods.add(resourceClassDotName.toString());
            for (AnnotationInstance instance : (List)resourceClass.annotations().get(CUSTOM_SERIALIZATION)) {
                AnnotationValue annotationValue = instance.value();
                if (annotationValue == null) continue;
                Type biFunctionType = annotationValue.asClass();
                ClassInfo biFunctionClassInfo = index.getIndex().getClassByName(biFunctionType.name());
                if (biFunctionClassInfo != null && !biFunctionClassInfo.hasNoArgsConstructor()) {
                    throw new RuntimeException("Class '" + biFunctionClassInfo.name() + "' must contain a no-args constructor");
                }
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{biFunctionType.name().toString()}));
            }
        }
        if (!classesNeedingReflectionOnMethods.isEmpty()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, classesNeedingReflectionOnMethods.toArray(new String[0])));
        }
    }
}

