/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonFeatureBuildItem;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.ResteasyReactiveJacksonProviderDefinedBuildItem;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.BasicServerJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.FullyFeaturedServerJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.ServerJacksonMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyWriter;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;

public class ResteasyReactiveJacksonProcessor {
    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_JACKSON));
    }

    @BuildStep
    ServerDefaultProducesHandlerBuildItem jsonDefault() {
        return ServerDefaultProducesHandlerBuildItem.json();
    }

    @BuildStep
    ResteasyReactiveJacksonProviderDefinedBuildItem jacksonRegistered() {
        return new ResteasyReactiveJacksonProviderDefinedBuildItem();
    }

    @BuildStep
    void additionalProviders(List<JacksonFeatureBuildItem> jacksonFeatureBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        boolean applicationNeedsSpecialJacksonFeatures = jacksonFeatureBuildItems.isEmpty();
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ServerJacksonMessageBodyReader.class.getName()).addBeanClass(this.getJacksonMessageBodyWriter(applicationNeedsSpecialJacksonFeatures)).setUnremovable().build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(ServerJacksonMessageBodyReader.class.getName(), Object.class.getName(), Collections.singletonList("application/json")));
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(VertxJsonArrayMessageBodyReader.class.getName(), JsonArray.class.getName(), Collections.singletonList("application/json")));
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(VertxJsonObjectMessageBodyReader.class.getName(), JsonObject.class.getName(), Collections.singletonList("application/json")));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(this.getJacksonMessageBodyWriter(applicationNeedsSpecialJacksonFeatures), Object.class.getName(), Collections.singletonList("application/json")));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(VertxJsonArrayMessageBodyWriter.class.getName(), JsonArray.class.getName(), Collections.singletonList("application/json")));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(VertxJsonObjectMessageBodyWriter.class.getName(), JsonObject.class.getName(), Collections.singletonList("application/json")));
    }

    private String getJacksonMessageBodyWriter(boolean applicationNeedsSpecialJacksonFeatures) {
        return applicationNeedsSpecialJacksonFeatures ? BasicServerJacksonMessageBodyWriter.class.getName() : FullyFeaturedServerJacksonMessageBodyWriter.class.getName();
    }
}

