/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.jackson.CustomSerialization;
import io.quarkus.resteasy.reactive.jackson.DisableSecureSerialization;
import io.quarkus.resteasy.reactive.jackson.EnableSecureSerialization;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonFeatureBuildItem;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.ResourceMethodCustomSerializationBuildItem;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.ResteasyReactiveJacksonProviderDefinedBuildItem;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.DefaultMismatchedInputException;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.NativeInvalidDefinitionExceptionMapper;
import io.quarkus.resteasy.reactive.jackson.runtime.security.SecurityCustomSerialization;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.BasicServerJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.FullyFeaturedServerJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.ServerJacksonMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyWriter;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.util.MethodId;

public class ResteasyReactiveJacksonProcessor {
    private static final Logger log = Logger.getLogger(ResteasyReactiveJacksonProcessor.class);
    private static final DotName JSON_VIEW = DotName.createSimple((String)JsonView.class.getName());
    private static final DotName CUSTOM_SERIALIZATION = DotName.createSimple((String)CustomSerialization.class.getName());
    private static final DotName SECURE_FIELD = DotName.createSimple((String)SecureField.class.getName());
    private static final DotName DISABLE_SECURE_SERIALIZATION = DotName.createSimple((String)DisableSecureSerialization.class.getName());
    private static final DotName ENABLE_SECURE_SERIALIZATION = DotName.createSimple((String)EnableSecureSerialization.class.getName());
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final List<String> HANDLED_MEDIA_TYPES = List.of("application/json", "application/x-ndjson", "application/stream+json");

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_JACKSON));
    }

    @BuildStep
    ServerDefaultProducesHandlerBuildItem jsonDefault() {
        return ServerDefaultProducesHandlerBuildItem.json();
    }

    @BuildStep
    ResteasyReactiveJacksonProviderDefinedBuildItem jacksonRegistered() {
        return new ResteasyReactiveJacksonProviderDefinedBuildItem();
    }

    @BuildStep
    ExceptionMapperBuildItem exceptionMappers() {
        return new ExceptionMapperBuildItem(DefaultMismatchedInputException.class.getName(), MismatchedInputException.class.getName(), Integer.valueOf(5100), false);
    }

    @BuildStep
    CustomExceptionMapperBuildItem customExceptionMappers() {
        return new CustomExceptionMapperBuildItem(NativeInvalidDefinitionExceptionMapper.class.getName());
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.builder().addBeanClass(ServerJacksonMessageBodyReader.class.getName()).addBeanClass(BasicServerJacksonMessageBodyWriter.class).addBeanClass(FullyFeaturedServerJacksonMessageBodyWriter.class).setUnremovable().build();
    }

    @BuildStep
    void additionalProviders(List<JacksonFeatureBuildItem> jacksonFeatureBuildItems, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        boolean applicationNeedsSpecialJacksonFeatures = jacksonFeatureBuildItems.isEmpty();
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(ServerJacksonMessageBodyReader.class.getName(), Object.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(VertxJsonArrayMessageBodyReader.class.getName(), JsonArray.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(VertxJsonObjectMessageBodyReader.class.getName(), JsonObject.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(this.getJacksonMessageBodyWriter(applicationNeedsSpecialJacksonFeatures), Object.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(VertxJsonArrayMessageBodyWriter.class.getName(), JsonArray.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(VertxJsonObjectMessageBodyWriter.class.getName(), JsonObject.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).build());
    }

    private String getJacksonMessageBodyWriter(boolean applicationNeedsSpecialJacksonFeatures) {
        return applicationNeedsSpecialJacksonFeatures ? BasicServerJacksonMessageBodyWriter.class.getName() : FullyFeaturedServerJacksonMessageBodyWriter.class.getName();
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void handleJsonAnnotations(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, CombinedIndexBuildItem index, List<ResourceMethodCustomSerializationBuildItem> resourceMethodCustomSerializationBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<JacksonFeatureBuildItem> jacksonFeaturesProducer, ResteasyReactiveServerJacksonRecorder recorder, ShutdownContextBuildItem shutdown) {
        if (resourceScanningResultBuildItem.isEmpty()) {
            return;
        }
        Collection resourceClasses = resourceScanningResultBuildItem.get().getResult().getScannedResources().values();
        HashSet<JacksonFeatureBuildItem.Feature> jacksonFeatures = new HashSet<JacksonFeatureBuildItem.Feature>();
        for (ClassInfo resourceClass : resourceClasses) {
            AnnotationValue annotationValue;
            if (resourceClass.annotations().containsKey(JSON_VIEW)) {
                jacksonFeatures.add(JacksonFeatureBuildItem.Feature.JSON_VIEW);
                for (AnnotationInstance instance : (List)resourceClass.annotations().get(JSON_VIEW)) {
                    Type[] jsonViews;
                    annotationValue = instance.value();
                    if (annotationValue == null || instance.target().kind() != AnnotationTarget.Kind.METHOD || (jsonViews = annotationValue.asClassArray()) == null || jsonViews.length == 0) continue;
                    recorder.recordJsonView(this.getMethodId(instance.target().asMethod()), jsonViews[0].name().toString());
                }
            }
            if (!resourceClass.annotations().containsKey(CUSTOM_SERIALIZATION)) continue;
            jacksonFeatures.add(JacksonFeatureBuildItem.Feature.CUSTOM_SERIALIZATION);
            for (AnnotationInstance instance : (List)resourceClass.annotations().get(CUSTOM_SERIALIZATION)) {
                Type biFunctionType;
                annotationValue = instance.value();
                if (annotationValue == null || instance.target().kind() != AnnotationTarget.Kind.METHOD || (biFunctionType = annotationValue.asClass()) == null) continue;
                ClassInfo biFunctionClassInfo = index.getIndex().getClassByName(biFunctionType.name());
                if (biFunctionClassInfo != null && !biFunctionClassInfo.hasNoArgsConstructor()) {
                    throw new IllegalArgumentException("Class '" + biFunctionClassInfo.name() + "' must contain a no-args constructor");
                }
                reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{biFunctionType.name().toString()}));
                recorder.recordCustomSerialization(this.getMethodId(instance.target().asMethod()), biFunctionType.name().toString());
            }
        }
        for (ResourceMethodCustomSerializationBuildItem bi : resourceMethodCustomSerializationBuildItems) {
            jacksonFeatures.add(JacksonFeatureBuildItem.Feature.CUSTOM_SERIALIZATION);
            String className = bi.getCustomSerializationProvider().getName();
            reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{className}));
            recorder.recordCustomSerialization(this.getMethodId(bi.getMethodInfo(), bi.getDeclaringClassInfo()), className);
        }
        if (!jacksonFeatures.isEmpty()) {
            for (JacksonFeatureBuildItem.Feature jacksonFeature : jacksonFeatures) {
                jacksonFeaturesProducer.produce((BuildItem)new JacksonFeatureBuildItem(jacksonFeature));
            }
            recorder.configureShutdown((ShutdownContext)shutdown);
        }
    }

    @BuildStep
    public void handleFieldSecurity(ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntries, JaxRsResourceIndexBuildItem index, BuildProducer<ResourceMethodCustomSerializationBuildItem> producer) {
        IndexView indexView = index.getIndexView();
        ArrayList<ResourceMethodCustomSerializationBuildItem> result = new ArrayList<ResourceMethodCustomSerializationBuildItem>();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : resourceMethodEntries.getEntries()) {
            ClassInfo effectiveReturnClassInfo;
            Type returnType;
            MethodInfo methodInfo = entry.getMethodInfo();
            if (methodInfo.hasAnnotation(DISABLE_SECURE_SERIALIZATION) || entry.getActualClassInfo().classAnnotation(DISABLE_SECURE_SERIALIZATION) != null && !methodInfo.hasAnnotation(ENABLE_SECURE_SERIALIZATION)) continue;
            ResourceMethod resourceInfo = entry.getResourceMethod();
            boolean isJsonResponse = false;
            if (resourceInfo.getProduces() != null) {
                for (String produces : resourceInfo.getProduces()) {
                    if (!produces.toLowerCase(Locale.ROOT).contains("application/json")) continue;
                    isJsonResponse = true;
                    break;
                }
            }
            if (!isJsonResponse || (returnType = methodInfo.returnType()).kind() == Type.Kind.VOID) continue;
            Type effectiveReturnType = returnType;
            if (effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.UNI) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.MULTI)) {
                if (effectiveReturnType.kind() != Type.Kind.PARAMETERIZED_TYPE) continue;
                effectiveReturnType = (Type)returnType.asParameterizedType().arguments().get(0);
            }
            if (effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.SET) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.COLLECTION) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.LIST)) {
                effectiveReturnType = (Type)effectiveReturnType.asParameterizedType().arguments().get(0);
            } else if (effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.MAP)) {
                effectiveReturnType = (Type)effectiveReturnType.asParameterizedType().arguments().get(1);
            }
            if ((effectiveReturnClassInfo = indexView.getClassByName(effectiveReturnType.name())) == null || effectiveReturnClassInfo.name().equals((Object)ResteasyReactiveDotNames.OBJECT)) continue;
            ClassInfo currentClassInfo = effectiveReturnClassInfo;
            boolean hasSecureFields = false;
            do {
                if (!currentClassInfo.annotations().containsKey(SECURE_FIELD)) continue;
                hasSecureFields = true;
                break;
            } while (!currentClassInfo.superName().equals((Object)ResteasyReactiveDotNames.OBJECT) && (currentClassInfo = indexView.getClassByName(currentClassInfo.superName())) != null);
            if (!hasSecureFields) continue;
            AnnotationInstance customSerializationAnnotation = methodInfo.annotation(CUSTOM_SERIALIZATION);
            if (customSerializationAnnotation != null) {
                log.warn((Object)("Secure serialization will not be applied to method: '" + methodInfo.declaringClass().name() + "#" + methodInfo.name() + "' because it is annotated with @CustomSerialization."));
                continue;
            }
            result.add(new ResourceMethodCustomSerializationBuildItem(methodInfo, entry.getActualClassInfo(), SecurityCustomSerialization.class));
        }
        if (!result.isEmpty()) {
            for (ResourceMethodCustomSerializationBuildItem bi : result) {
                producer.produce((BuildItem)bi);
            }
        }
    }

    private String getMethodId(MethodInfo methodInfo) {
        return this.getMethodId(methodInfo, methodInfo.declaringClass());
    }

    private String getMethodId(MethodInfo methodInfo, ClassInfo declaringClassInfo) {
        ArrayList<String> parameterClassNames = new ArrayList<String>(methodInfo.parameters().size());
        for (Type parameter : methodInfo.parameters()) {
            parameterClassNames.add(parameter.name().toString());
        }
        return MethodId.get((String)methodInfo.name(), (String)declaringClassInfo.name().toString(), (String[])parameterClassNames.toArray(EMPTY_STRING_ARRAY));
    }
}

