/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.resteasy.reactive.server.vertx.providers.serialisers.json.JsonMessageBodyWriterUtil;

public class JacksonMessageBodyWriter
implements ServerMessageBodyWriter<Object> {
    private static final String JSON_VIEW_NAME = JsonView.class.getName();
    private final ObjectWriter writer;

    @Inject
    public JacksonMessageBodyWriter(ObjectMapper mapper) {
        if (mapper.getFactory().isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            JsonFactory jsonFactory = mapper.getFactory().copy();
            jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            this.writer = mapper.writer().with(jsonFactory);
        } else {
            this.writer = mapper.writer();
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonMessageBodyWriterUtil.setContentTypeIfNecessary(httpHeaders);
        if (o instanceof String) {
            entityStream.write(((String)o).getBytes());
        } else {
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    if (!JsonView.class.equals(annotation.annotationType()) || !this.handleJsonView((JsonView)annotation, o, entityStream)) continue;
                    return;
                }
            }
            entityStream.write(this.writer.writeValueAsBytes(o));
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
        return true;
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        JsonMessageBodyWriterUtil.setContentTypeIfNecessary((ServerRequestContext)context);
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes());
        } else {
            Method method;
            ResteasyReactiveResourceInfo resourceInfo = context.getResteasyReactiveResourceInfo();
            if (resourceInfo != null && resourceInfo.getMethodAnnotationNames().contains(JSON_VIEW_NAME) && this.handleJsonView((method = resourceInfo.getMethod()).getAnnotation(JsonView.class), o, stream)) {
                return;
            }
            this.writer.writeValue(stream, o);
        }
        stream.close();
    }

    private boolean handleJsonView(JsonView jsonView, Object o, OutputStream stream) throws IOException {
        if (jsonView != null && jsonView.value().length > 0) {
            this.writer.withView(jsonView.value()[0]).writeValue(stream, o);
            return true;
        }
        return false;
    }
}

