/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.resteasy.reactive.jackson.CustomSerialization;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.JacksonMessageBodyWriterUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.resteasy.reactive.server.vertx.providers.serialisers.json.JsonMessageServerBodyWriterUtil;

public class ServerJacksonMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private static final String JSON_VIEW_NAME = JsonView.class.getName();
    private static final String CUSTOM_SERIALIZATION = CustomSerialization.class.getName();
    private final ObjectMapper originalMapper;
    private final ObjectWriter defaultWriter;
    private final ConcurrentMap<Method, ObjectWriter> perMethodWriter = new ConcurrentHashMap<Method, ObjectWriter>();

    @Inject
    public ServerJacksonMessageBodyWriter(ObjectMapper mapper) {
        this.originalMapper = mapper;
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        JsonMessageServerBodyWriterUtil.setContentTypeIfNecessary((ServerRequestContext)context);
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes());
        } else {
            Method method;
            Set methodAnnotationNames;
            ResteasyReactiveResourceInfo resourceInfo = context.getResteasyReactiveResourceInfo();
            if (resourceInfo != null && ((methodAnnotationNames = resourceInfo.getMethodAnnotationNames()).contains(CUSTOM_SERIALIZATION) ? this.handleCustomSerialization(method = resourceInfo.getMethod(), o, genericType, stream) : methodAnnotationNames.contains(JSON_VIEW_NAME) && this.handleJsonView((method = resourceInfo.getMethod()).getAnnotation(JsonView.class), o, stream))) {
                return;
            }
            this.defaultWriter.writeValue(stream, o);
        }
        stream.close();
    }

    private boolean handleCustomSerialization(Method method, Object o, Type genericType, OutputStream stream) throws IOException {
        CustomSerialization customSerialization = method.getAnnotation(CustomSerialization.class);
        if (customSerialization == null) {
            return false;
        }
        Class biFunctionClass = customSerialization.value();
        ObjectWriter objectWriter = this.perMethodWriter.computeIfAbsent(method, new MethodObjectWriterFunction(biFunctionClass, genericType, this.originalMapper));
        objectWriter.writeValue(stream, o);
        return true;
    }

    private boolean handleJsonView(JsonView jsonView, Object o, OutputStream stream) throws IOException {
        if (jsonView != null && jsonView.value().length > 0) {
            this.defaultWriter.withView(jsonView.value()[0]).writeValue(stream, o);
            return true;
        }
        return false;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.defaultWriter);
    }

    private static class MethodObjectWriterFunction
    implements Function<Method, ObjectWriter> {
        private final Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> clazz;
        private final Type genericType;
        private final ObjectMapper originalMapper;

        public MethodObjectWriterFunction(Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> clazz, Type genericType, ObjectMapper originalMapper) {
            this.clazz = clazz;
            this.genericType = genericType;
            this.originalMapper = originalMapper;
        }

        @Override
        public ObjectWriter apply(Method method) {
            try {
                BiFunction<ObjectMapper, Type, ObjectWriter> biFunctionInstance = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ObjectWriter objectWriter = biFunctionInstance.apply(this.originalMapper, this.genericType);
                JacksonMessageBodyWriterUtil.setNecessaryJsonFactoryConfig((JsonFactory)objectWriter.getFactory());
                return objectWriter;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

