/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.JacksonMessageBodyWriterUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.resteasy.reactive.server.vertx.providers.serialisers.json.JsonMessageServerBodyWriterUtil;

public class BasicServerJacksonMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private final ObjectWriter defaultWriter;

    @Inject
    public BasicServerJacksonMessageBodyWriter(ObjectMapper mapper) {
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        JsonMessageServerBodyWriterUtil.setContentTypeIfNecessary((ServerRequestContext)context);
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes());
        } else {
            this.defaultWriter.writeValue(stream, o);
        }
        stream.close();
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.defaultWriter);
    }
}

