/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jaxb.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.jaxb.deployment.JaxbClassesToBeBoundBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.jaxb.runtime.serialisers.ServerJaxbMessageBodyReader;
import io.quarkus.resteasy.reactive.jaxb.runtime.serialisers.ServerJaxbMessageBodyWriter;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.RuntimeType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public class ResteasyReactiveJaxbProcessor {
    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_JAXB));
    }

    @BuildStep
    void additionalProviders(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ServerJaxbMessageBodyReader.class.getName()).addBeanClass(ServerJaxbMessageBodyWriter.class.getName()).setUnremovable().build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(ServerJaxbMessageBodyReader.class.getName(), Object.class.getName(), List.of("application/xml", "text/xml"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(ServerJaxbMessageBodyWriter.class.getName(), Object.class.getName(), List.of("application/xml", "text/xml"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
    }

    @BuildStep
    void registerClassesToBeBound(ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntries, JaxRsResourceIndexBuildItem index, BuildProducer<JaxbClassesToBeBoundBuildItem> classesToBeBoundBuildItemProducer) {
        HashSet<ClassInfo> classesInfo = new HashSet<ClassInfo>();
        IndexView indexView = index.getIndexView();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : resourceMethodEntries.getEntries()) {
            ResourceMethod resourceInfo = entry.getResourceMethod();
            MethodInfo methodInfo = entry.getMethodInfo();
            ClassInfo effectiveReturnType = this.getEffectiveClassInfo(methodInfo.returnType(), indexView);
            if (effectiveReturnType != null) {
                if (this.producesXml(resourceInfo)) {
                    classesInfo.add(effectiveReturnType);
                }
                if (this.producesMultipart(resourceInfo)) {
                    classesInfo.addAll(this.getEffectivePartsUsingXml(effectiveReturnType, indexView));
                }
            }
            if (!this.consumesXml(resourceInfo) && !this.consumesMultipart(resourceInfo)) continue;
            for (Type parameter : methodInfo.parameterTypes()) {
                ClassInfo effectiveParameter = this.getEffectiveClassInfo(parameter, indexView);
                if (effectiveParameter == null) continue;
                classesInfo.add(effectiveParameter);
            }
        }
        classesToBeBoundBuildItemProducer.produce((BuildItem)new JaxbClassesToBeBoundBuildItem(this.toClasses(classesInfo)));
    }

    @BuildStep
    void setupJaxbContextConfigForValidator(Capabilities capabilities, BuildProducer<JaxbClassesToBeBoundBuildItem> classesToBeBoundProducer) {
        if (capabilities.isPresent("io.quarkus.hibernate.validator")) {
            classesToBeBoundProducer.produce((BuildItem)new JaxbClassesToBeBoundBuildItem(Collections.singletonList("io.quarkus.hibernate.validator.runtime.jaxrs.ViolationReport")));
        }
    }

    private List<ClassInfo> getEffectivePartsUsingXml(ClassInfo returnType, IndexView indexView) {
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        for (FieldInfo field : returnType.fields()) {
            AnnotationValue partTypeValue;
            AnnotationInstance partTypeInstance = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
            if (partTypeInstance == null || (partTypeValue = partTypeInstance.value()) == null || !"application/xml".equals(partTypeValue.asString())) continue;
            classInfos.add(this.getEffectiveClassInfo(field.type(), indexView));
        }
        return classInfos;
    }

    private ClassInfo getEffectiveClassInfo(Type type, IndexView indexView) {
        if (type.kind() == Type.Kind.VOID || type.kind() == Type.Kind.PRIMITIVE) {
            return null;
        }
        Type effectiveType = type;
        if (effectiveType.name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE) || effectiveType.name().equals((Object)ResteasyReactiveDotNames.UNI) || effectiveType.name().equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE) || effectiveType.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || effectiveType.name().equals((Object)ResteasyReactiveDotNames.MULTI)) {
            if (effectiveType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return null;
            }
            effectiveType = (Type)type.asParameterizedType().arguments().get(0);
        }
        if (effectiveType.name().equals((Object)ResteasyReactiveDotNames.SET) || effectiveType.name().equals((Object)ResteasyReactiveDotNames.COLLECTION) || effectiveType.name().equals((Object)ResteasyReactiveDotNames.LIST)) {
            effectiveType = (Type)effectiveType.asParameterizedType().arguments().get(0);
        } else if (effectiveType.name().equals((Object)ResteasyReactiveDotNames.MAP)) {
            effectiveType = (Type)effectiveType.asParameterizedType().arguments().get(1);
        }
        ClassInfo effectiveReturnClassInfo = indexView.getClassByName(effectiveType.name());
        if (effectiveReturnClassInfo == null || effectiveReturnClassInfo.name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
            return null;
        }
        return effectiveReturnClassInfo;
    }

    private boolean consumesXml(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getConsumes(), "application/xml");
    }

    private boolean consumesMultipart(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getConsumes(), "multipart/form-data");
    }

    private boolean producesXml(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getProduces(), "application/xml");
    }

    private boolean producesMultipart(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getProduces(), "multipart/form-data");
    }

    private boolean containsMediaType(String[] types, String mediaType) {
        if (types != null) {
            for (String type : types) {
                if (!type.toLowerCase(Locale.ROOT).contains(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> toClasses(Collection<ClassInfo> classesInfo) {
        ArrayList<String> classes = new ArrayList<String>();
        for (ClassInfo classInfo : classesInfo) {
            classes.add(classInfo.toString());
        }
        return classes;
    }
}

