/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jaxb.runtime.serialisers;

import io.vertx.core.MultiMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXB;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class JaxbMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        this.setContentTypeIfNecessary(httpHeaders);
        JAXB.marshal((Object)o, (OutputStream)entityStream);
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        this.setContentTypeIfNecessary(context);
        OutputStream stream = context.getOrCreateOutputStream();
        JAXB.marshal((Object)o, (OutputStream)stream);
        stream.close();
    }

    private void setContentTypeIfNecessary(MultivaluedMap<String, Object> httpHeaders) {
        Object contentType = httpHeaders.getFirst((Object)"Content-Type");
        if (this.isNotXml(contentType)) {
            httpHeaders.putSingle((Object)"Content-Type", (Object)"application/xml");
        }
    }

    private void setContentTypeIfNecessary(ServerRequestContext context) {
        String currentContentType = null;
        Iterable responseHeaders = context.serverResponse().getAllResponseHeaders();
        if (responseHeaders instanceof MultiMap) {
            currentContentType = ((MultiMap)responseHeaders).get("Content-Type");
        } else {
            for (Map.Entry entry : responseHeaders) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Content-Type")) continue;
                currentContentType = (String)entry.getValue();
                break;
            }
        }
        if (this.isNotXml(currentContentType)) {
            context.serverResponse().setResponseHeader((CharSequence)"Content-Type", (CharSequence)"application/xml");
        }
    }

    private boolean isNotXml(Object contentType) {
        return contentType == null || !contentType.toString().contains("xml");
    }
}

