/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jaxb.runtime.serialisers;

import io.quarkus.jaxb.runtime.JaxbContextConfigRecorder;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.reactive.common.util.StreamUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class ServerJaxbMessageBodyReader
implements ServerMessageBodyReader<Object> {
    @Inject
    Unmarshaller unmarshaller;
    @Context
    Providers providers;

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException, IOException {
        return this.doReadFrom(type, genericType, entityStream);
    }

    public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        return this.doReadFrom(type, genericType, context.getInputStream());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    protected boolean isReadable(MediaType mediaType, Class<?> type) {
        if (mediaType == null) {
            return false;
        }
        if (String.class.equals(type)) {
            return false;
        }
        String subtype = mediaType.getSubtype();
        boolean isCorrectMediaType = "application".equals(mediaType.getType()) || "text".equals(mediaType.getType());
        return isCorrectMediaType && "xml".equalsIgnoreCase(subtype) || subtype.endsWith("+xml") || mediaType.isWildcardSubtype() && (mediaType.isWildcardType() || isCorrectMediaType);
    }

    protected Object unmarshal(InputStream entityStream, Class<Object> type) {
        try {
            JAXBElement item = this.getUnmarshall(type).unmarshal((Source)new StreamSource(entityStream), type);
            return item.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private Unmarshaller getUnmarshall(Class<Object> type) throws JAXBException {
        if (JaxbContextConfigRecorder.isClassBound(type)) {
            return this.unmarshaller;
        }
        return ((JAXBContext)this.providers.getContextResolver(JAXBContext.class, MediaType.APPLICATION_XML_TYPE).getContext(type)).createUnmarshaller();
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) throws IOException {
        if (this.isInputStreamEmpty(entityStream)) {
            return null;
        }
        return this.unmarshal(entityStream, type);
    }

    private boolean isInputStreamEmpty(InputStream entityStream) throws IOException {
        return StreamUtil.isEmpty((InputStream)entityStream) || entityStream.available() == 0;
    }
}

