/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.kotlin.serialization.common.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.kotlin.serialization.common.runtime.KotlinSerializationConfig;
import io.quarkus.resteasy.reactive.kotlin.serialization.common.runtime.KotlinSerializerRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.inject.Singleton;
import kotlinx.serialization.json.Json;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;

public class KotlinSerializationCommonProcessor {
    private static final DotName SERIALIZABLE = DotName.createSimple((String)"kotlinx.serialization.Serializable");
    private static final String COMPANION_FIELD_NAME = "Companion";
    private static final String[] EMPTY_ARRAY = new String[0];

    @BuildStep
    public void registerReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Collection serializableInstances = index.getIndex().getAnnotations(SERIALIZABLE);
        if (serializableInstances.isEmpty()) {
            return;
        }
        ArrayList<String> supportClassNames = new ArrayList<String>(serializableInstances.size());
        ArrayList<String> serializableClassNames = new ArrayList<String>(serializableInstances.size());
        for (AnnotationInstance instance : serializableInstances) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo targetClass = instance.target().asClass();
            DotName targetClassName = targetClass.name();
            serializableClassNames.add(targetClassName.toString());
            FieldInfo field = targetClass.field(COMPANION_FIELD_NAME);
            if (field == null) continue;
            supportClassNames.add(field.type().name().toString());
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, supportClassNames.toArray(EMPTY_ARRAY)));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, true, serializableClassNames.toArray(EMPTY_ARRAY)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public SyntheticBeanBuildItem createJson(KotlinSerializerRecorder recorder, KotlinSerializationConfig config) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Json.class).scope(Singleton.class)).supplier((Supplier)recorder.configFactory(config)).unremovable()).done();
    }
}

