/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.kotlin.serialization.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.kotlin.serialization.common.runtime.JsonProducer;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;

public class KotlinSerializationCommonProcessor {
    private static final DotName SERIALIZABLE = DotName.createSimple((String)"kotlinx.serialization.Serializable");
    private static final String COMPANION_FIELD_NAME = "Companion";
    private static final String[] EMPTY_ARRAY = new String[0];

    @BuildStep
    public void registerReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Collection serializableInstances = index.getIndex().getAnnotations(SERIALIZABLE);
        if (serializableInstances.isEmpty()) {
            return;
        }
        ArrayList<String> supportClassNames = new ArrayList<String>(serializableInstances.size());
        ArrayList<String> serializableClassNames = new ArrayList<String>(serializableInstances.size());
        for (AnnotationInstance instance : serializableInstances) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo targetClass = instance.target().asClass();
            DotName targetClassName = targetClass.name();
            serializableClassNames.add(targetClassName.toString());
            FieldInfo field = targetClass.field(COMPANION_FIELD_NAME);
            if (field == null) continue;
            supportClassNames.add(field.type().name().toString());
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])supportClassNames.toArray(EMPTY_ARRAY)).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])serializableClassNames.toArray(EMPTY_ARRAY)).fields().build());
    }

    @BuildStep
    public void arcIntegration(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JsonProducer.class));
    }
}

