/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kotlin.serialization.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.kotlin.serialization.KotlinSerializationMessageBodyReader;
import io.quarkus.kotlin.serialization.KotlinSerializationMessageBodyWriter;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.RuntimeType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class KotlinSerializationProcessor {
    private static final DotName SERIALIZABLE = DotName.createSimple((String)"kotlinx.serialization.Serializable");
    private static final String COMPANION_CLASS_SUFFIX = "$Companion";

    @BuildStep
    public void registerReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Collection serializableInstances = index.getIndex().getAnnotations(SERIALIZABLE);
        if (serializableInstances.isEmpty()) {
            return;
        }
        ArrayList<CallSite> supportClassNames = new ArrayList<CallSite>(2 * serializableInstances.size());
        for (AnnotationInstance instance : serializableInstances) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            DotName targetClass = instance.target().asClass().name();
            String companionClassName = targetClass.toString() + COMPANION_CLASS_SUFFIX;
            supportClassNames.add((CallSite)((Object)companionClassName));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, supportClassNames.toArray(new String[0])));
    }

    @BuildStep
    public void additionalProviders(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(KotlinSerializationMessageBodyReader.class.getName()).addBeanClass(KotlinSerializationMessageBodyWriter.class.getName()).setUnremovable().build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(KotlinSerializationMessageBodyReader.class.getName(), Object.class.getName(), List.of("application/json"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(KotlinSerializationMessageBodyWriter.class.getName(), Object.class.getName(), List.of("application/json"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
    }

    @BuildStep
    public void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_KOTLIN_SERIALIZATION));
    }

    @BuildStep
    public ServerDefaultProducesHandlerBuildItem jsonDefault() {
        return ServerDefaultProducesHandlerBuildItem.json();
    }
}

