/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.deployment;

import io.quarkus.resteasy.reactive.links.deployment.DotNames;
import io.quarkus.resteasy.reactive.links.runtime.LinkInfo;
import io.quarkus.resteasy.reactive.links.runtime.LinksContainer;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.util.URLUtils;

final class LinksContainerFactory {
    LinksContainerFactory() {
    }

    LinksContainer getLinksContainer(List<ResteasyReactiveResourceMethodEntriesBuildItem.Entry> entries) {
        LinksContainer linksContainer = new LinksContainer();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : entries) {
            MethodInfo resourceMethodInfo = entry.getMethodInfo();
            AnnotationInstance restLinkAnnotation = resourceMethodInfo.annotation(DotNames.REST_LINK_ANNOTATION);
            if (restLinkAnnotation == null) continue;
            LinkInfo linkInfo = this.getLinkInfo(entry.getResourceMethod(), resourceMethodInfo, restLinkAnnotation, entry.getBasicResourceClassInfo().getPath());
            linksContainer.put(linkInfo);
        }
        return linksContainer;
    }

    private LinkInfo getLinkInfo(ResourceMethod resourceMethod, MethodInfo resourceMethodInfo, AnnotationInstance restLinkAnnotation, String resourceClassPath) {
        String rel = this.getAnnotationValue(restLinkAnnotation, "rel", resourceMethod.getName());
        String entityType = this.getAnnotationValue(restLinkAnnotation, "entityType", this.deductEntityType(resourceMethodInfo));
        String path = UriBuilder.fromPath((String)resourceClassPath).path(resourceMethod.getPath()).toTemplate();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Set<String> pathParameters = this.getPathParameters(path);
        return new LinkInfo(rel, entityType, path, pathParameters);
    }

    private String deductEntityType(MethodInfo methodInfo) {
        if (methodInfo.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && methodInfo.returnType().asParameterizedType().arguments().size() == 1) {
            return ((Type)methodInfo.returnType().asParameterizedType().arguments().get(0)).name().toString();
        }
        return methodInfo.returnType().name().toString();
    }

    private Set<String> getPathParameters(String path) {
        HashSet names = new HashSet();
        URLUtils.parsePathParameters((String)path, names);
        HashSet<String> trimmedNames = new HashSet<String>(names.size());
        for (String name : names) {
            trimmedNames.add(name.trim());
        }
        return trimmedNames;
    }

    private String getAnnotationValue(AnnotationInstance annotationInstance, String name, String defaultValue) {
        AnnotationValue value = annotationInstance.value(name);
        if (value == null || value.asString().equals("")) {
            return defaultValue;
        }
        return value.asString();
    }
}

