/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.links.deployment.GetterAccessorImplementor;
import io.quarkus.resteasy.reactive.links.deployment.GetterImplementor;
import io.quarkus.resteasy.reactive.links.deployment.GetterMetadata;
import io.quarkus.resteasy.reactive.links.deployment.LinksContainerFactory;
import io.quarkus.resteasy.reactive.links.deployment.LinksMethodScanner;
import io.quarkus.resteasy.reactive.links.runtime.GetterAccessorsContainer;
import io.quarkus.resteasy.reactive.links.runtime.GetterAccessorsContainerRecorder;
import io.quarkus.resteasy.reactive.links.runtime.LinkInfo;
import io.quarkus.resteasy.reactive.links.runtime.LinksContainer;
import io.quarkus.resteasy.reactive.links.runtime.LinksProviderRecorder;
import io.quarkus.resteasy.reactive.links.runtime.RestLinksProviderProducer;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentInfoBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;

final class LinksProcessor {
    private final GetterAccessorImplementor getterAccessorImplementor = new GetterAccessorImplementor();

    LinksProcessor() {
    }

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_LINKS));
    }

    @BuildStep
    MethodScannerBuildItem linksSupport() {
        return new MethodScannerBuildItem((MethodScanner)new LinksMethodScanner());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initializeLinksProvider(JaxRsResourceIndexBuildItem indexBuildItem, ResteasyReactiveDeploymentInfoBuildItem deploymentInfoBuildItem, ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntriesBuildItem, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer, BuildProducer<GeneratedClassBuildItem> generatedClassesProducer, GetterAccessorsContainerRecorder getterAccessorsContainerRecorder, LinksProviderRecorder linksProviderRecorder) {
        IndexView index = indexBuildItem.getIndexView();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassesProducer, true);
        LinksContainer linksContainer = this.getLinksContainer(deploymentInfoBuildItem, resourceMethodEntriesBuildItem);
        RuntimeValue<GetterAccessorsContainer> getterAccessorsContainer = this.implementPathParameterValueGetters(index, (ClassOutput)classOutput, linksContainer, getterAccessorsContainerRecorder, bytecodeTransformersProducer);
        linksProviderRecorder.setGetterAccessorsContainer(getterAccessorsContainer);
        linksProviderRecorder.setLinksContainer(linksContainer);
    }

    @BuildStep
    AdditionalBeanBuildItem registerRestLinksProviderProducer() {
        return AdditionalBeanBuildItem.unremovableOf(RestLinksProviderProducer.class);
    }

    private LinksContainer getLinksContainer(ResteasyReactiveDeploymentInfoBuildItem deploymentInfoBuildItem, ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntriesBuildItem) {
        LinksContainerFactory linksContainerFactory = new LinksContainerFactory();
        return linksContainerFactory.getLinksContainer(resourceMethodEntriesBuildItem.getEntries());
    }

    private RuntimeValue<GetterAccessorsContainer> implementPathParameterValueGetters(IndexView index, ClassOutput classOutput, LinksContainer linksContainer, GetterAccessorsContainerRecorder getterAccessorsContainerRecorder, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer) {
        RuntimeValue getterAccessorsContainer = getterAccessorsContainerRecorder.newContainer();
        HashSet<GetterMetadata> implementedGetters = new HashSet<GetterMetadata>();
        for (List linkInfos : linksContainer.getLinksMap().values()) {
            for (LinkInfo linkInfo : linkInfos) {
                String entityType = linkInfo.getEntityType();
                for (String parameterName : linkInfo.getPathParameters()) {
                    FieldInfo fieldInfo = this.getFieldInfo(index, DotName.createSimple((String)entityType), parameterName);
                    GetterMetadata getterMetadata = new GetterMetadata(fieldInfo);
                    if (!implementedGetters.contains(getterMetadata)) {
                        this.implementGetterWithAccessor(classOutput, bytecodeTransformersProducer, getterMetadata);
                        implementedGetters.add(getterMetadata);
                    }
                    getterAccessorsContainerRecorder.addAccessor(getterAccessorsContainer, entityType, parameterName, getterMetadata.getGetterAccessorName());
                }
            }
        }
        return getterAccessorsContainer;
    }

    private void implementGetterWithAccessor(ClassOutput classOutput, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer, GetterMetadata getterMetadata) {
        bytecodeTransformersProducer.produce((BuildItem)new BytecodeTransformerBuildItem(getterMetadata.getEntityType(), GetterImplementor.getVisitorFunction(getterMetadata)));
        this.getterAccessorImplementor.implement(classOutput, getterMetadata);
    }

    private FieldInfo getFieldInfo(IndexView index, DotName className, String fieldName) {
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            throw new RuntimeException(String.format("Class '%s' was not found", className));
        }
        FieldInfo fieldInfo = classInfo.field(fieldName);
        if (fieldInfo != null) {
            return fieldInfo;
        }
        if (classInfo.superName() != null) {
            return this.getFieldInfo(index, classInfo.superName(), fieldName);
        }
        throw new RuntimeException(String.format("Class '%s' field '%s' was not found", className, fieldName));
    }
}

