/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.deployment;

import io.quarkus.resteasy.reactive.links.deployment.DotNames;
import io.quarkus.resteasy.reactive.links.runtime.LinkInfo;
import io.quarkus.resteasy.reactive.links.runtime.LinksContainer;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.util.URLUtils;

final class LinksContainerFactory {
    private static final String LIST = "list";
    private static final String SELF = "self";
    private static final String REMOVE = "remove";
    private static final String UPDATE = "update";
    private static final String ADD = "add";

    LinksContainerFactory() {
    }

    LinksContainer getLinksContainer(List<ResteasyReactiveResourceMethodEntriesBuildItem.Entry> entries, IndexView index) {
        LinksContainer linksContainer = new LinksContainer();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : entries) {
            MethodInfo resourceMethodInfo = entry.getMethodInfo();
            AnnotationInstance restLinkAnnotation = resourceMethodInfo.annotation(DotNames.REST_LINK_ANNOTATION);
            if (restLinkAnnotation == null) continue;
            LinkInfo linkInfo = this.getLinkInfo(entry.getResourceMethod(), resourceMethodInfo, restLinkAnnotation, entry.getBasicResourceClassInfo().getPath(), index);
            linksContainer.put(linkInfo);
        }
        return linksContainer;
    }

    private LinkInfo getLinkInfo(ResourceMethod resourceMethod, MethodInfo resourceMethodInfo, AnnotationInstance restLinkAnnotation, String resourceClassPath, IndexView index) {
        Type returnType = this.getNonAsyncReturnType(resourceMethodInfo.returnType());
        String rel = this.getAnnotationValue(restLinkAnnotation, "rel", this.deductRel(resourceMethod, returnType, index));
        String entityType = this.getAnnotationValue(restLinkAnnotation, "entityType", this.deductEntityType(returnType));
        String path = UriBuilder.fromPath((String)resourceClassPath).path(resourceMethod.getPath()).toTemplate();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Set<String> pathParameters = this.getPathParameters(path);
        return new LinkInfo(rel, entityType, path, pathParameters);
    }

    private String deductRel(ResourceMethod resourceMethod, Type returnType, IndexView index) {
        String httpMethod = resourceMethod.getHttpMethod();
        boolean isCollection = this.isCollection(returnType, index);
        if ("GET".equals(httpMethod) && isCollection) {
            return LIST;
        }
        if ("GET".equals(httpMethod)) {
            return SELF;
        }
        if ("DELETE".equals(httpMethod)) {
            return REMOVE;
        }
        if ("PUT".equals(httpMethod)) {
            return UPDATE;
        }
        if ("POST".equals(httpMethod)) {
            return ADD;
        }
        return resourceMethod.getName();
    }

    private String deductEntityType(Type returnType) {
        if (returnType.kind() == Type.Kind.PARAMETERIZED_TYPE && returnType.asParameterizedType().arguments().size() == 1) {
            return ((Type)returnType.asParameterizedType().arguments().get(0)).name().toString();
        }
        return returnType.name().toString();
    }

    private Set<String> getPathParameters(String path) {
        HashSet names = new HashSet();
        URLUtils.parsePathParameters((String)path, names);
        HashSet<String> trimmedNames = new HashSet<String>(names.size());
        for (String name : names) {
            trimmedNames.add(name.trim());
        }
        return trimmedNames;
    }

    private String getAnnotationValue(AnnotationInstance annotationInstance, String name, String defaultValue) {
        AnnotationValue value = annotationInstance.value(name);
        if (value == null || value.asString().equals("")) {
            return defaultValue;
        }
        return value.asString();
    }

    private boolean isCollection(Type type, IndexView index) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo classInfo = index.getClassByName(type.name());
        if (classInfo == null) {
            return false;
        }
        return classInfo.interfaceNames().stream().anyMatch(arg_0 -> ((DotName)DotName.createSimple((String)Collection.class.getName())).equals(arg_0));
    }

    private Type getNonAsyncReturnType(Type returnType) {
        switch (returnType.kind()) {
            case ARRAY: 
            case CLASS: 
            case PRIMITIVE: 
            case VOID: {
                return returnType;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = returnType.asParameterizedType();
                if (ResteasyReactiveDotNames.COMPLETION_STAGE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.COMPLETABLE_FUTURE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.UNI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.MULTI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.REST_MULTI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.REST_RESPONSE.equals((Object)parameterizedType.name())) {
                    return (Type)parameterizedType.arguments().get(0);
                }
                return returnType;
            }
        }
        return returnType;
    }
}

