/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.links.RestLinkId;
import io.quarkus.resteasy.reactive.links.deployment.GetterAccessorImplementor;
import io.quarkus.resteasy.reactive.links.deployment.GetterImplementor;
import io.quarkus.resteasy.reactive.links.deployment.GetterMetadata;
import io.quarkus.resteasy.reactive.links.deployment.LinksContainerFactory;
import io.quarkus.resteasy.reactive.links.deployment.LinksMethodScanner;
import io.quarkus.resteasy.reactive.links.runtime.GetterAccessorsContainer;
import io.quarkus.resteasy.reactive.links.runtime.GetterAccessorsContainerRecorder;
import io.quarkus.resteasy.reactive.links.runtime.LinkInfo;
import io.quarkus.resteasy.reactive.links.runtime.LinksContainer;
import io.quarkus.resteasy.reactive.links.runtime.LinksProviderRecorder;
import io.quarkus.resteasy.reactive.links.runtime.RestLinksProviderProducer;
import io.quarkus.resteasy.reactive.links.runtime.hal.HalServerResponseFilter;
import io.quarkus.resteasy.reactive.links.runtime.hal.ResteasyReactiveHalService;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerResponseFilterBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;

final class LinksProcessor {
    private final GetterAccessorImplementor getterAccessorImplementor = new GetterAccessorImplementor();

    LinksProcessor() {
    }

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_REACTIVE_LINKS));
    }

    @BuildStep
    MethodScannerBuildItem linksSupport() {
        return new MethodScannerBuildItem((MethodScanner)new LinksMethodScanner());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initializeLinksProvider(JaxRsResourceIndexBuildItem indexBuildItem, ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntriesBuildItem, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer, BuildProducer<GeneratedClassBuildItem> generatedClassesProducer, GetterAccessorsContainerRecorder getterAccessorsContainerRecorder, LinksProviderRecorder linksProviderRecorder) {
        IndexView index = indexBuildItem.getIndexView();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassesProducer, true);
        LinksContainer linksContainer = this.getLinksContainer(resourceMethodEntriesBuildItem, index);
        RuntimeValue<GetterAccessorsContainer> getterAccessorsContainer = this.implementPathParameterValueGetters(index, (ClassOutput)classOutput, linksContainer, getterAccessorsContainerRecorder, bytecodeTransformersProducer);
        linksProviderRecorder.setGetterAccessorsContainer(getterAccessorsContainer);
        linksProviderRecorder.setLinksContainer(linksContainer);
    }

    @BuildStep
    AdditionalBeanBuildItem registerRestLinksProviderProducer() {
        return AdditionalBeanBuildItem.unremovableOf(RestLinksProviderProducer.class);
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void validateJsonNeededForHal(Capabilities capabilities, ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntriesBuildItem) {
        boolean isHalSupported = capabilities.isPresent("io.quarkus.hal");
        if (isHalSupported && this.isHalMediaTypeUsedInAnyResource(resourceMethodEntriesBuildItem.getEntries()) && !capabilities.isPresent("io.quarkus.resteasy.reactive.json.jsonb") && !capabilities.isPresent("io.quarkus.resteasy.reactive.json.jackson")) {
            throw new IllegalStateException("Cannot generate HAL endpoints without either 'quarkus-resteasy-reactive-jsonb' or 'quarkus-resteasy-reactive-jackson'");
        }
    }

    @BuildStep
    void addHalSupport(Capabilities capabilities, BuildProducer<CustomContainerResponseFilterBuildItem> customResponseFilters, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        boolean isHalSupported = capabilities.isPresent("io.quarkus.hal");
        if (isHalSupported) {
            customResponseFilters.produce((BuildItem)new CustomContainerResponseFilterBuildItem(HalServerResponseFilter.class.getName()));
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ResteasyReactiveHalService.class));
        }
    }

    private boolean isHalMediaTypeUsedInAnyResource(List<ResteasyReactiveResourceMethodEntriesBuildItem.Entry> entries) {
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : entries) {
            for (String mediaType : entry.getResourceMethod().getProduces()) {
                if (!"application/hal+json".equals(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    private LinksContainer getLinksContainer(ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntriesBuildItem, IndexView index) {
        LinksContainerFactory linksContainerFactory = new LinksContainerFactory();
        return linksContainerFactory.getLinksContainer(resourceMethodEntriesBuildItem.getEntries(), index);
    }

    private RuntimeValue<GetterAccessorsContainer> implementPathParameterValueGetters(IndexView index, ClassOutput classOutput, LinksContainer linksContainer, GetterAccessorsContainerRecorder getterAccessorsContainerRecorder, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer) {
        RuntimeValue getterAccessorsContainer = getterAccessorsContainerRecorder.newContainer();
        HashSet<GetterMetadata> implementedGetters = new HashSet<GetterMetadata>();
        for (List linkInfos : linksContainer.getLinksMap().values()) {
            for (LinkInfo linkInfo : linkInfos) {
                String entityType = linkInfo.getEntityType();
                DotName className = DotName.createSimple((String)entityType);
                this.validateClassHasFieldId(index, entityType);
                for (String parameterName : linkInfo.getPathParameters()) {
                    FieldInfo fieldInfo = this.resolveField(index, parameterName, className);
                    if (fieldInfo == null) continue;
                    GetterMetadata getterMetadata = new GetterMetadata(fieldInfo);
                    if (!implementedGetters.contains(getterMetadata)) {
                        this.implementGetterWithAccessor(classOutput, bytecodeTransformersProducer, getterMetadata);
                        implementedGetters.add(getterMetadata);
                    }
                    getterAccessorsContainerRecorder.addAccessor(getterAccessorsContainer, entityType, parameterName, getterMetadata.getGetterAccessorName());
                }
            }
        }
        return getterAccessorsContainer;
    }

    private FieldInfo resolveField(IndexView index, String parameterName, DotName className) {
        FieldInfoSupplier byAnnotation;
        FieldInfo annotatedField;
        FieldInfoSupplier byParamName = new FieldInfoSupplier(c -> c.field(parameterName), className, index);
        FieldInfo fieldInfo = byParamName.get();
        if (parameterName.equals("id") && (annotatedField = (byAnnotation = new FieldInfoSupplier(c -> {
            FieldInfo persistenceId = null;
            for (FieldInfo field : c.fields()) {
                if (field.hasAnnotation(RestLinkId.class)) {
                    return field;
                }
                if (!this.fieldAnnotatedWith(field, "persistence.Id") || persistenceId != null) continue;
                persistenceId = field;
            }
            return persistenceId;
        }, className, index)).get()) != null) {
            fieldInfo = annotatedField;
        }
        return fieldInfo;
    }

    private boolean fieldAnnotatedWith(FieldInfo field, String annotation) {
        List annotationInstances = field.annotations();
        for (AnnotationInstance annotationInstance : annotationInstances) {
            if (!annotationInstance.name().toString().endsWith(annotation)) continue;
            return true;
        }
        return false;
    }

    private void validateClassHasFieldId(IndexView index, String entityType) {
        DotName className = DotName.createSimple((String)entityType);
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            throw new RuntimeException(String.format("Class '%s' was not found", classInfo));
        }
        this.validateRec(index, entityType, classInfo);
    }

    private void validateRec(IndexView index, String entityType, ClassInfo classInfo) {
        List<FieldInfo> fieldsNamedId = classInfo.fields().stream().filter(f -> f.name().equals("id")).toList();
        List<AnnotationInstance> fieldsAnnotatedWithId = classInfo.fields().stream().flatMap(f -> f.annotations().stream()).filter(a -> a.name().toString().endsWith("persistence.Id")).toList();
        List fieldsAnnotatedWithRestLinkId = classInfo.fields().stream().flatMap(f -> f.annotations(RestLinkId.class).stream()).toList();
        if (fieldsAnnotatedWithRestLinkId.size() > 1) {
            throw new IllegalStateException("Cannot generate web links for the class " + entityType + " because it has multiple fields annotated with `@RestLinkId`, where a maximum of one is allowed");
        }
        if (!(fieldsNamedId.isEmpty() && fieldsAnnotatedWithId.isEmpty() && fieldsAnnotatedWithRestLinkId.isEmpty())) {
            return;
        }
        DotName superClassName = classInfo.superName();
        if (superClassName == null) {
            throw new IllegalStateException("Cannot generate web links for the class " + entityType + " because it is either missing an `id` field, a field with an `@Id` annotation or a field with a `@RestLinkId annotation");
        }
        classInfo = index.getClassByName(superClassName);
        if (classInfo == null) {
            throw new RuntimeException(String.format("Class '%s' was not found", classInfo));
        }
        this.validateRec(index, entityType, classInfo);
    }

    private void implementGetterWithAccessor(ClassOutput classOutput, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer, GetterMetadata getterMetadata) {
        bytecodeTransformersProducer.produce((BuildItem)new BytecodeTransformerBuildItem(getterMetadata.getEntityType(), GetterImplementor.getVisitorFunction(getterMetadata)));
        this.getterAccessorImplementor.implement(classOutput, getterMetadata);
    }

    private static class FieldInfoSupplier
    implements Supplier<FieldInfo> {
        private final Function<ClassInfo, FieldInfo> strategy;
        private final DotName className;
        private final IndexView index;

        public FieldInfoSupplier(Function<ClassInfo, FieldInfo> strategy, DotName className, IndexView index) {
            this.strategy = strategy;
            this.className = className;
            this.index = index;
        }

        @Override
        public FieldInfo get() {
            return this.findFieldRecursively(this.className);
        }

        private FieldInfo findFieldRecursively(DotName className) {
            ClassInfo classInfo = this.index.getClassByName(className);
            if (classInfo == null) {
                throw new RuntimeException(String.format("Class '%s' was not found", className));
            }
            FieldInfo result = this.strategy.apply(classInfo);
            if (result != null) {
                return result;
            }
            if (classInfo.superName() != null && !classInfo.superName().equals((Object)ResteasyReactiveDotNames.OBJECT_NAME)) {
                return this.findFieldRecursively(classInfo.superName());
            }
            return null;
        }
    }
}

