/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.qute.runtime;

import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.resteasy.reactive.qute.runtime.Util;
import io.smallrye.mutiny.Uni;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

public class TemplateResponseFilter {
    @Inject
    Engine engine;

    @ServerResponseFilter
    public Uni<Void> filter(ResteasyReactiveContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Object entity = responseContext.getEntity();
        if (!(entity instanceof TemplateInstance)) {
            return null;
        }
        TemplateInstance instance = (TemplateInstance)entity;
        MediaType selectedMediaType = Util.setSelectedVariant(instance, requestContext.getRequest(), HeaderUtil.getAcceptableLanguages((MultivaluedMap)requestContext.getHeaders()));
        MediaType mediaType = selectedMediaType == null ? responseContext.getMediaType() : selectedMediaType;
        Uni<String> uni = Util.toUni(instance, this.engine);
        return uni.chain(r -> {
            if (mediaType != null) {
                responseContext.setEntity(r, null, mediaType);
            } else {
                responseContext.setEntity(r);
            }
            return Uni.createFrom().nullItem();
        });
    }
}

