/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.qute.runtime;

import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

public class TemplateResponseFilter {
    @ServerResponseFilter
    public Uni<Void> filter(ResteasyReactiveContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        MediaType mediaType;
        Object entity = responseContext.getEntity();
        if (!(entity instanceof TemplateInstance)) {
            return null;
        }
        TemplateInstance instance = (TemplateInstance)entity;
        Object variantsAttr = instance.getAttribute("variants");
        if (variantsAttr != null) {
            ArrayList<javax.ws.rs.core.Variant> variants = new ArrayList<javax.ws.rs.core.Variant>();
            for (Variant variant : (List)variantsAttr) {
                variants.add(new javax.ws.rs.core.Variant(MediaType.valueOf((String)variant.getMediaType()), variant.getLocale(), variant.getEncoding()));
            }
            javax.ws.rs.core.Variant selected = requestContext.getRequest().selectVariant(variants);
            if (selected != null) {
                List acceptableLocales;
                Locale selectedLocale = selected.getLanguage();
                if (selectedLocale == null && !(acceptableLocales = requestContext.getAcceptableLanguages()).isEmpty()) {
                    selectedLocale = (Locale)acceptableLocales.get(0);
                }
                instance.setAttribute("selectedVariant", (Object)new Variant(selectedLocale, selected.getMediaType().toString(), selected.getEncoding()));
                mediaType = selected.getMediaType();
            } else {
                mediaType = responseContext.getMediaType();
            }
        } else {
            mediaType = responseContext.getMediaType();
        }
        return instance.createUni().chain(r -> {
            if (mediaType != null) {
                responseContext.setEntity(r, null, mediaType);
            } else {
                responseContext.setEntity(r);
            }
            return Uni.createFrom().nullItem();
        });
    }
}

