/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.qute.runtime;

import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class Util {
    private Util() {
    }

    static Uni<String> toUni(TemplateInstance instance, Engine engine) {
        Uni uni = instance.createUni();
        if (!engine.useAsyncTimeout()) {
            long timeout = instance.getTimeout();
            uni = uni.ifNoItem().after(Duration.ofMillis(timeout)).failWith(() -> new TemplateException(instance + " rendering timeout [" + timeout + "ms] occurred"));
        }
        return uni;
    }

    static MediaType setSelectedVariant(TemplateInstance result, Request request, List<Locale> acceptableLanguages) {
        Object variantsAttr = result.getAttribute("variants");
        if (variantsAttr != null) {
            List quteVariants = (List)variantsAttr;
            ArrayList<jakarta.ws.rs.core.Variant> jaxRsVariants = new ArrayList<jakarta.ws.rs.core.Variant>(quteVariants.size());
            for (Variant variant : quteVariants) {
                jaxRsVariants.add(new jakarta.ws.rs.core.Variant(MediaType.valueOf((String)variant.getMediaType()), variant.getLocale(), variant.getEncoding()));
            }
            jakarta.ws.rs.core.Variant selected = request.selectVariant(jaxRsVariants);
            if (selected != null) {
                Locale selectedLocale = selected.getLanguage();
                if (selectedLocale == null && !acceptableLanguages.isEmpty()) {
                    selectedLocale = acceptableLanguages.get(0);
                }
                result.setAttribute("selectedVariant", (Object)new Variant(selectedLocale, selected.getMediaType().toString(), selected.getEncoding()));
                return selected.getMediaType();
            }
        }
        return null;
    }
}

