/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.servlet.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.servlet.http.HttpServletRequest;

public class ServletResteasyReactiveInputStream
extends InputStream {
    ByteBuffer existingData;
    HttpServletRequest request;
    InputStream delegate;

    public ServletResteasyReactiveInputStream(ByteBuffer existingData, HttpServletRequest request) {
        if (existingData.remaining() > 0) {
            this.existingData = existingData;
        }
        this.request = request;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.existingData != null) {
            int read = Math.min(len, this.existingData.remaining());
            this.existingData.get(b, off, read);
            if (this.existingData.remaining() == 0) {
                this.existingData = null;
            }
            return read;
        }
        if (this.delegate == null) {
            this.delegate = this.request.getInputStream();
        }
        return this.delegate.read(b, off, len);
    }
}

