/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.FileUploadImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;

public class MultipartFormHandler
implements RuntimeConfigurableServerRestHandler {
    private static final Logger LOG = Logger.getLogger(MultipartFormHandler.class);
    private static final ByteArrayInputStream NO_BYTES_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private volatile String uploadsDirectory;
    private volatile boolean deleteUploadedFilesOnEnd;
    private volatile Optional<Long> maxBodySize;

    public void configure(RuntimeConfiguration configuration) {
        this.uploadsDirectory = configuration.body().uploadsDirectory();
        this.deleteUploadedFilesOnEnd = configuration.body().deleteUploadedFilesOnEnd();
        this.maxBodySize = configuration.limits().maxBodySize();
        try {
            Files.createDirectories(Paths.get(this.uploadsDirectory, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void handle(ResteasyReactiveRequestContext context) throws Exception {
        if (context.hasInputStream()) {
            return;
        }
        if (context.serverRequest().getRequestMethod().equals("GET") || context.serverRequest().getRequestMethod().equals("HEAD")) {
            return;
        }
        HttpServerRequest httpServerRequest = (HttpServerRequest)context.serverRequest().unwrap(HttpServerRequest.class);
        if (httpServerRequest.isEnded()) {
            context.setInputStream((InputStream)NO_BYTES_INPUT_STREAM);
        } else {
            httpServerRequest.setExpectMultipart(true);
            httpServerRequest.pause();
            context.suspend();
            final MultipartFormVertxHandler handler = new MultipartFormVertxHandler(context, this.uploadsDirectory, this.deleteUploadedFilesOnEnd, this.maxBodySize);
            httpServerRequest.handler((Handler)handler);
            httpServerRequest.endHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    handler.end();
                }
            });
            httpServerRequest.resume();
        }
    }

    private static class MultipartFormVertxHandler
    implements Handler<Buffer> {
        private final ResteasyReactiveRequestContext rrContext;
        private final RoutingContext context;
        private final String uploadsDirectory;
        private final boolean deleteUploadedFilesOnEnd;
        private final Optional<Long> maxBodySize;
        boolean failed;
        AtomicInteger uploadCount = new AtomicInteger();
        AtomicBoolean cleanup = new AtomicBoolean(false);
        boolean ended;
        long uploadSize = 0L;

        public MultipartFormVertxHandler(final ResteasyReactiveRequestContext rrContext, String uploadsDirectory, boolean deleteUploadedFilesOnEnd, final Optional<Long> maxBodySize) {
            this.rrContext = rrContext;
            this.context = (RoutingContext)rrContext.serverRequest().unwrap(RoutingContext.class);
            this.uploadsDirectory = uploadsDirectory;
            this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
            this.maxBodySize = maxBodySize;
            final Set fileUploads = this.context.fileUploads();
            this.context.request().setExpectMultipart(true);
            this.context.request().uploadHandler((Handler)new Handler<HttpServerFileUpload>(){

                public void handle(HttpServerFileUpload upload) {
                    long size;
                    if (maxBodySize.isPresent() && upload.isSizeAvailable() && (size = uploadSize + upload.size()) > (Long)maxBodySize.get()) {
                        failed = true;
                        rrContext.resume((Throwable)new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE));
                        return;
                    }
                    uploadCount.incrementAndGet();
                    String uploadedFileName = new File(uploadsDirectory, UUID.randomUUID().toString()).getPath();
                    upload.streamToFileSystem(uploadedFileName);
                    FileUploadImpl fileUpload = new FileUploadImpl(uploadedFileName, upload);
                    fileUploads.add(fileUpload);
                    upload.exceptionHandler((Handler)new Handler<Throwable>(){

                        public void handle(Throwable t) {
                            this.deleteFileUploads();
                            rrContext.resume((Throwable)new WebApplicationException(t, Response.Status.INTERNAL_SERVER_ERROR));
                        }
                    });
                    upload.endHandler((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            this.uploadEnded();
                        }
                    });
                }
            });
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (this.maxBodySize.isPresent() && this.uploadSize > this.maxBodySize.get()) {
                this.failed = true;
                this.context.vertx().runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void v) {
                        this.deleteFileUploads();
                    }
                });
                this.rrContext.resume((Throwable)new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE));
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (this.ended && count == 0) {
                this.doEnd();
            }
        }

        void end() {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                this.deleteFileUploads();
                return;
            }
            if (this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler(x -> this.deleteFileUploads());
            }
            this.rrContext.setInputStream((InputStream)NO_BYTES_INPUT_STREAM);
            this.rrContext.resume();
        }

        private void deleteFileUploads() {
            if (this.cleanup.compareAndSet(false, true)) {
                for (FileUpload fileUpload : this.context.fileUploads()) {
                    FileSystem fileSystem = this.context.vertx().fileSystem();
                    String uploadedFileName = fileUpload.uploadedFileName();
                    fileSystem.exists(uploadedFileName, existResult -> {
                        if (existResult.failed()) {
                            LOG.warn((Object)("Could not detect if uploaded file exists, not deleting: " + uploadedFileName), existResult.cause());
                        } else if (((Boolean)existResult.result()).booleanValue()) {
                            fileSystem.delete(uploadedFileName, deleteResult -> {
                                if (deleteResult.failed()) {
                                    LOG.warn((Object)("Delete of uploaded file failed: " + uploadedFileName), deleteResult.cause());
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

