/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.Path;
import org.eclipse.microprofile.config.ConfigProvider;

public class ResteasyReactiveTestHttpProvider
implements TestHttpEndpointProvider {
    public Function<Class<?>, String> endpointProvider() {
        return new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> aClass) {
                String value = ResteasyReactiveTestHttpProvider.this.getPath(aClass);
                if (value == null) {
                    return null;
                }
                if (value.startsWith("/")) {
                    value = value.substring(1);
                }
                String path = "/";
                Optional appPath = ConfigProvider.getConfig().getOptionalValue("quarkus.rest.path", String.class);
                if (appPath.isPresent()) {
                    path = (String)appPath.get();
                }
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                value = path + value;
                return value;
            }
        };
    }

    private String getPath(Class<?> aClass) {
        String value = null;
        for (Annotation annotation : aClass.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(Path.class.getName())) continue;
            try {
                value = (String)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                break;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (value == null) {
            Object i;
            Object[] objectArray = aClass.getInterfaces();
            int n = objectArray.length;
            for (int j = 0; j < n && (value = this.getPath((Class<?>)(i = objectArray[j]))) == null; ++j) {
            }
        }
        if (value == null && aClass.getSuperclass() != Object.class) {
            value = this.getPath(aClass.getSuperclass());
        }
        return value;
    }
}

