/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;

@Recorder
public class ResteasyReactiveRuntimeRecorder {
    public void configure(RuntimeValue<Deployment> deployment, final HttpConfiguration configuration) {
        List runtimeConfigurableServerRestHandlers = ((Deployment)deployment.getValue()).getRuntimeConfigurableServerRestHandlers();
        for (RuntimeConfigurableServerRestHandler handler : runtimeConfigurableServerRestHandlers) {
            handler.configure(new RuntimeConfiguration(){

                public Duration readTimeout() {
                    return configuration.readTimeout;
                }

                public RuntimeConfiguration.Body body() {
                    return new RuntimeConfiguration.Body(){

                        public boolean deleteUploadedFilesOnEnd() {
                            return configuration.body.deleteUploadedFilesOnEnd;
                        }

                        public String uploadsDirectory() {
                            return configuration.body.uploadsDirectory;
                        }
                    };
                }

                public RuntimeConfiguration.Limits limits() {
                    return new RuntimeConfiguration.Limits(){

                        public Optional<Long> maxBodySize() {
                            if (configuration.limits.maxBodySize.isPresent()) {
                                return Optional.of(((MemorySize)configuration.limits.maxBodySize.get()).asLongValue());
                            }
                            return Optional.empty();
                        }
                    };
                }
            });
        }
    }
}

