/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.filters;

import io.smallrye.mutiny.Uni;
import java.util.Optional;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static void handleOptional(Optional<Response> optional, ResteasyReactiveContainerRequestContext context) {
        if (optional != null && optional.isPresent()) {
            context.abortWith(optional.get());
        }
    }

    public static void handleResponse(Response response, ResteasyReactiveContainerRequestContext context) {
        if (response != null) {
            context.abortWith(response);
        }
    }

    public static void handleUniVoid(Uni<Void> uni, final ResteasyReactiveContainerRequestContext context) {
        if (uni == null) {
            return;
        }
        context.suspend();
        uni.subscribe().with((Consumer)new Consumer<Void>(){

            @Override
            public void accept(Void unused) {
                context.resume();
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                context.resume(throwable);
            }
        });
    }

    public static void handleUniResponse(Uni<Response> uni, final ResteasyReactiveContainerRequestContext context) {
        if (uni == null) {
            return;
        }
        context.suspend();
        uni.subscribe().with((Consumer)new Consumer<Response>(){

            @Override
            public void accept(Response response) {
                if (response != null) {
                    context.abortWith(response);
                } else {
                    context.resume();
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                context.resume(throwable);
            }
        });
    }
}

