/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.multipart;

import io.quarkus.resteasy.reactive.server.runtime.multipart.QuarkusFileUpload;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public final class MultipartSupport {
    private static final Logger log = Logger.getLogger(RequestDeserializeHandler.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    private MultipartSupport() {
    }

    public static Object convertFormAttribute(String value, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        if (value == null) {
            return null;
        }
        ServerSerialisers serialisers = context.getDeployment().getSerialisers();
        List readers = serialisers.findReaders(null, type, mediaType, RuntimeType.SERVER);
        if (readers.isEmpty()) {
            throw new NotSupportedException();
        }
        for (MessageBodyReader reader : readers) {
            if (reader instanceof ServerMessageBodyReader) {
                ServerMessageBodyReader serverMessageBodyReader = (ServerMessageBodyReader)reader;
                if (!serverMessageBodyReader.isReadable(type, genericType, context.getTarget().getLazyMethod(), mediaType)) continue;
                InputStream originalInputStream = context.getInputStream();
                try {
                    context.setInputStream((InputStream)MultipartSupport.formAttributeValueToInputStream(value));
                    Object object = serverMessageBodyReader.readFrom(type, genericType, mediaType, (ServerRequestContext)context);
                    return object;
                }
                catch (IOException e) {
                    log.debug((Object)"Error occurred during deserialization of input", (Throwable)e);
                    throw new InternalServerErrorException((Throwable)e);
                }
                finally {
                    context.setInputStream(originalInputStream);
                }
            }
            if (!reader.isReadable(type, genericType, EMPTY_ANNOTATIONS, mediaType)) continue;
            try {
                return reader.readFrom(type, genericType, EMPTY_ANNOTATIONS, mediaType, context.getHttpHeaders().getRequestHeaders(), (InputStream)MultipartSupport.formAttributeValueToInputStream(value));
            }
            catch (IOException e) {
                log.debug((Object)"Error occurred during deserialization of input", (Throwable)e);
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        throw new NotSupportedException("Media type '" + mediaType + "' in multipart request is not supported");
    }

    public static QuarkusFileUpload getFileUpload(String formName, ResteasyReactiveRequestContext context) {
        List<QuarkusFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        if (!uploads.isEmpty()) {
            return uploads.get(0);
        }
        return null;
    }

    public static List<QuarkusFileUpload> getFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<QuarkusFileUpload> result = new ArrayList<QuarkusFileUpload>();
        RoutingContext routingContext = (RoutingContext)context.unwrap(RoutingContext.class);
        Set fileUploads = routingContext.fileUploads();
        for (FileUpload fileUpload : fileUploads) {
            if (!fileUpload.name().equals(formName)) continue;
            result.add(new QuarkusFileUpload(fileUpload));
        }
        return result;
    }

    public static List<File> getJavaIOFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<File> result = new ArrayList<File>();
        List<QuarkusFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (QuarkusFileUpload upload : uploads) {
            result.add(upload.uploadedFile().toFile());
        }
        return result;
    }

    public static List<Path> getJavaPathFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<Path> result = new ArrayList<Path>();
        List<QuarkusFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (QuarkusFileUpload upload : uploads) {
            result.add(upload.uploadedFile());
        }
        return result;
    }

    public static List<QuarkusFileUpload> getFileUploads(ResteasyReactiveRequestContext context) {
        RoutingContext routingContext = (RoutingContext)context.unwrap(RoutingContext.class);
        Set fileUploads = routingContext.fileUploads();
        ArrayList<QuarkusFileUpload> result = new ArrayList<QuarkusFileUpload>(fileUploads.size());
        for (FileUpload fileUpload : fileUploads) {
            result.add(new QuarkusFileUpload(fileUpload));
        }
        return result;
    }

    private static ByteArrayInputStream formAttributeValueToInputStream(String formAttributeValue) {
        return new ByteArrayInputStream(formAttributeValue.getBytes(StandardCharsets.UTF_8));
    }
}

