/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.multipart;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.multipart.DefaultFileUpload;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public final class MultipartSupport {
    private static final Logger log = Logger.getLogger(RequestDeserializeHandler.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    private MultipartSupport() {
    }

    public static Object convertFormAttribute(String value, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        if (value == null) {
            return null;
        }
        ServerSerialisers serialisers = context.getDeployment().getSerialisers();
        List readers = serialisers.findReaders(null, type, mediaType, RuntimeType.SERVER);
        if (readers.isEmpty()) {
            throw new NotSupportedException();
        }
        for (MessageBodyReader reader : readers) {
            if (reader instanceof ServerMessageBodyReader) {
                ServerMessageBodyReader serverMessageBodyReader = (ServerMessageBodyReader)reader;
                if (!serverMessageBodyReader.isReadable(type, genericType, context.getTarget().getLazyMethod(), mediaType)) continue;
                InputStream originalInputStream = context.getInputStream();
                try {
                    context.setInputStream((InputStream)MultipartSupport.formAttributeValueToInputStream(value));
                    Object object = serverMessageBodyReader.readFrom(type, genericType, mediaType, (ServerRequestContext)context);
                    return object;
                }
                catch (IOException e) {
                    log.debug((Object)"Error occurred during deserialization of input", (Throwable)e);
                    throw new InternalServerErrorException((Throwable)e);
                }
                finally {
                    context.setInputStream(originalInputStream);
                }
            }
            if (!reader.isReadable(type, genericType, EMPTY_ANNOTATIONS, mediaType)) continue;
            try {
                return reader.readFrom(type, genericType, EMPTY_ANNOTATIONS, mediaType, context.getHttpHeaders().getRequestHeaders(), (InputStream)MultipartSupport.formAttributeValueToInputStream(value));
            }
            catch (IOException e) {
                log.debug((Object)"Error occurred during deserialization of input", (Throwable)e);
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        throw new NotSupportedException("Media type '" + mediaType + "' in multipart request is not supported");
    }

    public static DefaultFileUpload getFileUpload(String formName, ResteasyReactiveRequestContext context) {
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        if (!uploads.isEmpty()) {
            return uploads.get(0);
        }
        return null;
    }

    public static List<DefaultFileUpload> getFileUploads(String formName, ResteasyReactiveRequestContext context) {
        Deque fileUploadsForName;
        ArrayList<DefaultFileUpload> result = new ArrayList<DefaultFileUpload>();
        FormData fileUploads = context.getFormData();
        if (fileUploads != null && (fileUploadsForName = fileUploads.get(formName)) != null) {
            for (FormData.FormValue fileUpload : fileUploadsForName) {
                if (!fileUpload.isFileItem()) continue;
                result.add(new DefaultFileUpload(formName, fileUpload));
            }
        }
        return result;
    }

    public static List<File> getJavaIOFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<File> result = new ArrayList<File>();
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (DefaultFileUpload upload : uploads) {
            result.add(upload.uploadedFile().toFile());
        }
        return result;
    }

    public static List<Path> getJavaPathFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<Path> result = new ArrayList<Path>();
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (DefaultFileUpload upload : uploads) {
            result.add(upload.uploadedFile());
        }
        return result;
    }

    public static List<DefaultFileUpload> getFileUploads(ResteasyReactiveRequestContext context) {
        FormData formData = context.getFormData();
        if (formData == null) {
            return Collections.emptyList();
        }
        ArrayList<DefaultFileUpload> result = new ArrayList<DefaultFileUpload>();
        for (String name : formData) {
            for (FormData.FormValue fileUpload : formData.get(name)) {
                if (!fileUpload.isFileItem()) continue;
                result.add(new DefaultFileUpload(name, fileUpload));
            }
        }
        return result;
    }

    private static ByteArrayInputStream formAttributeValueToInputStream(String formAttributeValue) {
        return new ByteArrayInputStream(formAttributeValue.getBytes(StandardCharsets.UTF_8));
    }
}

