/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.vertx.http.runtime.HttpCompression;
import io.vertx.core.http.HttpHeaders;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ResteasyReactiveCompressionHandler
implements ServerRestHandler {
    private HttpCompression compression;
    private Set<String> compressMediaTypes;
    private String produces;
    private volatile EncodedMediaType encodedProduces;

    public ResteasyReactiveCompressionHandler() {
    }

    public ResteasyReactiveCompressionHandler(Set<String> compressMediaTypes) {
        this.compressMediaTypes = compressMediaTypes;
    }

    public HttpCompression getCompression() {
        return this.compression;
    }

    public void setCompression(HttpCompression compression) {
        this.compression = compression;
    }

    public Set<String> getCompressMediaTypes() {
        return this.compressMediaTypes;
    }

    public void setCompressMediaTypes(Set<String> compressMediaTypes) {
        this.compressMediaTypes = compressMediaTypes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        ServerHttpResponse response = requestContext.serverResponse();
        String contentEncoding = response.getResponseHeader("Content-Encoding");
        if (contentEncoding != null && HttpHeaders.IDENTITY.toString().equals(contentEncoding)) {
            switch (this.compression) {
                case ON: {
                    response.removeResponseHeader("Content-Encoding");
                    break;
                }
                case UNDEFINED: {
                    MediaType contentType;
                    EncodedMediaType responseContentType = requestContext.getResponseContentType();
                    if (responseContentType == null && this.produces != null) {
                        if (this.encodedProduces == null) {
                            ResteasyReactiveCompressionHandler resteasyReactiveCompressionHandler = this;
                            synchronized (resteasyReactiveCompressionHandler) {
                                if (this.encodedProduces == null) {
                                    this.encodedProduces = new EncodedMediaType(MediaType.valueOf((String)this.produces));
                                }
                            }
                        }
                        responseContentType = this.encodedProduces;
                    }
                    if (responseContentType == null || (contentType = responseContentType.getMediaType()) == null || !this.compressMediaTypes.contains(contentType.getType() + "/" + contentType.getSubtype())) break;
                    response.removeResponseHeader("Content-Encoding");
                    break;
                }
            }
        }
    }
}

