/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.resteasy.reactive.common.runtime.VertxAsyncFileMessageBodyWriter;
import io.vertx.core.Handler;
import io.vertx.core.file.AsyncFile;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

@Provider
public class ServerVertxAsyncFileMessageBodyWriter
extends VertxAsyncFileMessageBodyWriter
implements ServerMessageBodyWriter<AsyncFile> {
    public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
        return AsyncFile.class.isAssignableFrom(type);
    }

    public void writeResponse(final AsyncFile file, Type genericType, ServerRequestContext context) throws WebApplicationException {
        final ResteasyReactiveRequestContext ctx = (ResteasyReactiveRequestContext)context;
        ctx.suspend();
        final ServerHttpResponse response = context.serverResponse();
        if (file.getReadLength() != Long.MAX_VALUE) {
            response.setResponseHeader((CharSequence)"Content-Length", (CharSequence)String.valueOf(file.getReadLength()));
        } else {
            response.setChunked(true);
        }
        file.handler(buffer -> {
            try {
                response.write(buffer.getBytes());
            }
            catch (Exception x) {
                ctx.resume((Throwable)x);
                return;
            }
            if (response.isWriteQueueFull()) {
                file.pause();
                response.addDrainHandler(new Runnable(){

                    @Override
                    public void run() {
                        file.resume();
                    }
                });
            }
        });
        file.endHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                file.close();
                response.end();
                ctx.resume();
            }
        });
    }
}

