/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveSecurityContext;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class SecurityContextOverrideHandler
implements ServerRestHandler {
    private volatile InjectableInstance<CurrentIdentityAssociation> currentIdentityAssociation;

    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (!requestContext.isSecurityContextSet()) {
            return;
        }
        SecurityContext modified = requestContext.getSecurityContext();
        if (modified instanceof ResteasyReactiveSecurityContext) {
            return;
        }
        this.updateIdentity(requestContext, modified);
    }

    private void updateIdentity(ResteasyReactiveRequestContext requestContext, final SecurityContext modified) {
        requestContext.requireCDIRequestScope();
        InjectableInstance<CurrentIdentityAssociation> instance = this.getCurrentIdentityAssociation();
        if (instance.isResolvable()) {
            CurrentIdentityAssociation currentIdentityAssociation = (CurrentIdentityAssociation)instance.get();
            Uni oldIdentity = currentIdentityAssociation.getDeferredIdentity();
            currentIdentityAssociation.setIdentity(oldIdentity.map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                @Override
                public SecurityIdentity apply(SecurityIdentity old) {
                    final Set oldCredentials = old.getCredentials();
                    final Map oldAttributes = old.getAttributes();
                    return new SecurityIdentity(){

                        public Principal getPrincipal() {
                            return modified.getUserPrincipal();
                        }

                        public boolean isAnonymous() {
                            return modified.getUserPrincipal() == null;
                        }

                        public Set<String> getRoles() {
                            throw new UnsupportedOperationException("retrieving all roles not supported when JAX-RS security context has been replaced");
                        }

                        public boolean hasRole(String role) {
                            return modified.isUserInRole(role);
                        }

                        public <T extends Credential> T getCredential(Class<T> credentialType) {
                            for (Credential cred : this.getCredentials()) {
                                if (!credentialType.isAssignableFrom(cred.getClass())) continue;
                                return (T)cred;
                            }
                            return null;
                        }

                        public Set<Credential> getCredentials() {
                            return oldCredentials;
                        }

                        public <T> T getAttribute(String name) {
                            return (T)oldAttributes.get(name);
                        }

                        public Map<String, Object> getAttributes() {
                            return oldAttributes;
                        }

                        public Uni<Boolean> checkPermission(Permission permission) {
                            return Uni.createFrom().nullItem();
                        }
                    };
                }
            }));
        }
    }

    private InjectableInstance<CurrentIdentityAssociation> getCurrentIdentityAssociation() {
        InjectableInstance<CurrentIdentityAssociation> identityAssociation = this.currentIdentityAssociation;
        if (identityAssociation == null) {
            this.currentIdentityAssociation = Arc.container().select(CurrentIdentityAssociation.class, new Annotation[0]);
            return this.currentIdentityAssociation;
        }
        return identityAssociation;
    }

    public static class Customizer
    implements HandlerChainCustomizer {
        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_PRE_MATCH) {
                return Collections.singletonList(new SecurityContextOverrideHandler());
            }
            return Collections.emptyList();
        }
    }
}

